/*
 * Decompiled with CFR 0.152.
 */
package savant.view.tracks;

import java.util.List;
import savant.api.adapter.DataSourceAdapter;
import savant.api.adapter.RangeAdapter;
import savant.api.data.ContinuousRecord;
import savant.api.data.Record;
import savant.api.util.Resolution;
import savant.exception.SavantTrackCreationCancelledException;
import savant.settings.ResolutionSettings;
import savant.util.AxisType;
import savant.util.ColourKey;
import savant.util.ColourScheme;
import savant.util.DrawingInstruction;
import savant.util.Range;
import savant.view.tracks.ContinuousTrackRenderer;
import savant.view.tracks.Track;

public class ContinuousTrack
extends Track {
    public ContinuousTrack(DataSourceAdapter track) throws SavantTrackCreationCancelledException {
        super(track, new ContinuousTrackRenderer());
    }

    @Override
    public void prepareForRendering(String ref, Range r) {
        Resolution res = this.getResolution(r);
        this.renderer.addInstruction(DrawingInstruction.PROGRESS, "Retrieving data...");
        this.requestData(ref, r);
        this.renderer.addInstruction(DrawingInstruction.RANGE, r);
        this.renderer.addInstruction(DrawingInstruction.RESOLUTION, (Object)res);
        this.renderer.addInstruction(DrawingInstruction.COLOUR_SCHEME, this.getColourScheme());
        this.renderer.addInstruction(DrawingInstruction.REFERENCE_EXISTS, this.containsReference(ref));
        this.renderer.addInstruction(DrawingInstruction.SELECTION_ALLOWED, true);
    }

    @Override
    public Resolution getResolution(RangeAdapter range) {
        return range.getLength() > ResolutionSettings.getContinuousLowToHighThreshold() ? Resolution.LOW : Resolution.HIGH;
    }

    @Override
    public AxisType getYAxisType(Resolution r) {
        return AxisType.REAL;
    }

    @Override
    public ColourScheme getDefaultColourScheme() {
        return new ColourScheme(ColourKey.CONTINUOUS_FILL, ColourKey.CONTINUOUS_LINE);
    }

    public static float[] getExtremeValues(List<Record> data) {
        float max = Float.MIN_VALUE;
        float min = Float.MAX_VALUE;
        if (data != null) {
            for (Record r : data) {
                float val = ((ContinuousRecord)r).getValue();
                if (val > max) {
                    max = val;
                }
                if (!(val < min)) continue;
                min = val;
            }
        }
        return new float[]{min, max};
    }
}

