/*
 * Decompiled with CFR 0.152.
 */
package savant.view.tracks;

import java.util.List;
import net.sf.samtools.SAMRecord;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.api.adapter.DataSourceAdapter;
import savant.api.adapter.RangeAdapter;
import savant.api.data.Record;
import savant.api.util.Resolution;
import savant.data.filters.BAMRecordFilter;
import savant.data.types.BAMIntervalRecord;
import savant.exception.RenderingException;
import savant.exception.SavantTrackCreationCancelledException;
import savant.settings.ResolutionSettings;
import savant.util.AxisRange;
import savant.util.AxisType;
import savant.util.ColourKey;
import savant.util.ColourScheme;
import savant.util.DrawingInstruction;
import savant.util.DrawingMode;
import savant.util.MiscUtils;
import savant.util.Range;
import savant.util.SAMReadUtils;
import savant.view.tracks.BAMTrackRenderer;
import savant.view.tracks.Track;

public class BAMTrack
extends Track {
    private static final Log LOG = LogFactory.getLog(BAMTrack.class);
    private SAMReadUtils.PairedSequencingProtocol pairedProtocol = SAMReadUtils.PairedSequencingProtocol.MATEPAIR;
    private int concordantMin = 50;
    private int concordantMax = 1000;
    private static int maxBPForYMax = 10000;
    private boolean baseQualityEnabled = false;
    private boolean mappingQualityEnabled = false;

    public BAMTrack(DataSourceAdapter dataSource) throws SavantTrackCreationCancelledException {
        super(dataSource, new BAMTrackRenderer());
        this.drawingMode = DrawingMode.MISMATCH;
    }

    @Override
    public ColourScheme getDefaultColourScheme() {
        return new ColourScheme(ColourKey.FORWARD_STRAND, ColourKey.REVERSE_STRAND, ColourKey.CONCORDANT_LENGTH, ColourKey.DISCORDANT_LENGTH, ColourKey.ONE_READ_INVERTED, ColourKey.EVERTED_PAIR);
    }

    @Override
    public DrawingMode[] getValidDrawingModes() {
        return new DrawingMode[]{DrawingMode.STANDARD, DrawingMode.MISMATCH, DrawingMode.SEQUENCE, DrawingMode.STANDARD_PAIRED, DrawingMode.ARC_PAIRED, DrawingMode.SNP, DrawingMode.STRAND_SNP};
    }

    @Override
    public void setDrawingMode(DrawingMode mode) {
        this.getFilter().setArcMode(mode == DrawingMode.ARC_PAIRED);
        super.setDrawingMode(mode);
    }

    @Override
    public void prepareForRendering(String ref, Range r) {
        DrawingMode mode = this.getDrawingMode();
        Resolution res = this.getResolution(r);
        if (res == Resolution.HIGH) {
            this.renderer.addInstruction(DrawingInstruction.PROGRESS, "Retrieving BAM data...");
            this.requestData(ref, r);
        } else {
            this.saveNullData(r);
            if (mode == DrawingMode.ARC_PAIRED) {
                this.renderer.addInstruction(DrawingInstruction.ERROR, ZOOM_MESSAGE);
            } else {
                this.renderer.addInstruction(DrawingInstruction.ERROR, new RenderingException("No coverage file available\nTo generate a coverage file, go to File > Format File", 0));
            }
        }
        this.renderer.addInstruction(DrawingInstruction.RANGE, r);
        this.renderer.addInstruction(DrawingInstruction.RESOLUTION, (Object)res);
        this.renderer.addInstruction(DrawingInstruction.COLOUR_SCHEME, this.getColourScheme());
        this.renderer.addInstruction(DrawingInstruction.PAIRED_PROTOCOL, (Object)this.pairedProtocol);
        boolean f = this.containsReference(ref);
        this.renderer.addInstruction(DrawingInstruction.REFERENCE_EXISTS, this.containsReference(ref));
        if (mode == DrawingMode.ARC_PAIRED) {
            this.renderer.addInstruction(DrawingInstruction.DISCORDANT_MIN, this.getConcordantMin());
            this.renderer.addInstruction(DrawingInstruction.DISCORDANT_MAX, this.getConcordantMax());
        } else {
            this.renderer.addInstruction(DrawingInstruction.AXIS_RANGE, new AxisRange(r, new Range(0, 1)));
        }
        this.renderer.addInstruction(DrawingInstruction.SELECTION_ALLOWED, mode != DrawingMode.SNP && mode != DrawingMode.STRAND_SNP);
        this.renderer.addInstruction(DrawingInstruction.MODE, (Object)mode);
        this.renderer.addInstruction(DrawingInstruction.BASE_QUALITY, this.baseQualityEnabled);
        this.renderer.addInstruction(DrawingInstruction.MAPPING_QUALITY, this.mappingQualityEnabled);
    }

    public static int getArcYMax(List<Record> data) {
        int max = 0;
        if (data != null) {
            for (Record r : data) {
                SAMRecord samRecord = ((BAMIntervalRecord)r).getSAMRecord();
                int val = Math.abs(samRecord.getInferredInsertSize());
                if (val > maxBPForYMax || val <= max) continue;
                max = val;
            }
        }
        return max;
    }

    @Override
    public Resolution getResolution(RangeAdapter range) {
        switch (this.getDrawingMode()) {
            case ARC_PAIRED: {
                return range.getLength() > ResolutionSettings.getBAMArcModeLowToHighThreshold() ? Resolution.LOW : Resolution.HIGH;
            }
        }
        return range.getLength() > ResolutionSettings.getBAMLowToHighThreshold() ? Resolution.LOW : Resolution.HIGH;
    }

    public int getConcordantMin() {
        return this.concordantMin;
    }

    public void setConcordantMin(int value) {
        this.concordantMin = value;
    }

    public int getConcordantMax() {
        return this.concordantMax;
    }

    public void setConcordantMax(int value) {
        this.concordantMax = value;
    }

    public void setPairedProtocol(SAMReadUtils.PairedSequencingProtocol t) {
        this.pairedProtocol = t;
    }

    public SAMReadUtils.PairedSequencingProtocol getPairedProtocol() {
        return this.pairedProtocol;
    }

    public int getMaxBPForYMax() {
        return maxBPForYMax;
    }

    public void setMaxBPForYMax(int max) {
        maxBPForYMax = max;
    }

    public BAMRecordFilter getFilter() {
        if (this.filter == null) {
            this.filter = new BAMRecordFilter();
        }
        return (BAMRecordFilter)this.filter;
    }

    public void setFilter(BAMRecordFilter value) {
        this.filter = value;
    }

    @Override
    public AxisType getYAxisType(Resolution r) {
        switch (this.getDrawingMode()) {
            case ARC_PAIRED: {
                return AxisType.INTEGER;
            }
            case SNP: 
            case STRAND_SNP: {
                return AxisType.REAL;
            }
        }
        return AxisType.INTEGER_GRIDLESS;
    }

    public BAMIntervalRecord getMate(BAMIntervalRecord rec) {
        List<Record> data = this.getDataInRange();
        SAMRecord samRec = rec.getSAMRecord();
        for (Record rec2 : data) {
            SAMRecord current = ((BAMIntervalRecord)rec2).getSAMRecord();
            if (!MiscUtils.isMate(samRec, current, false)) continue;
            return (BAMIntervalRecord)rec2;
        }
        return null;
    }

    public boolean toggleBaseQualityEnabled() {
        boolean result = false;
        if (this.baseQualityEnabled) {
            this.baseQualityEnabled = false;
        } else {
            this.baseQualityEnabled = true;
            if (this.mappingQualityEnabled) {
                this.mappingQualityEnabled = false;
                this.renderer.addInstruction(DrawingInstruction.MAPPING_QUALITY, false);
                result = true;
            }
        }
        this.renderer.addInstruction(DrawingInstruction.BASE_QUALITY, this.baseQualityEnabled);
        return result;
    }

    public boolean toggleMappingQualityEnabled() {
        boolean result = false;
        if (this.mappingQualityEnabled) {
            this.mappingQualityEnabled = false;
        } else {
            this.mappingQualityEnabled = true;
            if (this.baseQualityEnabled) {
                this.baseQualityEnabled = false;
                this.renderer.addInstruction(DrawingInstruction.BASE_QUALITY, false);
                result = true;
            }
        }
        this.renderer.addInstruction(DrawingInstruction.MAPPING_QUALITY, this.mappingQualityEnabled);
        return result;
    }
}

