/*
 * Decompiled with CFR 0.152.
 */
package savant.view.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import savant.settings.BrowserSettings;
import savant.view.swing.ImagePanel;

public class Splash
extends JDialog {
    JLabel status;
    String pad = "  ";
    int currentprogress;
    int totalprogress = 5;
    JProgressBar progress;
    private JPanel splashPanel;

    public Splash(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        Image i = new ImageIcon(this.getClass().getResource("/savant/images/splash2.png")).getImage();
        this.setPreferredSize(new Dimension(i.getWidth(null), i.getHeight(null)));
        this.setMaximumSize(new Dimension(i.getWidth(null), i.getHeight(null)));
        this.setMinimumSize(new Dimension(i.getWidth(null), i.getHeight(null)));
        ImagePanel ip = new ImagePanel(i);
        this.splashPanel.add((Component)ip, "Center");
        ip.setLayout(new BorderLayout());
        JPanel textPanel = new JPanel();
        textPanel.setOpaque(false);
        textPanel.setLayout(new BoxLayout(textPanel, 1));
        JLabel website = new JLabel(this.pad + "Website: " + BrowserSettings.URL);
        this.formatLabel(website, false);
        textPanel.add(website);
        JLabel authors = new JLabel(this.pad + "Authors: Computational Biology Lab @ University of Toronto");
        this.formatLabel(authors, false);
        textPanel.add(authors);
        textPanel.add(this.getPadding(2));
        JLabel version = new JLabel(this.pad + "Version: " + "2.0.4" + " " + BrowserSettings.BUILD);
        this.formatLabel(version, false);
        textPanel.add(version);
        textPanel.add(this.getPadding(2));
        this.status = new JLabel(modal ? "" : this.pad + "Initializing ...");
        this.formatLabel(this.status, true);
        textPanel.add(this.status);
        textPanel.add(this.getPadding(8));
        ip.add((Component)textPanel, "South");
        this.setLocationRelativeTo(null);
    }

    public final JPanel getPadding(int ps) {
        JPanel p = new JPanel();
        Dimension d = new Dimension(ps, ps);
        p.setMaximumSize(d);
        p.setMinimumSize(d);
        p.setPreferredSize(d);
        p.setOpaque(false);
        return p;
    }

    private void initComponents() {
        this.splashPanel = new JPanel();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.setUndecorated(true);
        this.splashPanel.setBackground(new Color(204, 204, 255));
        this.splashPanel.setPreferredSize(new Dimension(450, 150));
        GroupLayout splashPanelLayout = new GroupLayout(this.splashPanel);
        this.splashPanel.setLayout(splashPanelLayout);
        splashPanelLayout.setHorizontalGroup(splashPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 238, Short.MAX_VALUE));
        splashPanelLayout.setVerticalGroup(splashPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 144, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.splashPanel, -1, 238, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.splashPanel, -1, 144, Short.MAX_VALUE));
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Splash dialog = new Splash((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    void setStatus(String msg) {
        this.status.setText(this.pad + msg);
    }

    private void formatLabel(JLabel label, boolean isBold) {
        if (isBold) {
            label.setFont(new Font("Arial", 1, 11));
        } else {
            label.setFont(new Font("Arial", 0, 11));
        }
    }
}

