/*
 * Decompiled with CFR 0.152.
 */
package savant.view.swing;

import com.apple.eawt.AboutHandler;
import com.apple.eawt.AppEvent;
import com.apple.eawt.Application;
import com.apple.eawt.PreferencesHandler;
import com.apple.eawt.QuitHandler;
import com.apple.eawt.QuitResponse;
import com.jidesoft.docking.DefaultDockingManager;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.status.MemoryStatusBarItem;
import com.jidesoft.utils.Lm;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.RootPaneContainer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.samtools.SAMFileReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.savant.analytics.savantanalytics.AnalyticsAgent;
import savant.api.adapter.DataSourceAdapter;
import savant.api.event.BookmarksChangedEvent;
import savant.api.event.GenomeChangedEvent;
import savant.api.event.PluginEvent;
import savant.api.util.DialogUtils;
import savant.api.util.Listener;
import savant.controller.BookmarkController;
import savant.controller.DataSourcePluginController;
import savant.controller.FrameController;
import savant.controller.GenomeController;
import savant.controller.GraphPaneController;
import savant.controller.LocationController;
import savant.controller.ProjectController;
import savant.controller.RecentProjectsController;
import savant.controller.RecentTracksController;
import savant.controller.event.GraphPaneEvent;
import savant.controller.event.ProjectEvent;
import savant.plugin.PluginController;
import savant.plugin.SavantDataSourcePlugin;
import savant.plugin.SavantPanelPlugin;
import savant.plugin.SavantPlugin;
import savant.plugin.builtin.SAFEDataSourcePlugin;
import savant.plugin.builtin.SavantFileRepositoryDataSourcePlugin;
import savant.selection.SelectionController;
import savant.settings.BrowserSettings;
import savant.settings.ColourSettings;
import savant.settings.DirectorySettings;
import savant.settings.SettingsDialog;
import savant.util.ColourKey;
import savant.util.MiscUtils;
import savant.util.SavantHTTPAuthenticator;
import savant.util.Version;
import savant.util.error.report.BugReportDialog;
import savant.util.swing.TrackChooser;
import savant.view.dialog.DataFormatForm;
import savant.view.dialog.DataSourcePluginDialog;
import savant.view.dialog.FeatureRequestDialog;
import savant.view.dialog.LoadGenomeDialog;
import savant.view.dialog.LoadTrackDialog;
import savant.view.dialog.OpenURLDialog;
import savant.view.dialog.PluginManagerDialog;
import savant.view.icon.SavantIconFactory;
import savant.view.swing.BookmarkSheet;
import savant.view.swing.DockableFrameFactory;
import savant.view.swing.ExportImage;
import savant.view.swing.NavigationBar;
import savant.view.swing.PluginMenuItem;
import savant.view.swing.RangeSelectionPanel;
import savant.view.swing.Ruler;
import savant.view.swing.Splash;
import savant.view.swing.start.WelcomePage;
import savant.view.tracks.Track;
import savant.view.tracks.TrackFactory;
import savant.view.variation.VariationController;

public class Savant
extends JFrame {
    private static final Log LOG = LogFactory.getLog(Savant.class);
    public static boolean turnExperimentalFeaturesOff = true;
    private static boolean isDebugging = false;
    private DockingManager auxDockingManager;
    private JPanel trackBackground;
    private DockingManager trackDockingManager;
    private NavigationBar navigationBar;
    static boolean showNonGenomicReferenceDialog = true;
    private static boolean showBookmarksChangedDialog = false;
    private MemoryStatusBarItem memorystatusbar;
    private Application macOSXApplication;
    private boolean browserControlsShown = false;
    static BasicService basicService = null;
    static boolean webStart = false;
    private WelcomePage startpage;
    private final boolean isStandalone;
    static int minimumFormWidth = 500;
    static int minimumFormHeight = 500;
    private static JTextArea log;
    private RangeSelectionPanel rangeSelector;
    private Ruler ruler;
    private static BookmarkSheet favoriteSheet;
    private LocationController locationController = LocationController.getInstance();
    private static Savant instance;
    private File lastTrackDirectory = null;
    String bookmarkframeKey = "Bookmarks";
    String variationframeKey = "Variation";
    private JMenuItem bookmarkItem;
    private JCheckBoxMenuItem bookmarksItem;
    private JCheckBoxMenuItem crosshairItem;
    private JMenuItem deselectAllItem;
    private JMenu editMenu;
    private JMenuItem exitItem;
    private JMenuItem exportItem;
    private JMenu fileMenu;
    private JMenuItem formatItem;
    private JCheckBoxMenuItem genomeItem;
    private JMenu helpMenu;
    private JPopupMenu.Separator jSeparator10;
    private JPopupMenu.Separator jSeparator4;
    private JPopupMenu.Separator jSeparator7;
    private JLabel label_memory;
    private JLabel label_mouseposition_title;
    private JLabel label_status;
    private JMenuItem loadFromDataSourcePluginItem;
    private JMenuItem loadFromFileItem;
    private JMenuItem loadFromURLItem;
    private JMenuItem loadGenomeItem;
    private JMenuBar menuBar_top;
    private JMenuItem menuitem_pluginmanager;
    private JLabel mousePositionLabel;
    private JCheckBoxMenuItem navigationItem;
    private JMenuItem openProjectItem;
    private JMenuItem panLeftItem;
    private JMenuItem panRightItem;
    private JPanel panelExtendedMiddle;
    private JPanel panel_browser;
    private JPanel panel_main;
    private JPanel panel_top;
    private JPanel pluginToolbar;
    private JCheckBoxMenuItem pluginToolbarItem;
    private JMenu pluginsMenu;
    private JCheckBoxMenuItem plumblineItem;
    private JMenuItem preferencesItem;
    private JMenu recentProjectMenu;
    private JMenu recentTrackMenu;
    private JMenuItem redoItem;
    private JCheckBoxMenuItem rulerItem;
    private JToolBar.Separator s_e_sep;
    private JMenuItem saveProjectAsItem;
    private JMenuItem saveProjectItem;
    private JCheckBoxMenuItem speedAndEfficiencyItem;
    private JCheckBoxMenuItem spotlightItem;
    private JCheckBoxMenuItem statusBarItem;
    private JLabel timeCaption;
    private JMenuItem toEndItem;
    private JMenuItem toStartItem;
    private JToolBar toolbar_bottom;
    private JMenuItem tutorialsItem;
    private JMenuItem undoItem;
    private JMenuItem userManualItem;
    private JMenu viewMenu;
    private ButtonGroup view_buttongroup;
    private JMenuItem websiteItem;
    private JMenu windowMenu;
    private JMenuItem zoomInItem;
    private JMenuItem zoomOutItem;

    private void initDocking() {
        JPanel masterPlaceholderPanel = new JPanel();
        masterPlaceholderPanel.setLayout(new BorderLayout());
        this.panel_main.setLayout(new BorderLayout());
        this.panel_main.add((Component)masterPlaceholderPanel, "Center");
        this.auxDockingManager = new DefaultDockingManager((RootPaneContainer)this, (Container)masterPlaceholderPanel);
        masterPlaceholderPanel.setBackground(ColourSettings.getColor(ColourKey.SPLITTER));
        this.auxDockingManager.setSidebarRollover(false);
        this.auxDockingManager.getWorkspace().setBackground(ColourSettings.getColor(ColourKey.SPLITTER));
        this.auxDockingManager.setInitSplitPriority(2);
        JPanel trackPanel = new JPanel();
        trackPanel.setLayout(new BorderLayout());
        this.auxDockingManager.getWorkspace().add((Component)trackPanel, (Object)"Center");
        this.trackDockingManager = new DefaultDockingManager((RootPaneContainer)this, (Container)trackPanel);
        trackPanel.setBackground(ColourSettings.getColor(ColourKey.SPLITTER));
        this.trackDockingManager.getWorkspace().setBackground(ColourSettings.getColor(ColourKey.SPLITTER));
        this.trackDockingManager.getWorkspace().setBackground(Color.red);
        this.trackDockingManager.setInitNorthSplit(0);
        this.auxDockingManager.setShowInitial(false);
        this.trackDockingManager.setShowInitial(false);
        this.auxDockingManager.loadLayoutData();
        this.trackDockingManager.loadLayoutData();
        this.rangeSelector = new RangeSelectionPanel();
        this.rangeSelector.setPreferredSize(new Dimension(10000, 23));
        this.rangeSelector.setMaximumSize(new Dimension(10000, 23));
        this.locationController.addListener(this.rangeSelector);
        this.rangeSelector.setVisible(false);
        this.ruler = new Ruler();
        this.ruler.setPreferredSize(new Dimension(10000, 23));
        this.ruler.setMaximumSize(new Dimension(10000, 23));
        this.ruler.setVisible(false);
        Box box2 = Box.createVerticalBox();
        box2.add(this.rangeSelector);
        box2.add(this.ruler);
        trackPanel.add((Component)box2, "North");
        this.trackBackground = new JPanel();
        this.trackBackground.setBackground(Color.darkGray);
        this.trackBackground.setLayout(new BorderLayout());
        this.trackDockingManager.getWorkspace().add((Component)this.trackBackground);
        this.trackDockingManager.setAllowedDockSides(3);
    }

    public static synchronized Savant getInstance() {
        if (instance == null) {
            instance = new Savant();
        }
        return instance;
    }

    public static synchronized Savant getInstance(boolean isStandalone, boolean pluginsEnabled) {
        if (instance == null) {
            instance = new Savant(isStandalone, pluginsEnabled);
        }
        return instance;
    }

    private Savant() {
        this(true, true);
    }

    private Savant(boolean isStandalone, boolean pluginsEnabled) {
        this.isStandalone = isStandalone;
        try {
            basicService = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
            webStart = true;
        }
        catch (UnavailableServiceException e) {
            webStart = false;
        }
        instance = this;
        Splash s = new Splash((Frame)instance, false);
        if (this.isStandalone()) {
            s.setVisible(true);
        }
        Authenticator.setDefault(new SavantHTTPAuthenticator());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int width = Savant.this.getWidth();
                int height = Savant.this.getHeight();
                boolean resize = false;
                if (width < minimumFormWidth) {
                    resize = true;
                    width = minimumFormWidth;
                }
                if (height < minimumFormHeight) {
                    resize = true;
                    height = minimumFormHeight;
                }
                if (resize) {
                    Savant.this.setSize(width, height);
                }
            }
        });
        GraphPaneController.getInstance().addListener(new Listener<GraphPaneEvent>(){

            @Override
            public void handleEvent(GraphPaneEvent event) {
                GraphPaneController controller = GraphPaneController.getInstance();
                switch (event.getType()) {
                    case HIGHLIGHTING: {
                        Savant.this.plumblineItem.setSelected(controller.isPlumbing());
                        Savant.this.spotlightItem.setSelected(controller.isSpotlight());
                        Savant.this.crosshairItem.setSelected(controller.isAiming());
                        break;
                    }
                    case MOUSE: {
                        Savant.this.updateMousePosition(event.getMouseX(), event.getMouseY(), event.isYIntegral());
                        break;
                    }
                    case STATUS: {
                        Savant.this.updateStatus(event.getStatus());
                    }
                }
            }
        });
        ProjectController.getInstance().addListener(new Listener<ProjectEvent>(){

            @Override
            public void handleEvent(ProjectEvent event) {
                switch (event.getType()) {
                    case LOADING: {
                        String activity = "Loading " + event.getPath() + "...";
                        Savant.this.setTitle("Savant Genome Browser - " + activity);
                        break;
                    }
                    case LOADED: 
                    case SAVED: {
                        MiscUtils.setUnsavedTitle(Savant.this, "Savant Genome Browser - " + event.getPath(), false);
                        break;
                    }
                    case SAVING: {
                        String activity = "Saving " + event.getPath() + "...";
                        Savant.this.setTitle("Savant Genome Browser - " + activity);
                        break;
                    }
                    case UNSAVED: {
                        MiscUtils.setUnsavedTitle(Savant.this, "Savant Genome Browser - " + event.getPath(), true);
                    }
                }
            }
        });
        GenomeController.getInstance().addListener(new Listener<GenomeChangedEvent>(){

            @Override
            public void handleEvent(GenomeChangedEvent event) {
                LOG.info((Object)("Genome changed from " + event.getOldGenome() + " to " + event.getNewGenome()));
                Savant.this.loadGenomeItem.setText("Change genome...");
                Savant.this.showBrowserControls();
            }
        });
        s.setStatus("Initializing GUI");
        this.initComponents();
        this.customizeUI();
        this.init();
        this.initHiddenShortcuts();
        if (BrowserSettings.getCheckVersionOnStartup()) {
            s.setStatus("Checking version");
            Savant.checkVersion(false);
        }
        if (BrowserSettings.getCollectAnonymousUsage()) {
            Savant.logUsageStats();
        }
        if (pluginsEnabled) {
            s.setStatus("Loading plugins");
            PluginController pluginController = PluginController.getInstance();
            pluginController.addListener(new Listener<PluginEvent>(){

                @Override
                public void handleEvent(PluginEvent event) {
                    SavantPlugin plugin = event.getPlugin();
                    if (event.getType() == PluginEvent.Type.LOADED) {
                        if (plugin instanceof SavantPanelPlugin) {
                            DockableFrame f = DockableFrameFactory.createGUIPluginFrame(plugin.getTitle());
                            JPanel p = (JPanel)f.getContentPane();
                            p.setLayout(new BorderLayout());
                            p.add((Component)event.getCanvas(), "Center");
                            Savant.this.auxDockingManager.addFrame(f);
                            Savant.this.addPluginToMenu(new PluginMenuItem((SavantPanelPlugin)plugin));
                        } else if (event.getPlugin() instanceof SavantDataSourcePlugin) {
                            Savant.this.loadFromDataSourcePluginItem.setText("Load Track from Other Datasource...");
                        }
                    }
                }
            });
            pluginController.loadPlugins(DirectorySettings.getPluginsDirectory());
        }
        s.setStatus("Organizing layout");
        this.displayBookmarksPanel();
        if (turnExperimentalFeaturesOff) {
            this.disableExperimentalFeatures();
        }
        s.setVisible(false);
        if (this.isStandalone()) {
            this.makeGUIVisible();
        }
    }

    public final boolean isStandalone() {
        return this.isStandalone;
    }

    private void initComponents() {
        this.view_buttongroup = new ButtonGroup();
        this.toolbar_bottom = new JToolBar();
        this.label_mouseposition_title = new JLabel();
        this.mousePositionLabel = new JLabel();
        this.timeCaption = new JLabel();
        this.label_status = new JLabel();
        this.s_e_sep = new JToolBar.Separator();
        this.label_memory = new JLabel();
        this.panel_browser = new JPanel();
        this.panel_top = new JPanel();
        this.panelExtendedMiddle = new JPanel();
        this.panel_main = new JPanel();
        this.pluginToolbar = new JPanel();
        this.menuBar_top = new JMenuBar();
        this.fileMenu = new JMenu();
        this.loadGenomeItem = new JMenuItem();
        this.loadFromFileItem = new JMenuItem();
        this.loadFromURLItem = new JMenuItem();
        this.loadFromDataSourcePluginItem = new JMenuItem();
        this.recentTrackMenu = new JMenu();
        JPopupMenu.Separator jSeparator1 = new JPopupMenu.Separator();
        this.openProjectItem = new JMenuItem();
        this.recentProjectMenu = new JMenu();
        this.saveProjectItem = new JMenuItem();
        this.saveProjectAsItem = new JMenuItem();
        JPopupMenu.Separator jSeparator2 = new JPopupMenu.Separator();
        this.formatItem = new JMenuItem();
        JPopupMenu.Separator jSeparator3 = new JPopupMenu.Separator();
        this.exportItem = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.exitItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.undoItem = new JMenuItem();
        this.redoItem = new JMenuItem();
        JPopupMenu.Separator jSeparator6 = new JPopupMenu.Separator();
        this.bookmarkItem = new JMenuItem();
        this.deselectAllItem = new JMenuItem();
        this.jSeparator7 = new JPopupMenu.Separator();
        this.preferencesItem = new JMenuItem();
        this.viewMenu = new JMenu();
        this.panLeftItem = new JMenuItem();
        this.panRightItem = new JMenuItem();
        this.zoomInItem = new JMenuItem();
        this.zoomOutItem = new JMenuItem();
        this.toStartItem = new JMenuItem();
        this.toEndItem = new JMenuItem();
        JSeparator jSeparator8 = new JSeparator();
        this.crosshairItem = new JCheckBoxMenuItem();
        this.plumblineItem = new JCheckBoxMenuItem();
        this.spotlightItem = new JCheckBoxMenuItem();
        this.windowMenu = new JMenu();
        this.navigationItem = new JCheckBoxMenuItem();
        this.genomeItem = new JCheckBoxMenuItem();
        this.rulerItem = new JCheckBoxMenuItem();
        this.pluginToolbarItem = new JCheckBoxMenuItem();
        this.statusBarItem = new JCheckBoxMenuItem();
        this.speedAndEfficiencyItem = new JCheckBoxMenuItem();
        JSeparator jSeparator9 = new JSeparator();
        this.bookmarksItem = new JCheckBoxMenuItem();
        this.pluginsMenu = new JMenu();
        this.menuitem_pluginmanager = new JMenuItem();
        this.jSeparator10 = new JPopupMenu.Separator();
        this.helpMenu = new JMenu();
        this.userManualItem = new JMenuItem();
        this.tutorialsItem = new JMenuItem();
        JMenuItem checkForUpdatesItem = new JMenuItem();
        JMenuItem bugReportItem = new JMenuItem();
        JMenuItem featureRequestItem = new JMenuItem();
        JSeparator jSeparator11 = new JSeparator();
        this.websiteItem = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setBackground(new Color(204, 204, 204));
        this.toolbar_bottom.setFloatable(false);
        this.toolbar_bottom.setAlignmentX(1.0f);
        this.label_mouseposition_title.setText(" Position: ");
        this.toolbar_bottom.add(this.label_mouseposition_title);
        this.toolbar_bottom.add(this.mousePositionLabel);
        this.timeCaption.setText("Time: ");
        this.toolbar_bottom.add(this.timeCaption);
        this.label_status.setMaximumSize(new Dimension(300, 14));
        this.label_status.setMinimumSize(new Dimension(100, 14));
        this.label_status.setPreferredSize(new Dimension(100, 14));
        this.toolbar_bottom.add(this.label_status);
        this.toolbar_bottom.add(this.s_e_sep);
        this.label_memory.setText(" Memory: ");
        this.toolbar_bottom.add(this.label_memory);
        this.panel_top.setMaximumSize(new Dimension(1000, 30));
        this.panel_top.setMinimumSize(new Dimension(0, 0));
        this.panel_top.setPreferredSize(new Dimension(0, 30));
        this.panel_top.setLayout(new BorderLayout());
        this.panelExtendedMiddle.setMinimumSize(new Dimension(990, 30));
        this.panelExtendedMiddle.setPreferredSize(new Dimension(990, 30));
        GroupLayout panelExtendedMiddleLayout = new GroupLayout(this.panelExtendedMiddle);
        this.panelExtendedMiddle.setLayout(panelExtendedMiddleLayout);
        panelExtendedMiddleLayout.setHorizontalGroup(panelExtendedMiddleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 1045, Short.MAX_VALUE));
        panelExtendedMiddleLayout.setVerticalGroup(panelExtendedMiddleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 30, Short.MAX_VALUE));
        this.panel_top.add((Component)this.panelExtendedMiddle, "Center");
        this.panel_main.setBackground(new Color(153, 153, 153));
        this.panel_main.setMaximumSize(new Dimension(99999, 99999));
        this.panel_main.setMinimumSize(new Dimension(1, 1));
        this.panel_main.setPreferredSize(new Dimension(99999, 99999));
        GroupLayout panel_mainLayout = new GroupLayout(this.panel_main);
        this.panel_main.setLayout(panel_mainLayout);
        panel_mainLayout.setHorizontalGroup(panel_mainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        panel_mainLayout.setVerticalGroup(panel_mainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 532, Short.MAX_VALUE));
        this.pluginToolbar.setVisible(false);
        this.pluginToolbar.setPreferredSize(new Dimension(856, 24));
        this.pluginToolbar.setLayout(new FlowLayout(3));
        GroupLayout panel_browserLayout = new GroupLayout(this.panel_browser);
        this.panel_browser.setLayout(panel_browserLayout);
        panel_browserLayout.setHorizontalGroup(panel_browserLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panel_top, -1, 1045, Short.MAX_VALUE).addComponent(this.pluginToolbar, -1, -1, Short.MAX_VALUE).addComponent(this.panel_main, -1, 1045, Short.MAX_VALUE));
        panel_browserLayout.setVerticalGroup(panel_browserLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panel_browserLayout.createSequentialGroup().addContainerGap().addComponent(this.panel_top, -2, 30, -2).addGap(0, 0, 0).addComponent(this.pluginToolbar, -2, 24, -2).addGap(0, 0, 0).addComponent(this.panel_main, -1, 532, Short.MAX_VALUE)));
        this.fileMenu.setText("File");
        this.loadGenomeItem.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        this.loadGenomeItem.setText("Load Genome...");
        this.loadGenomeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Savant.this.loadGenomeItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.loadGenomeItem);
        this.loadFromFileItem.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        this.loadFromFileItem.setText("Load Track from File...");
        this.loadFromFileItem.setEnabled(false);
        this.loadFromFileItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Savant.this.loadFromFileItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.loadFromFileItem);
        this.loadFromURLItem.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        this.loadFromURLItem.setText("Load Track from URL...");
        this.loadFromURLItem.setEnabled(false);
        this.loadFromURLItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Savant.this.loadFromURLItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.loadFromURLItem);
        this.loadFromDataSourcePluginItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.loadFromDataSourcePluginItem.setText("Load Track from Repository...");
        this.loadFromDataSourcePluginItem.setEnabled(false);
        this.loadFromDataSourcePluginItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Savant.this.loadFromDataSourcePluginItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.loadFromDataSourcePluginItem);
        this.recentTrackMenu.setText("Load Recent Track");
        this.fileMenu.add(this.recentTrackMenu);
        this.fileMenu.add(jSeparator1);
        this.openProjectItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.openProjectItem.setText("Open Project...");
        this.openProjectItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Savant.this.openProjectItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openProjectItem);
        this.recentProjectMenu.setText("Open Recent Project");
        this.fileMenu.add(this.recentProjectMenu);
        this.saveProjectItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveProjectItem.setText("Save Project");
        this.saveProjectItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Savant.this.saveProjectItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveProjectItem);
        this.saveProjectAsItem.setAccelerator(KeyStroke.getKeyStroke(83, 3));
        this.saveProjectAsItem.setText("Save Project As...");
        this.saveProjectAsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Savant.this.saveProjectAsItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveProjectAsItem);
        this.fileMenu.add(jSeparator2);
        this.formatItem.setText("Format File...");
        this.formatItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Savant.this.formatItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.formatItem);
        this.fileMenu.add(jSeparator3);
        this.exportItem.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        this.exportItem.setText("Export Track Images...");
        this.exportItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Savant.this.menuitem_exportActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exportItem);
        this.fileMenu.add(this.jSeparator4);
        this.exitItem.setText("Exit");
        this.exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Savant.this.exitItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitItem);
        this.menuBar_top.add(this.fileMenu);
        this.editMenu.setText("Edit");
        this.undoItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.undoItem.setText("Undo Range Change");
        this.undoItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Savant.this.undoItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.undoItem);
        this.redoItem.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        this.redoItem.setText("Redo Range Change");
        this.redoItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Savant.this.redoItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.redoItem);
        this.editMenu.add(jSeparator6);
        this.bookmarkItem.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        this.bookmarkItem.setText("Bookmark");
        this.bookmarkItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Savant.this.bookmarkItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.bookmarkItem);
        this.deselectAllItem.setText("Deselect All");
        this.deselectAllItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Savant.this.menuitem_deselectActionPerformed(evt);
            }
        });
        this.editMenu.add(this.deselectAllItem);
        this.editMenu.add(this.jSeparator7);
        this.preferencesItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.preferencesItem.setText("Preferences");
        this.preferencesItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Savant.this.preferencesItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.preferencesItem);
        this.menuBar_top.add(this.editMenu);
        this.viewMenu.setText("View");
        this.panLeftItem.setAccelerator(KeyStroke.getKeyStroke(37, 1));
        this.panLeftItem.setText("Pan Left");
        this.panLeftItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Savant.this.panLeftItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.panLeftItem);
        this.panRightItem.setAccelerator(KeyStroke.getKeyStroke(39, 1));
        this.panRightItem.setText("Pan Right");
        this.panRightItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Savant.this.panRightItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.panRightItem);
        this.zoomInItem.setAccelerator(KeyStroke.getKeyStroke(38, 1));
        this.zoomInItem.setText("Zoom In");
        this.zoomInItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Savant.this.zoomInItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.zoomInItem);
        this.zoomOutItem.setAccelerator(KeyStroke.getKeyStroke(40, 1));
        this.zoomOutItem.setText("Zoom Out");
        this.zoomOutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Savant.this.zoomOutItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.zoomOutItem);
        this.toStartItem.setAccelerator(KeyStroke.getKeyStroke(36, 0));
        this.toStartItem.setText("Shift to Start");
        this.toStartItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Savant.this.toStartItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.toStartItem);
        this.toEndItem.setAccelerator(KeyStroke.getKeyStroke(35, 0));
        this.toEndItem.setText("Shift to End");
        this.toEndItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Savant.this.toEndItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.toEndItem);
        this.viewMenu.add(jSeparator8);
        this.crosshairItem.setAccelerator(KeyStroke.getKeyStroke(74, 2));
        this.crosshairItem.setText("Crosshair");
        this.crosshairItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Savant.this.crosshairItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.crosshairItem);
        this.plumblineItem.setAccelerator(KeyStroke.getKeyStroke(75, 2));
        this.plumblineItem.setText("Plumbline");
        this.plumblineItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Savant.this.plumblineItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.plumblineItem);
        this.spotlightItem.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.spotlightItem.setText("Spotlight");
        this.spotlightItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Savant.this.spotlightItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.spotlightItem);
        this.menuBar_top.add(this.viewMenu);
        this.windowMenu.setText("Window");
        this.windowMenu.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Savant.this.windowMenuStateChanged(evt);
            }
        });
        this.navigationItem.setAccelerator(KeyStroke.getKeyStroke(82, 3));
        this.navigationItem.setText("Navigation");
        this.navigationItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Savant.this.navigationItemMousePressed(evt);
            }
        });
        this.windowMenu.add(this.navigationItem);
        this.genomeItem.setAccelerator(KeyStroke.getKeyStroke(67, 3));
        this.genomeItem.setText("Genome");
        this.genomeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Savant.this.genomeItemActionPerformed(evt);
            }
        });
        this.windowMenu.add(this.genomeItem);
        this.rulerItem.setAccelerator(KeyStroke.getKeyStroke(76, 3));
        this.rulerItem.setText("Ruler");
        this.rulerItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Savant.this.rulerItemActionPerformed(evt);
            }
        });
        this.windowMenu.add(this.rulerItem);
        this.pluginToolbarItem.setAccelerator(KeyStroke.getKeyStroke(84, 3));
        this.pluginToolbarItem.setSelected(true);
        this.pluginToolbarItem.setText("Plugin Toolbar");
        this.pluginToolbarItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Savant.this.pluginToolbarItemActionPerformed(evt);
            }
        });
        this.windowMenu.add(this.pluginToolbarItem);
        this.statusBarItem.setAccelerator(KeyStroke.getKeyStroke(83, 3));
        this.statusBarItem.setSelected(true);
        this.statusBarItem.setText("Status Bar");
        this.statusBarItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Savant.this.statusBarItemActionPerformed(evt);
            }
        });
        this.windowMenu.add(this.statusBarItem);
        this.speedAndEfficiencyItem.setText("Resources");
        this.speedAndEfficiencyItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Savant.this.speedAndEfficiencyItemActionPerformed(evt);
            }
        });
        this.windowMenu.add(this.speedAndEfficiencyItem);
        this.windowMenu.add(jSeparator9);
        this.bookmarksItem.setAccelerator(KeyStroke.getKeyStroke(66, 3));
        this.bookmarksItem.setText("Bookmarks");
        this.bookmarksItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Savant.this.bookmarksItemActionPerformed(evt);
            }
        });
        this.windowMenu.add(this.bookmarksItem);
        this.menuBar_top.add(this.windowMenu);
        this.pluginsMenu.setText("Plugins");
        this.menuitem_pluginmanager.setText("Plugin Manager\u2026");
        this.menuitem_pluginmanager.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Savant.this.menuitem_pluginmanagerActionPerformed(evt);
            }
        });
        this.pluginsMenu.add(this.menuitem_pluginmanager);
        this.pluginsMenu.add(this.jSeparator10);
        this.menuBar_top.add(this.pluginsMenu);
        this.helpMenu.setText("Help");
        this.userManualItem.setText("Manuals");
        this.userManualItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Savant.this.userManualItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.userManualItem);
        this.tutorialsItem.setText("Video Tutorials");
        this.tutorialsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Savant.this.tutorialsItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.tutorialsItem);
        checkForUpdatesItem.setText("Check for updates");
        checkForUpdatesItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Savant.this.checkForUpdatesItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(checkForUpdatesItem);
        bugReportItem.setText("Report an issue");
        bugReportItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Savant.this.bugReportItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(bugReportItem);
        featureRequestItem.setText("Request a feature");
        featureRequestItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Savant.this.featureRequestItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(featureRequestItem);
        this.helpMenu.add(jSeparator11);
        this.websiteItem.setText("Website");
        this.websiteItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Savant.this.websiteItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.websiteItem);
        this.menuBar_top.add(this.helpMenu);
        this.setJMenuBar(this.menuBar_top);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panel_browser, -2, -1, Short.MAX_VALUE).addComponent(this.toolbar_bottom, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.panel_browser, -2, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.toolbar_bottom, -2, 25, -2)));
        this.pack();
    }

    private void navigationItemMousePressed(ActionEvent evt) {
        this.panel_top.setVisible(!this.panel_top.isVisible());
    }

    private void zoomInItemActionPerformed(ActionEvent evt) {
        LocationController rc = LocationController.getInstance();
        rc.zoomIn();
    }

    private void zoomOutItemActionPerformed(ActionEvent evt) {
        LocationController rc = LocationController.getInstance();
        rc.zoomOut();
    }

    private void panLeftItemActionPerformed(ActionEvent evt) {
        LocationController rc = LocationController.getInstance();
        rc.shiftRangeLeft();
    }

    private void panRightItemActionPerformed(ActionEvent evt) {
        LocationController rc = LocationController.getInstance();
        rc.shiftRangeRight();
    }

    private void undoItemActionPerformed(ActionEvent evt) {
        LocationController rc = LocationController.getInstance();
        rc.undoLocationChange();
    }

    private void redoItemActionPerformed(ActionEvent evt) {
        LocationController rc = LocationController.getInstance();
        rc.redoLocationChange();
    }

    private void bookmarkItemActionPerformed(ActionEvent evt) {
        BookmarkController fc = BookmarkController.getInstance();
        fc.addCurrentRangeToBookmarks();
    }

    private void formatItemActionPerformed(ActionEvent evt) {
        LOG.info((Object)"Showing format form...");
        new DataFormatForm((Window)this, null, false).setVisible(true);
    }

    private void exitItemActionPerformed(ActionEvent evt) {
        Savant.getInstance().askToDispose();
    }

    private void loadGenomeItemActionPerformed(ActionEvent evt) {
        this.showOpenGenomeDialog();
    }

    private void loadFromFileItemActionPerformed(ActionEvent evt) {
        this.openTrackFromFile();
    }

    private void loadFromURLItemActionPerformed(ActionEvent evt) {
        this.openTrackFromURL();
    }

    private void websiteItemActionPerformed(ActionEvent evt) {
        try {
            Desktop.getDesktop().browse(BrowserSettings.URL.toURI());
        }
        catch (Exception ex) {
            LOG.error((Object)"Unable to access Savant website.", (Throwable)ex);
        }
    }

    private void menuitem_pluginmanagerActionPerformed(ActionEvent evt) {
        PluginManagerDialog.getInstance().setVisible(true);
    }

    private void plumblineItemActionPerformed(ActionEvent evt) {
        GraphPaneController gpc = GraphPaneController.getInstance();
        gpc.setPlumbing(this.plumblineItem.isSelected());
    }

    private void spotlightItemActionPerformed(ActionEvent evt) {
        GraphPaneController gpc = GraphPaneController.getInstance();
        gpc.setSpotlight(this.spotlightItem.isSelected());
    }

    private void windowMenuStateChanged(ChangeEvent evt) {
    }

    private void bookmarksItemActionPerformed(ActionEvent evt) {
        this.setBookmarksVisibile(this.auxDockingManager.getFrame(this.bookmarkframeKey).isHidden());
    }

    public void setBookmarksVisibile(boolean isVisible) {
        MiscUtils.setFrameVisibility(this.bookmarkframeKey, isVisible, this.auxDockingManager);
        this.bookmarksItem.setSelected(isVisible);
    }

    private void initVariationPanel() {
        DockableFrame df = DockableFrameFactory.createFrame("Variation", 0, 4);
        df.setAvailableButtons(28);
        this.auxDockingManager.addFrame(df);
        this.setVariantsVisibile(false);
        df.getContentPane().add(VariationController.getInstance().getModule());
    }

    public void setVariantsVisibile(boolean isVisible) {
        MiscUtils.setFrameVisibility(this.variationframeKey, isVisible, this.auxDockingManager);
    }

    private void tutorialsItemActionPerformed(ActionEvent evt) {
        try {
            Desktop.getDesktop().browse(BrowserSettings.MEDIA_URL.toURI());
        }
        catch (Exception ex) {
            LOG.error((Object)"Unable to access online tutorials.", (Throwable)ex);
        }
    }

    private void userManualItemActionPerformed(ActionEvent evt) {
        try {
            Desktop.getDesktop().browse(BrowserSettings.DOCUMENTATION_URL.toURI());
        }
        catch (Exception ex) {
            LOG.error((Object)"Unable to access online user manual.", (Throwable)ex);
        }
    }

    private void rulerItemActionPerformed(ActionEvent evt) {
        this.ruler.setVisible(!this.ruler.isVisible());
    }

    private void genomeItemActionPerformed(ActionEvent evt) {
        this.rangeSelector.setVisible(!this.rangeSelector.isVisible());
    }

    private void statusBarItemActionPerformed(ActionEvent evt) {
        this.toolbar_bottom.setVisible(!this.toolbar_bottom.isVisible());
    }

    private void menuitem_exportActionPerformed(ActionEvent evt) {
        ExportImage unused = new ExportImage();
    }

    private void toStartItemActionPerformed(ActionEvent evt) {
        this.locationController.shiftRangeFarLeft();
    }

    private void toEndItemActionPerformed(ActionEvent evt) {
        this.locationController.shiftRangeFarRight();
    }

    private void preferencesItemActionPerformed(ActionEvent evt) {
        SettingsDialog dlg = new SettingsDialog(this);
        dlg.setVisible(true);
    }

    private void menuitem_deselectActionPerformed(ActionEvent evt) {
        SelectionController.getInstance().removeAll();
    }

    private void saveProjectAsItemActionPerformed(ActionEvent evt) {
        try {
            ProjectController.getInstance().promptToSaveProjectAs();
        }
        catch (Exception x) {
            DialogUtils.displayException("Savant Error", "Unable to save project.", x);
        }
    }

    private void openProjectItemActionPerformed(ActionEvent evt) {
        try {
            ProjectController.getInstance().promptToLoadProject();
        }
        catch (Exception x) {
            DialogUtils.displayException("Savant Error", "Unable to open project.", x);
        }
    }

    private void checkForUpdatesItemActionPerformed(ActionEvent evt) {
        Savant.checkVersion(true);
    }

    private void saveProjectItemActionPerformed(ActionEvent evt) {
        try {
            ProjectController.getInstance().promptToSaveProject();
        }
        catch (Exception x) {
            DialogUtils.displayException("Savant Error", "Unable to save project.", x);
        }
    }

    private void pluginToolbarItemActionPerformed(ActionEvent evt) {
        this.pluginToolbar.setVisible(this.pluginToolbarItem.isSelected());
    }

    private void speedAndEfficiencyItemActionPerformed(ActionEvent evt) {
        this.setSpeedAndEfficiencyIndicatorsVisible(this.speedAndEfficiencyItem.isSelected());
    }

    private void crosshairItemActionPerformed(ActionEvent evt) {
        GraphPaneController gpc = GraphPaneController.getInstance();
        gpc.setAiming(this.crosshairItem.isSelected());
    }

    private void loadFromDataSourcePluginItemActionPerformed(ActionEvent evt) {
        this.openTrackFromRepository();
    }

    private void featureRequestItemActionPerformed(ActionEvent evt) {
        new FeatureRequestDialog().setVisible(true);
    }

    private void bugReportItemActionPerformed(ActionEvent evt) {
        new BugReportDialog(this).setVisible(true);
    }

    public static void main(String[] args) {
        AnalyticsAgent.onStartSession((String)"Savant", (String)"2.0.4");
        try {
            boolean loadProject = false;
            boolean loadPlugin = false;
            String loadProjectUrl = null;
            ArrayList<String> loadPluginUrls = new ArrayList<String>();
            for (int i = 0; i < args.length; ++i) {
                String s = args[i];
                if (s.startsWith("--")) {
                    loadProject = false;
                    loadPlugin = false;
                    BrowserSettings.BUILD = s.replaceAll("-", "");
                    if (!s.equals("--debug")) continue;
                    turnExperimentalFeaturesOff = false;
                    continue;
                }
                if (s.startsWith("-")) {
                    if (s.equals("-project")) {
                        loadProject = true;
                        loadPlugin = false;
                        continue;
                    }
                    if (!s.equals("-plugins")) continue;
                    loadPlugin = true;
                    loadProject = false;
                    continue;
                }
                if (loadProject) {
                    loadProjectUrl = s;
                    loadProject = false;
                    continue;
                }
                if (!loadPlugin) continue;
                loadPluginUrls.add(s);
            }
            System.setProperty("java.net.useSystemProxies", "true");
            Savant.installMissingPlugins(loadPluginUrls);
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            Lm.verifyLicense((String)"Marc Fiume", (String)"Savant Genome Browser", (String)"1BimsQGmP.vjmoMbfkPdyh0gs3bl3932");
            UIManager.put("JideSplitPaneDivider.border", 5);
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SAMFileReader.setDefaultValidationStringency((SAMFileReader.ValidationStringency)SAMFileReader.ValidationStringency.SILENT);
            if (MiscUtils.WINDOWS) {
                LookAndFeelFactory.installJideExtension((int)6);
            }
            if (Savant.getInstance().isWebStart() && loadProjectUrl != null) {
                ProjectController.getInstance().loadProjectFromURL(loadProjectUrl);
            }
        }
        catch (Exception x) {
            LOG.error((Object)"Error in main()", (Throwable)x);
        }
    }

    private static void logUsageStats() {
        try {
            URLConnection urlConn = BrowserSettings.LOG_USAGE_STATS_URL.openConnection();
            urlConn.setDoInput(true);
            urlConn.setDoOutput(true);
            urlConn.setUseCaches(false);
            urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            DataOutputStream printout = new DataOutputStream(urlConn.getOutputStream());
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            Date date = new Date();
            Locale locale = Locale.getDefault();
            String content = Savant.post("time", dateFormat.format(date)) + "&" + Savant.post("language", locale.getDisplayLanguage()) + "&" + Savant.post("user.timezone", System.getProperty("user.timezone")) + "&" + Savant.post("savant.version", "2.0.4") + "&" + Savant.post("savant.build", BrowserSettings.BUILD) + "&" + Savant.post("java.version", System.getProperty("java.version")) + "&" + Savant.post("java.vendor", System.getProperty("java.vendor")) + "&" + Savant.post("os.name", System.getProperty("os.name")) + "&" + Savant.post("os.arch", System.getProperty("os.arch")) + "&" + Savant.post("os.version", System.getProperty("os.version")) + "&" + Savant.post("user.region", System.getProperty("user.region"));
            printout.writeBytes(content);
            printout.flush();
            printout.close();
            urlConn.getInputStream();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String post(String id, String msg) {
        try {
            return id + "=" + id + ":" + (msg == null ? "null" : URLEncoder.encode(msg, "UTF-8"));
        }
        catch (UnsupportedEncodingException ignored) {
            return null;
        }
    }

    public static void checkVersion(boolean verbose) {
        try {
            Version latestVersion = Version.fromURL(BrowserSettings.VERSION_URL);
            Version ourVersion = new Version("2.0.4");
            int diff = latestVersion.compareTo(ourVersion);
            if (diff > 0) {
                DialogUtils.displayMessage("Savant", "A new version of Savant (" + latestVersion + ") is available.\n" + "To stop this message from appearing, download the newest version at " + BrowserSettings.URL + "\nor disable automatic " + "checking in Preferences.");
            } else if (diff == 0 && BrowserSettings.isBeta()) {
                DialogUtils.displayMessage("Savant", "The release version of Savant (" + latestVersion + ") is available.\n" + "Please upgrade this beta version to the official release.");
            } else if (verbose) {
                DialogUtils.displayMessage("Savant", "This version of Savant (" + ourVersion + ") is up to date.");
            }
        }
        catch (IOException x) {
            if (verbose) {
                DialogUtils.displayMessage("Savant Warning", "Could not connect to server. Please ensure you have connection to the internet and try again.");
            }
            LOG.error((Object)"Error downloading version file", (Throwable)x);
        }
    }

    private void customizeUI() {
        if (MiscUtils.MAC) {
            try {
                this.macOSXApplication = Application.getApplication();
                this.macOSXApplication.setAboutHandler(new AboutHandler(){

                    public void handleAbout(AppEvent.AboutEvent evt) {
                        final Splash dlg = new Splash((Frame)instance, true);
                        dlg.addMouseListener(new MouseAdapter(){

                            @Override
                            public void mouseClicked(MouseEvent e) {
                                dlg.setVisible(false);
                            }
                        });
                        dlg.setVisible(true);
                    }
                });
                this.macOSXApplication.setPreferencesHandler(new PreferencesHandler(){

                    public void handlePreferences(AppEvent.PreferencesEvent evt) {
                        Savant.this.preferencesItemActionPerformed(null);
                    }
                });
                this.macOSXApplication.setQuitHandler(new QuitHandler(){

                    public void handleQuitRequestWith(AppEvent.QuitEvent evt, QuitResponse resp) {
                        Savant.this.exitItemActionPerformed(null);
                        resp.cancelQuit();
                    }
                });
                this.fileMenu.remove(this.jSeparator4);
                this.fileMenu.remove(this.exitItem);
                this.editMenu.remove(this.jSeparator7);
                this.editMenu.remove(this.preferencesItem);
            }
            catch (Throwable x) {
                LOG.error((Object)"Unable to load Apple eAWT classes.", x);
                DialogUtils.displayError("Warning", "Savant requires Java for Mac OS X 10.6 Update 3 (or later).\nPlease check Software Update for the latest version.");
            }
        }
        LookAndFeelFactory.UIDefaultsCustomizer uiDefaultsCustomizer = new LookAndFeelFactory.UIDefaultsCustomizer(){

            public void customize(UIDefaults defaults) {
                ThemePainter painter = (ThemePainter)UIDefaultsLookup.get((Object)"Theme.painter");
                defaults.put("OptionPaneUI", "com.jidesoft.plaf.basic.BasicJideOptionPaneUI");
                defaults.put("OptionPane.showBanner", Boolean.TRUE);
                defaults.put("OptionPane.bannerFontSize", (Object)13);
                defaults.put("OptionPane.bannerFontStyle", (Object)1);
                defaults.put("OptionPane.bannerMaxCharsPerLine", (Object)60);
                defaults.put("OptionPane.bannerForeground", Color.BLACK);
                defaults.put("OptionPane.bannerBorder", (Object)null);
                defaults.put("OptionPane.bannerBackgroundPaint", (Object)null);
                defaults.put("OptionPane.buttonAreaBorder", BorderFactory.createEmptyBorder(6, 6, 6, 6));
                defaults.put("OptionPane.buttonOrientation", (Object)4);
            }
        };
        uiDefaultsCustomizer.customize(UIManager.getDefaults());
    }

    private void init() {
        this.initGUIFrame();
        this.initDocking();
        this.initMenu();
        this.initStatusBar();
        this.initBookmarksPanel();
        this.initVariationPanel();
        this.initDataSources();
        this.initStartPage();
    }

    private void disableExperimentalFeatures() {
    }

    public DockingManager getAuxDockingManager() {
        return this.auxDockingManager;
    }

    public DockingManager getTrackDockingManager() {
        return this.trackDockingManager;
    }

    private void initBookmarksPanel() {
        DockableFrame df = DockableFrameFactory.createFrame("Bookmarks", 0, 4);
        df.setAvailableButtons(28);
        this.auxDockingManager.addFrame(df);
        MiscUtils.setFrameVisibility("Bookmarks", false, this.auxDockingManager);
        df.getContentPane().setLayout(new BorderLayout());
        favoriteSheet = new BookmarkSheet(df.getContentPane());
        BookmarkController bc = BookmarkController.getInstance();
        bc.addListener(favoriteSheet);
        bc.addListener(new Listener<BookmarksChangedEvent>(){

            @Override
            public void handleEvent(BookmarksChangedEvent event) {
                if (showBookmarksChangedDialog) {
                    Object[] options = new Object[]{"OK", "Don't show again"};
                    int n = JOptionPane.showOptionDialog(Savant.this, event.isAdded() ? "Bookmark added at " + event.getBookmark().getReference() + ":" + event.getBookmark().getRange() : "Bookmark removed at " + event.getBookmark().getRange(), "Bookmarks changed", 1, 1, null, options, options[0]);
                    if (n == 1) {
                        showBookmarksChangedDialog = false;
                    }
                }
            }
        });
    }

    private void askToDispose() {
        try {
            if (ProjectController.getInstance().promptToSaveChanges(true)) {
                PluginController.getInstance().shutDown();
                LOG.info((Object)"Quitting");
                AnalyticsAgent.onEndSession((boolean)true);
                System.exit(0);
            }
        }
        catch (Exception x) {
            DialogUtils.displayException("Error", "Unable to save project file.", x);
        }
    }

    void initGUIFrame() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Savant.this.askToDispose();
            }
        });
        this.setIconImage(SavantIconFactory.getInstance().getIcon(SavantIconFactory.StandardIcon.LOGO).getImage());
        this.setTitle("Savant Genome Browser");
        this.setName("Savant Genome Browser");
    }

    private void initMenu() {
        this.loadGenomeItem.setAccelerator(KeyStroke.getKeyStroke(71, MiscUtils.MENU_MASK));
        this.loadFromFileItem.setAccelerator(KeyStroke.getKeyStroke(84, MiscUtils.MENU_MASK));
        this.loadFromURLItem.setAccelerator(KeyStroke.getKeyStroke(85, MiscUtils.MENU_MASK));
        this.loadFromDataSourcePluginItem.setAccelerator(KeyStroke.getKeyStroke(69, MiscUtils.MENU_MASK));
        this.openProjectItem.setAccelerator(KeyStroke.getKeyStroke(79, MiscUtils.MENU_MASK));
        this.saveProjectItem.setAccelerator(KeyStroke.getKeyStroke(83, MiscUtils.MENU_MASK));
        this.saveProjectAsItem.setAccelerator(KeyStroke.getKeyStroke(83, MiscUtils.MENU_MASK | 1));
        this.formatItem.setAccelerator(KeyStroke.getKeyStroke(70, MiscUtils.MENU_MASK));
        this.exitItem.setAccelerator(KeyStroke.getKeyStroke(81, MiscUtils.MENU_MASK));
        this.undoItem.setAccelerator(KeyStroke.getKeyStroke(90, MiscUtils.MENU_MASK));
        this.redoItem.setAccelerator(KeyStroke.getKeyStroke(89, MiscUtils.MENU_MASK));
        this.bookmarkItem.setAccelerator(KeyStroke.getKeyStroke(66, MiscUtils.MENU_MASK));
        this.navigationItem.setAccelerator(KeyStroke.getKeyStroke(82, 1 | MiscUtils.MENU_MASK));
        this.panLeftItem.setAccelerator(KeyStroke.getKeyStroke(37, 1));
        this.panRightItem.setAccelerator(KeyStroke.getKeyStroke(39, 1));
        this.zoomInItem.setAccelerator(KeyStroke.getKeyStroke(38, 1));
        this.zoomOutItem.setAccelerator(KeyStroke.getKeyStroke(40, 1));
        this.toStartItem.setAccelerator(KeyStroke.getKeyStroke(36, 1));
        this.toEndItem.setAccelerator(KeyStroke.getKeyStroke(35, 1));
        this.preferencesItem.setAccelerator(KeyStroke.getKeyStroke(80, MiscUtils.MENU_MASK));
        this.crosshairItem.setAccelerator(KeyStroke.getKeyStroke(74, MiscUtils.MENU_MASK));
        this.plumblineItem.setAccelerator(KeyStroke.getKeyStroke(75, MiscUtils.MENU_MASK));
        this.spotlightItem.setAccelerator(KeyStroke.getKeyStroke(76, MiscUtils.MENU_MASK));
        this.bookmarksItem.setAccelerator(KeyStroke.getKeyStroke(66, MiscUtils.MENU_MASK | 1));
        this.genomeItem.setAccelerator(KeyStroke.getKeyStroke(67, MiscUtils.MENU_MASK | 1));
        this.rulerItem.setAccelerator(KeyStroke.getKeyStroke(76, MiscUtils.MENU_MASK | 1));
        this.statusBarItem.setAccelerator(KeyStroke.getKeyStroke(83, MiscUtils.MENU_MASK | 1));
        this.pluginToolbarItem.setAccelerator(KeyStroke.getKeyStroke(84, MiscUtils.MENU_MASK | 1));
        this.exportItem.setAccelerator(KeyStroke.getKeyStroke(73, MiscUtils.MENU_MASK));
        if (!Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            this.tutorialsItem.setEnabled(false);
            this.userManualItem.setEnabled(false);
            this.websiteItem.setEnabled(false);
        }
        this.initBrowseMenu();
        try {
            RecentTracksController.getInstance().populateMenu(this.recentTrackMenu);
            RecentProjectsController.getInstance().populateMenu(this.recentProjectMenu);
        }
        catch (IOException ex) {
            LOG.error((Object)"Unable to populate Recent Items menu.", (Throwable)ex);
        }
    }

    public JComponent getBrowserPanel() {
        return this.panel_browser;
    }

    private void initBrowseMenu() {
        this.navigationBar = new NavigationBar();
        this.panelExtendedMiddle.setLayout(new BorderLayout());
        this.panelExtendedMiddle.add(this.navigationBar);
        this.navigationBar.setVisible(false);
        this.panel_top.setVisible(false);
    }

    public void showOpenGenomeDialog() {
        LoadGenomeDialog d = new LoadGenomeDialog((Frame)this, true);
        d.setFromFileDirectory(this.lastTrackDirectory);
        d.setVisible(true);
    }

    public void setTrackBackground(Color c) {
        this.trackBackground.setBackground(c);
    }

    public void setStartPageVisible(boolean b) {
        this.startpage.setVisible(b);
    }

    public void showBrowserControls() {
        if (this.browserControlsShown) {
            return;
        }
        if (this.startpage != null) {
            this.startpage.setVisible(false);
        }
        this.panel_top.setVisible(true);
        this.navigationItem.setSelected(true);
        this.rangeSelector.setVisible(true);
        this.genomeItem.setSelected(true);
        this.ruler.setVisible(true);
        this.rulerItem.setSelected(true);
        this.loadFromFileItem.setEnabled(true);
        this.loadFromURLItem.setEnabled(true);
        this.loadFromDataSourcePluginItem.setEnabled(true);
        this.navigationBar.setVisible(true);
        this.browserControlsShown = true;
    }

    public void updateStatus(String msg) {
        this.label_status.setText(msg);
        this.label_status.revalidate();
    }

    private void initStatusBar() {
        this.toolbar_bottom.add(Box.createGlue(), 2);
        this.memorystatusbar = new MemoryStatusBarItem();
        this.memorystatusbar.setMaximumSize(new Dimension(100, 30));
        this.memorystatusbar.setFillColor(Color.lightGray);
        this.toolbar_bottom.add((Component)this.memorystatusbar);
        this.setSpeedAndEfficiencyIndicatorsVisible(false);
    }

    private void setSpeedAndEfficiencyIndicatorsVisible(boolean b) {
        this.speedAndEfficiencyItem.setSelected(b);
        this.timeCaption.setVisible(b);
        this.label_memory.setVisible(b);
        this.label_status.setVisible(b);
        this.s_e_sep.setVisible(b);
        this.memorystatusbar.setVisible(b);
    }

    public void addPluginToMenu(JCheckBoxMenuItem cb) {
        this.pluginsMenu.add(cb);
    }

    public JPanel getPluginToolbar() {
        return this.pluginToolbar;
    }

    private void makeGUIVisible() {
        this.setExtendedState(6);
        this.setVisible(true);
    }

    private void initDataSources() {
        DataSourcePluginController.getInstance().addDataSourcePlugin(new SavantFileRepositoryDataSourcePlugin());
        if (!turnExperimentalFeaturesOff) {
            DataSourcePluginController.getInstance().addDataSourcePlugin(new SAFEDataSourcePlugin());
        }
    }

    private void updateMousePosition(int x, double y, boolean yIntegral) {
        if (x == -1 && Double.isNaN(y)) {
            this.mousePositionLabel.setText("");
        } else {
            String s;
            String string = s = x == -1 ? "" : "X: " + MiscUtils.numToString(x);
            if (!Double.isNaN(y)) {
                s = s + (yIntegral ? String.format(" Y: %d", (int)y) : String.format(" Y: %.3f", y));
            }
            this.mousePositionLabel.setText(s);
        }
    }

    public String[] getSelectedTracks(boolean multiple, String title) {
        TrackChooser tc = new TrackChooser((Window)Savant.getInstance(), multiple, title);
        tc.setVisible(true);
        String[] tracks = tc.getSelectedTracks();
        return tracks;
    }

    public final void displayBookmarksPanel() {
        MiscUtils.setFrameVisibility("Bookmarks", true, this.auxDockingManager);
        this.auxDockingManager.toggleAutohideState("Bookmarks");
        this.bookmarksItem.setState(true);
        this.auxDockingManager.setActive(false);
        MiscUtils.setFrameVisibility("Variation", true, this.auxDockingManager);
        this.auxDockingManager.toggleAutohideState("Variation");
        this.auxDockingManager.setActive(false);
    }

    private void initStartPage() {
        if (BrowserSettings.getShowStartPage()) {
            this.startpage = new WelcomePage();
            this.trackBackground.add((Component)this.startpage, "Center");
        }
    }

    public boolean isWebStart() {
        return webStart;
    }

    public static void installMissingPlugins(List<String> pluginUrls) {
        String localFile = null;
        for (String stringUrl : pluginUrls) {
            try {
                int oneChar;
                URL url = new URL(stringUrl);
                InputStream is = url.openStream();
                FileOutputStream fos = null;
                StringTokenizer st = new StringTokenizer(url.getFile(), "/");
                while (st.hasMoreTokens()) {
                    localFile = st.nextToken();
                }
                localFile = new File(DirectorySettings.getPluginsDirectory(), localFile).getAbsolutePath();
                fos = new FileOutputStream(localFile);
                int count = 0;
                while ((oneChar = is.read()) != -1) {
                    fos.write(oneChar);
                    ++count;
                }
                is.close();
                fos.close();
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
    }

    public void setLastTrackDirectory(File dir) {
        File full = new File(dir.getAbsolutePath() + System.getProperty("file.separator") + " ");
        LOG.info((Object)("Setting directory to: " + full));
        this.lastTrackDirectory = full;
    }

    private void initHiddenShortcuts() {
        JMenuBar hiddenBar = new JMenuBar();
        hiddenBar.setSize(new Dimension(0, 0));
        hiddenBar.setMaximumSize(new Dimension(0, 0));
        hiddenBar.setPreferredSize(new Dimension(0, 0));
        JMenuItem hiddenBookmarkPrev = new JMenuItem("");
        hiddenBookmarkPrev.setAccelerator(KeyStroke.getKeyStroke(57, MiscUtils.MENU_MASK));
        hiddenBookmarkPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (favoriteSheet != null) {
                    favoriteSheet.goToPreviousBookmark();
                }
            }
        });
        JMenuItem hiddenBookmarkNext = new JMenuItem("");
        hiddenBookmarkNext.setAccelerator(KeyStroke.getKeyStroke(48, MiscUtils.MENU_MASK));
        hiddenBookmarkNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (favoriteSheet != null) {
                    favoriteSheet.goToNextBookmark();
                }
            }
        });
        hiddenBar.add(hiddenBookmarkPrev);
        hiddenBar.add(hiddenBookmarkNext);
        this.add(hiddenBar);
    }

    public void openTrack() {
        LoadTrackDialog ltd = new LoadTrackDialog((Frame)Savant.getInstance(), true);
        ltd.setVisible(true);
    }

    public void openTrackFromURL() {
        URL url = OpenURLDialog.getURL(this);
        if (url != null) {
            try {
                FrameController.getInstance().addTrackFromURI(url.toURI(), null, null);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    public void openTrackFromFile() {
        File[] selectedFiles;
        if (!GenomeController.getInstance().isGenomeLoaded()) {
            JOptionPane.showMessageDialog(this, "Load a genome first.");
            return;
        }
        for (File f : selectedFiles = DialogUtils.chooseFilesForOpen("Open Tracks", null, this.lastTrackDirectory)) {
            FrameController.getInstance().addTrackFromPath(f.getAbsolutePath(), null, null);
        }
        if (selectedFiles.length > 0) {
            this.setLastTrackDirectory(selectedFiles[0].getParentFile());
        }
    }

    public void openTrackFromRepository() {
        try {
            DataSourceAdapter s = DataSourcePluginDialog.getDataSource(this);
            if (s != null) {
                FrameController.getInstance().createFrame(new Track[]{TrackFactory.createTrack(s)});
            }
        }
        catch (Throwable x) {
            DialogUtils.displayException("Track Creation Failed", "Unable to create track.", x);
        }
    }

    static {
        instance = null;
    }
}

