/*
 * Decompiled with CFR 0.152.
 */
package savant.view.swing;

import com.jidesoft.docking.DockableFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.api.adapter.FrameAdapter;
import savant.api.adapter.GraphPaneAdapter;
import savant.api.data.DataFormat;
import savant.api.event.DataRetrievalEvent;
import savant.api.event.GenomeChangedEvent;
import savant.api.util.DialogUtils;
import savant.api.util.Listener;
import savant.controller.FrameController;
import savant.controller.GenomeController;
import savant.controller.LocationController;
import savant.controller.TrackController;
import savant.plugin.SavantPanelPlugin;
import savant.settings.InterfaceSettings;
import savant.util.DrawingMode;
import savant.util.Range;
import savant.util.swing.ProgressPanel;
import savant.view.icon.SavantIconFactory;
import savant.view.swing.FrameCommandBar;
import savant.view.swing.GraphPane;
import savant.view.tracks.SequenceTrack;
import savant.view.tracks.Track;
import savant.view.tracks.TrackCreationEvent;
import savant.view.tracks.TrackFactory;

public class Frame
extends DockableFrame
implements FrameAdapter,
TrackFactory.TrackCreationListener {
    private static final Log LOG = LogFactory.getLog(Frame.class);
    private boolean aborted;
    private boolean sequence;
    private GraphPane graphPane;
    private JLayeredPane frameLandscape;
    private Track[] tracks = new Track[0];
    private DrawingMode initialDrawingMode;
    private JLayeredPane jlp;
    private FrameCommandBar commandBar;
    private JComponent legend;
    private JPanel sidePanel;
    private JLabel yMaxPanel;
    private Map<SavantPanelPlugin, JPanel> pluginLayers = new HashMap<SavantPanelPlugin, JPanel>();
    private String progressMessage = null;
    private double progressFraction = -1.0;
    private boolean closeable = true;

    public Frame(DataFormat df) {
        super((Icon)SavantIconFactory.getInstance().getIcon(SavantIconFactory.StandardIcon.TRACK));
        this.sequence = df == DataFormat.SEQUENCE;
        this.legend = new JComponent(){

            @Override
            public Dimension getPreferredSize() {
                for (Track t : Frame.this.tracks) {
                    Dimension d = t.getRenderer().getLegendSize(t.getDrawingMode());
                    if (d == null) continue;
                    return d;
                }
                return new Dimension(0, 0);
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            public void paintComponent(Graphics g) {
                for (Track t : Frame.this.tracks) {
                    Dimension d = t.getRenderer().getLegendSize(t.getDrawingMode());
                    if (d == null) continue;
                    Graphics2D g2 = (Graphics2D)g;
                    GradientPaint gp = new GradientPaint(0.0f, 0.0f, Color.WHITE, 0.0f, 60.0f, new Color(230, 230, 230));
                    g2.setPaint(gp);
                    g2.fillRect(0, 0, d.width, d.height);
                    g2.setColor(Color.BLACK);
                    g2.draw(new Rectangle2D.Double(0.0, 0.0, d.width - 1, d.height - 1));
                    t.getRenderer().drawLegend(g2, t.getDrawingMode());
                    return;
                }
            }
        };
        this.legend.setVisible(false);
        this.frameLandscape = new JLayeredPane();
        this.jlp = new JLayeredPane();
        this.jlp.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setWheelScrollingEnabled(false);
        scrollPane.setBorder(null);
        this.graphPane = new GraphPane(this);
        this.jlp.add(this.graphPane, gbc, 0);
        scrollPane.getViewport().add(this.jlp);
        this.frameLandscape.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        this.sidePanel = new JPanel(){

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(0, 0);
            }
        };
        this.sidePanel.setLayout(new GridBagLayout());
        this.sidePanel.setOpaque(false);
        this.sidePanel.setVisible(false);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.gridx = 1;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 0, 16);
        this.frameLandscape.setLayer(this.sidePanel, JLayeredPane.PALETTE_LAYER);
        this.frameLandscape.add((Component)this.sidePanel, c);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension dim = Frame.this.getSize();
                if (dim != null) {
                    int expectedWidth = Frame.this.frameLandscape.getWidth();
                    if (expectedWidth != Frame.this.graphPane.getWidth()) {
                        Dimension goodSize = new Dimension(expectedWidth, Frame.this.graphPane.getHeight());
                        Frame.this.graphPane.setPreferredSize(goodSize);
                        Frame.this.graphPane.setSize(goodSize);
                    }
                    Frame.this.setLegendVisible(true);
                }
            }
        });
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.insets = new Insets(0, 0, 0, 0);
        this.frameLandscape.setLayer(scrollPane, JLayeredPane.DEFAULT_LAYER);
        this.frameLandscape.add((Component)scrollPane, c);
        this.getContentPane().add((Component)new ProgressPanel(null), "Center");
    }

    public Dimension getPreferredSize() {
        return new Dimension(100, this.sequence ? 100 : 200);
    }

    public JLayeredPane getFrameLandscape() {
        return this.frameLandscape;
    }

    @Override
    public GraphPaneAdapter getGraphPane() {
        return this.graphPane;
    }

    @Override
    public final Track[] getTracks() {
        return this.tracks;
    }

    public void setTracks(Track[] newTracks) {
        Track t0 = newTracks[0];
        DataFormat df = t0.getDataFormat();
        if (!GenomeController.getInstance().isGenomeLoaded() && df != DataFormat.SEQUENCE) {
            this.handleEvent(new TrackCreationEvent(new Exception()));
            for (Track track : newTracks) {
                TrackController.getInstance().removeTrack(track);
            }
            DialogUtils.displayError("Sorry", "This does not appear to be a genome track. Please load a genome first.");
            return;
        }
        if (df == DataFormat.SEQUENCE) {
            GenomeController.getInstance().setSequence((SequenceTrack)newTracks[0]);
        }
        this.tracks = newTracks;
        this.graphPane.setTracks(this.tracks);
        for (Track t : this.tracks) {
            t.setFrame(this, this.initialDrawingMode);
            TrackController.getInstance().addTrack(t);
        }
        this.commandBar = new FrameCommandBar(this);
        this.setKey(t0.getName());
        if (df != DataFormat.SEQUENCE && df != DataFormat.RICH_INTERVAL) {
            this.yMaxPanel = new JLabel();
            this.yMaxPanel.setBorder(BorderFactory.createLineBorder(Color.darkGray));
            this.yMaxPanel.setBackground(new Color(240, 240, 240));
            this.yMaxPanel.setOpaque(true);
            this.yMaxPanel.setAlignmentX(0.5f);
            if (df == DataFormat.ALIGNMENT) {
                GenomeController.getInstance().addListener(new Listener<GenomeChangedEvent>(){

                    @Override
                    public void handleEvent(GenomeChangedEvent event) {
                        if (event.getNewGenome() == event.getOldGenome()) {
                            Frame.this.forceRedraw();
                        }
                    }
                });
            }
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 12;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(4, 0, 0, 0);
        this.sidePanel.add((Component)this.commandBar, gbc);
        this.sidePanel.add((Component)this.legend, gbc);
        if (this.yMaxPanel != null) {
            this.sidePanel.add((Component)this.yMaxPanel, gbc);
        }
        gbc.weighty = 1.0;
        gbc.fill = 3;
        JPanel filler = new JPanel();
        filler.setOpaque(false);
        this.sidePanel.add((Component)filler, gbc);
        this.drawTracksInRange(LocationController.getInstance().getReferenceName(), LocationController.getInstance().getRange());
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add(this.frameLandscape);
    }

    public void setTrack(Track newTrack) {
        this.setTracks(new Track[]{newTrack});
    }

    public void setActiveFrame(boolean value) {
        this.sidePanel.setVisible(value);
        this.setLegendVisible(value);
    }

    @Override
    public void setCloseable(boolean closeable) {
        if (this.closeable != closeable) {
            this.closeable = closeable;
            if (closeable) {
                this.setAvailableButtons(21);
            } else {
                this.setAvailableButtons(20);
            }
        }
    }

    public boolean isCloseable() {
        return this.closeable;
    }

    public void setLegendVisible(boolean value) {
        if (value) {
            this.setYMaxVisible(true);
            this.legend.setVisible(!InterfaceSettings.areLegendsDisabled() && this.legend.getPreferredSize().height > 0);
            if (this.getHeight() < this.sidePanel.getPreferredSize().height + 24) {
                this.setYMaxVisible(false);
                this.legend.setVisible(false);
            }
        } else {
            this.setYMaxVisible(false);
            this.legend.setVisible(false);
        }
        this.legend.invalidate();
    }

    public void setInitialDrawingMode(DrawingMode dm) {
        this.initialDrawingMode = dm;
    }

    public void updateYMax(int value) {
        this.updateYMax(" ymax=%d ", value);
    }

    public void updateYMax(String format, Object ... args) {
        if (this.yMaxPanel != null) {
            this.yMaxPanel.setText(String.format(format, args));
        }
    }

    void setYMaxVisible(boolean flag) {
        if (this.yMaxPanel != null) {
            this.yMaxPanel.setVisible(flag);
        }
    }

    @Override
    public void forceRedraw() {
        this.graphPane.setRenderForced();
        this.drawTracksInRange(LocationController.getInstance().getReferenceName(), this.graphPane.getXRange());
    }

    public void drawTracksInRange(String reference, Range range) {
        if (this.graphPane.isLocked()) {
            return;
        }
        this.graphPane.setXRange(range);
        for (Track t : this.tracks) {
            t.getRenderer().clearInstructions();
            t.prepareForRendering(reference, range);
        }
        this.graphPane.repaint();
    }

    @Override
    public void drawModeChanged(Track t) {
        DrawingMode mode = t.getDrawingMode();
        this.commandBar.drawModeChanged(mode);
        this.setLegendVisible(true);
        this.validate();
        this.drawTracksInRange(LocationController.getInstance().getReferenceName(), LocationController.getInstance().getRange());
    }

    @Override
    public JPanel getLayerCanvas(SavantPanelPlugin plugin, boolean mayCreate) {
        JPanel p = this.pluginLayers.get(plugin);
        if (p == null && mayCreate) {
            p = new JPanel();
            p.setOpaque(false);
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 3;
            c.gridheight = 2;
            this.jlp.add(p, c, 2);
            this.jlp.setLayer(p, 50);
            this.pluginLayers.put(plugin, p);
            if (plugin != null) {
                p.setVisible(plugin.isVisible());
            }
        }
        return p;
    }

    public BufferedImage frameToImage(int baseSelected) {
        BufferedImage bufferedImage = new BufferedImage(this.graphPane.getWidth(), this.graphPane.getHeight(), 1);
        Graphics2D g2 = bufferedImage.createGraphics();
        this.graphPane.setRenderForced();
        this.graphPane.forceFullHeight();
        this.graphPane.render(g2);
        this.graphPane.unforceFullHeight();
        g2.setColor(Color.black);
        if (baseSelected > 0) {
            double h = this.graphPane.getHeight();
            double spos = this.graphPane.transformXPos(baseSelected);
            g2.draw(new Line2D.Double(spos, 0.0, spos, h));
            double rpos = this.graphPane.transformXPos(baseSelected + 1);
            g2.draw(new Line2D.Double(rpos, 0.0, rpos, h));
        }
        g2.setFont(new Font(null, 1, 13));
        g2.drawString(this.tracks[0].getName(), 2, 15);
        return bufferedImage;
    }

    @Override
    public void handleEvent(DataRetrievalEvent evt) {
        if (LocationController.getInstance().getRange().equals(evt.getRange())) {
            switch (evt.getType()) {
                case COMPLETED: {
                    LOG.trace((Object)("Frame " + this.getKey() + " received dataRetrievalCompleted.  Forcing full render."));
                    this.setYMaxVisible(evt.getData() != null && evt.getData().size() > 0);
                    this.graphPane.setRenderForced();
                    this.graphPane.repaint();
                    break;
                }
                case FAILED: {
                    LOG.trace((Object)("Frame " + this.getKey() + " received dataRetrievalFailed.  Forcing full render."));
                    this.setYMaxVisible(false);
                    this.graphPane.setRenderForced();
                    this.graphPane.repaint();
                }
            }
        } else {
            LOG.debug((Object)("Rejecting DataRetrievalEvent." + (Object)((Object)evt.getType()) + " for " + evt.getRange() + " because real range=" + LocationController.getInstance().getRange()));
        }
    }

    @Override
    public void handleEvent(TrackCreationEvent evt) {
        switch (evt.getType()) {
            case PROGRESS: {
                this.progressMessage = evt.getProgressMessage();
                this.progressFraction = evt.getProgressFraction();
                this.updateProgress();
                break;
            }
            case COMPLETED: {
                if (this.aborted) break;
                this.setTracks(evt.getTracks());
                break;
            }
            case FAILED: {
                this.aborted = true;
                FrameController.getInstance().closeFrame(this, false);
            }
        }
    }

    @Override
    public int getIntervalHeight() {
        return this.commandBar.getIntervalHeight();
    }

    @Override
    public void setHeightFromSlider() {
        int h = this.commandBar.getIntervalHeight();
        this.graphPane.setUnitHeight(h);
        this.graphPane.setScaledToFit(false);
    }

    public void updateProgress() {
        if (this.progressMessage == null) {
            this.graphPane.showProgress("Creating track...", -1.0);
        } else {
            this.graphPane.showProgress(this.progressMessage, this.progressFraction);
        }
    }
}

