/*
 * Decompiled with CFR 0.152.
 */
package savant.view.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.api.event.BookmarksChangedEvent;
import savant.api.util.DialogUtils;
import savant.api.util.Listener;
import savant.controller.BookmarkController;
import savant.controller.LocationController;
import savant.util.Bookmark;
import savant.util.Range;
import savant.view.icon.SavantIconFactory;
import savant.view.swing.model.BookmarksTableModel;

public class BookmarkSheet
extends JPanel
implements Listener<BookmarksChangedEvent> {
    private static final Log LOG = LogFactory.getLog(BookmarkSheet.class);
    private JTable table;
    static boolean isRecording = false;
    static JButton recordButton;
    static JButton addButton;
    static boolean confirmDelete;

    public BookmarkSheet(Container c) {
        c.setLayout(new BorderLayout());
        this.setLayout(new BoxLayout(this, 1));
        JMenuBar toolbar = new JMenuBar();
        toolbar.setLayout(new BoxLayout(toolbar, 0));
        c.add((Component)toolbar, "North");
        JButton previousButton = new JButton();
        previousButton.setIcon(SavantIconFactory.getInstance().getIcon(SavantIconFactory.StandardIcon.UP));
        previousButton.setToolTipText("Go to previous bookmark [ Ctrl+( ]");
        previousButton.putClientProperty("JButton.buttonType", "segmentedRoundRect");
        previousButton.putClientProperty("JButton.segmentPosition", "first");
        previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BookmarkSheet.this.goToPreviousBookmark();
            }
        });
        toolbar.add(previousButton);
        JButton nextButton = new JButton();
        nextButton.setIcon(SavantIconFactory.getInstance().getIcon(SavantIconFactory.StandardIcon.DOWN));
        nextButton.setToolTipText("Go to next bookmark [ Ctrl+) ]");
        nextButton.putClientProperty("JButton.buttonType", "segmentedRoundRect");
        nextButton.putClientProperty("JButton.segmentPosition", "last");
        nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BookmarkSheet.this.goToNextBookmark();
            }
        });
        toolbar.add(nextButton);
        JButton goButton = new JButton("Go");
        goButton.setToolTipText("Go to selected bookmark");
        goButton.putClientProperty("JButton.buttonType", "segmentedRoundRect");
        goButton.putClientProperty("JButton.segmentPosition", "only");
        goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BookmarkSheet.this.goToSelectedBookmark();
            }
        });
        toolbar.add(goButton);
        toolbar.add(Box.createGlue());
        addButton = new JButton();
        addButton.setIcon(SavantIconFactory.getInstance().getIcon(SavantIconFactory.StandardIcon.BKMK_ADD));
        addButton.setToolTipText("Add bookmark for current range");
        addButton.putClientProperty("JButton.buttonType", "segmentedRoundRect");
        addButton.putClientProperty("JButton.segmentPosition", "first");
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BookmarkController fc = BookmarkController.getInstance();
                fc.addCurrentRangeToBookmarks();
            }
        });
        toolbar.add(addButton);
        JButton deleteButton = new JButton();
        deleteButton.setIcon(SavantIconFactory.getInstance().getIcon(SavantIconFactory.StandardIcon.BKMK_RM));
        deleteButton.setToolTipText("Delete selected bookmarks");
        deleteButton.putClientProperty("JButton.buttonType", "segmentedRoundRect");
        deleteButton.putClientProperty("JButton.segmentPosition", "last");
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BookmarkController fc = BookmarkController.getInstance();
                int[] selectedRows = BookmarkSheet.this.table.getSelectedRows();
                Arrays.sort(selectedRows);
                boolean delete = false;
                if (selectedRows.length > 0 && confirmDelete) {
                    Object[] options = new Object[]{"Yes", "No", "Yes, don't ask again"};
                    JLabel message = new JLabel("Are you sure you want to delete " + selectedRows.length + " item(s)?");
                    message.setPreferredSize(new Dimension(300, 20));
                    int confirmDeleteDialog = JOptionPane.showOptionDialog(DialogUtils.getMainWindow(), message, "Confirm Delete", 1, 3, null, options, options[0]);
                    if (confirmDeleteDialog == 0) {
                        delete = true;
                    } else if (confirmDeleteDialog == 2) {
                        delete = true;
                        confirmDelete = false;
                    }
                } else if (selectedRows.length > 0 && !confirmDelete) {
                    delete = true;
                }
                if (delete) {
                    for (int i = selectedRows.length - 1; i >= 0; --i) {
                        fc.removeBookmark(selectedRows[i]);
                    }
                }
            }
        });
        toolbar.add(deleteButton);
        toolbar.add(Box.createGlue());
        JButton loadButton = new JButton();
        loadButton.setIcon(SavantIconFactory.getInstance().getIcon(SavantIconFactory.StandardIcon.OPEN));
        loadButton.setToolTipText("Load bookmarks from file");
        loadButton.putClientProperty("JButton.buttonType", "segmentedRoundRect");
        loadButton.putClientProperty("JButton.segmentPosition", "first");
        loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BookmarkSheet.this.loadBookmarks(BookmarkSheet.this.table);
            }
        });
        toolbar.add(loadButton);
        JButton saveButton = new JButton();
        saveButton.setIcon(SavantIconFactory.getInstance().getIcon(SavantIconFactory.StandardIcon.SAVE));
        saveButton.setToolTipText("Save bookmarks to file");
        saveButton.putClientProperty("JButton.buttonType", "segmentedRoundRect");
        saveButton.putClientProperty("JButton.segmentPosition", "last");
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BookmarkSheet.saveBookmarks(BookmarkSheet.this.table);
            }
        });
        toolbar.add(saveButton);
        this.table = new JTable(new BookmarksTableModel());
        this.table.setAutoCreateRowSorter(true);
        this.table.setFillsViewportHeight(true);
        this.table.setShowGrid(true);
        this.table.setGridColor(Color.gray);
        c.add(this.table.getTableHeader());
        this.add(this.table);
        final JScrollPane sp = new JScrollPane(this.table, 20, 30);
        sp.setWheelScrollingEnabled(false);
        sp.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                sp.getVerticalScrollBar().setValue(sp.getVerticalScrollBar().getValue() + e.getUnitsToScroll() * 2);
            }
        });
        c.add(sp);
        this.add(Box.createGlue());
    }

    @Override
    public void handleEvent(BookmarksChangedEvent event) {
        this.refreshData(BookmarkController.getInstance().getBookmarks());
    }

    private void refreshData(List<Bookmark> favorites) {
        ((BookmarksTableModel)this.table.getModel()).setData(favorites);
        ((BookmarksTableModel)this.table.getModel()).fireTableDataChanged();
    }

    private void loadBookmarks(JTable table) {
        File selectedFile;
        String title;
        String message;
        int reply;
        final BookmarksTableModel btm = (BookmarksTableModel)table.getModel();
        List<Bookmark> bookmarks = btm.getData();
        if (bookmarks.size() > 0 && (reply = JOptionPane.showConfirmDialog(null, message = "Clear existing bookmarks?", title = "Clear Bookmarks", 0)) == 0) {
            btm.clearData();
            BookmarkController.getInstance().clearBookmarks();
        }
        if ((selectedFile = DialogUtils.chooseFileForOpen("Load Bookmarks", null, null)) != null) {
            int result = JOptionPane.showOptionDialog(null, "Would you like to add padding to each bookmark range?", "Add a margin?", 0, 3, null, null, null);
            final boolean addMargin = result == 0;
            Window w = SwingUtilities.getWindowAncestor(this);
            JOptionPane optionPane = new JOptionPane("<html>Loading bookmarks from file.<br>This may take a moment.</html>", 1, 2);
            final JDialog dialog = new JDialog(w, "Loading Bookmarks", Dialog.ModalityType.MODELESS);
            dialog.setContentPane(optionPane);
            dialog.pack();
            dialog.setLocationRelativeTo(w);
            dialog.setVisible(true);
            new Thread("BookmarkSheet.loadBookmarks"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        BookmarkController.getInstance().addBookmarksFromFile(selectedFile, addMargin);
                        btm.fireTableDataChanged();
                    }
                    catch (Exception ex) {
                        DialogUtils.displayError("Error", "Unable to load bookmarks: " + ex.getMessage());
                    }
                    finally {
                        dialog.setVisible(false);
                        dialog.dispose();
                    }
                }
            }.start();
        }
    }

    private static void saveBookmarks(JTable table) {
        BookmarksTableModel btm = (BookmarksTableModel)table.getModel();
        List<Bookmark> bookmarks = btm.getData();
        File selectedFile = DialogUtils.chooseFileForSave("Save Bookmarks", "Bookmarks.txt");
        if (selectedFile != null) {
            try {
                BookmarkSheet.saveBookmarks(selectedFile.getAbsolutePath(), bookmarks);
            }
            catch (IOException ex) {
                DialogUtils.displayError("Error", "Unable to save bookmarks: " + ex.getMessage());
            }
        }
    }

    private static void saveBookmarks(String filename, List<Bookmark> bookmarks) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(filename));
        for (Bookmark bm : bookmarks) {
            bw.write(bm.getReference() + "\t" + bm.getRange().getFrom() + "\t" + bm.getRange().getTo() + "\t" + bm.getAnnotation() + "\n");
        }
        bw.close();
    }

    public void goToSelectedBookmark() {
        int viewRow = this.table.getSelectedRow();
        if (viewRow > -1) {
            this.goToBookmark(viewRow);
        }
    }

    public void goToNextBookmark() {
        if (this.table.getRowCount() == 0) {
            return;
        }
        int viewRow = this.table.getSelectedRow();
        viewRow = viewRow == -1 || viewRow == this.table.getRowCount() - 1 ? 0 : ++viewRow;
        this.selectRow(viewRow);
    }

    private void selectRow(int viewRow) {
        int modelRow = this.table.convertRowIndexToModel(viewRow);
        this.table.removeRowSelectionInterval(0, this.table.getRowCount() - 1);
        this.table.addRowSelectionInterval(viewRow, viewRow);
        this.goToSelectedBookmark();
    }

    public void goToPreviousBookmark() {
        if (this.table.getRowCount() == 0) {
            return;
        }
        int viewRow = this.table.getSelectedRow();
        viewRow = viewRow == -1 || viewRow == 0 ? this.table.getRowCount() - 1 : --viewRow;
        this.selectRow(viewRow);
    }

    public void goToBookmark(int viewRow) {
        if (viewRow == -1 || this.table.getRowCount() == 0) {
            return;
        }
        LocationController lc = LocationController.getInstance();
        BookmarksTableModel tableModel = (BookmarksTableModel)this.table.getModel();
        Bookmark bookmark = tableModel.getData().get(this.table.convertRowIndexToModel(viewRow));
        lc.setLocation(bookmark.getReference(), (Range)bookmark.getRange());
    }

    static {
        confirmDelete = true;
    }
}

