/*
 * Decompiled with CFR 0.152.
 */
package savant.view.dialog;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import savant.api.util.DialogUtils;
import savant.util.MiscUtils;

public class OpenURLDialog
extends JDialog {
    private URL url;
    private JButton cancelButton;
    private JButton okButton;
    private JTextField urlField;

    private OpenURLDialog(Window parent, boolean modal) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.initComponents();
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.okButton);
        MiscUtils.registerCancelButton(this.cancelButton);
    }

    private void initComponents() {
        JLabel urlLabel = new JLabel();
        this.urlField = new JTextField();
        JLabel noteLabel = new JLabel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Load Track from URL");
        urlLabel.setText("Track URL:");
        noteLabel.setFont(new Font("Lucida Grande", 0, 11));
        noteLabel.setText("Note: BAM files must be sorted and an index must be present with the extension .bai");
        this.cancelButton.setText("Cancel");
        this.cancelButton.setPreferredSize(new Dimension(90, 30));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OpenURLDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.setPreferredSize(new Dimension(90, 30));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OpenURLDialog.this.okButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.okButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton, -2, -1, -2)).addComponent(noteLabel, -1, 560, Short.MAX_VALUE).addComponent(urlLabel).addComponent(this.urlField, -1, 560, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(urlLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.urlField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(noteLabel).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton, -2, -1, -2).addComponent(this.okButton, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.url = null;
        this.setVisible(false);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.parseURL()) {
            this.setVisible(false);
        } else {
            DialogUtils.displayError("Please enter a valid URL.");
        }
    }

    private boolean parseURL() {
        boolean result = false;
        String urlStr = this.urlField.getText();
        try {
            this.url = new URL(urlStr);
            result = true;
        }
        catch (MalformedURLException e) {
            Toolkit.getDefaultToolkit().beep();
            this.urlField.grabFocus();
        }
        return result;
    }

    public static URL getURL(Window parent) {
        String proto;
        OpenURLDialog dialog = new OpenURLDialog(parent, true);
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        if (!(dialog.url == null || (proto = dialog.url.getProtocol().toLowerCase()).equals("http") || proto.equals("https") || proto.equals("ftp"))) {
            DialogUtils.displayMessage("Sorry", "Only files accessible via HTTP or FTP can be opened via URL.");
            return null;
        }
        return dialog.url;
    }
}

