/*
 * Decompiled with CFR 0.152.
 */
package savant.view.dialog;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import savant.api.adapter.DataSourceAdapter;
import savant.controller.DataSourcePluginController;
import savant.plugin.SavantDataSourcePlugin;
import savant.util.MiscUtils;

public class DataSourcePluginDialog
extends JDialog {
    List<SavantDataSourcePlugin> dataSources;
    SavantDataSourcePlugin selectedPlugin;
    private JButton cancelButton;
    private JList dataSourceList;
    private JScrollPane jScrollPane1;
    private JButton loadButton;

    private DataSourcePluginDialog(Window parent, List<SavantDataSourcePlugin> dataSources) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.initComponents();
        this.setLocationRelativeTo(parent);
        this.dataSources = dataSources;
        this.initList(dataSources);
        this.getRootPane().setDefaultButton(this.loadButton);
        MiscUtils.registerCancelButton(this.cancelButton);
    }

    private void initComponents() {
        this.loadButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.dataSourceList = new JList();
        JLabel promptLabel = new JLabel();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Load from Other Datasource");
        this.setModal(true);
        this.loadButton.setText("Load track");
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataSourcePluginDialog.this.loadButtonActionPerformed(evt);
            }
        });
        this.dataSourceList.setSelectionMode(0);
        this.dataSourceList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DataSourcePluginDialog.this.dataSourceListMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.dataSourceList);
        promptLabel.setText("Select a data source to load from:");
        this.cancelButton.setText("Cancel");
        this.cancelButton.setPreferredSize(new Dimension(110, 29));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataSourcePluginDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.loadButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cancelButton, -2, -1, -2)).addComponent(this.jScrollPane1, -1, 513, Short.MAX_VALUE).addComponent(promptLabel)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(promptLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 281, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton, -2, -1, -2).addComponent(this.loadButton)).addContainerGap()));
        this.pack();
    }

    private void loadButtonActionPerformed(ActionEvent evt) {
        String title = (String)this.dataSourceList.getSelectedValue();
        for (SavantDataSourcePlugin p : this.dataSources) {
            if (!p.getTitle().equals(title)) continue;
            this.selectedPlugin = p;
            break;
        }
        this.dispose();
    }

    private void dataSourceListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.loadButton.doClick();
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void initList(List<SavantDataSourcePlugin> datasources) {
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        for (SavantDataSourcePlugin p : datasources) {
            listModel.addElement(p.getTitle());
        }
        this.dataSourceList.setModel(listModel);
        this.dataSourceList.setSelectedIndex(0);
    }

    public static DataSourceAdapter getDataSource(Window parent) throws Exception {
        List<SavantDataSourcePlugin> ps = DataSourcePluginController.getInstance().getPlugins();
        if (DataSourcePluginController.getInstance().hasOnlySavantRepoDataSource()) {
            return ps.get(0).getDataSource();
        }
        DataSourcePluginDialog d = new DataSourcePluginDialog(parent, ps);
        d.setVisible(true);
        SavantDataSourcePlugin p = d.selectedPlugin;
        d.dispose();
        if (p != null) {
            return p.getDataSource();
        }
        return null;
    }
}

