/*
 * Decompiled with CFR 0.152.
 */
package savant.view.dialog;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import savant.api.util.DialogUtils;
import savant.file.FileType;
import savant.format.SavantFileFormatter;
import savant.format.SavantFileFormatterUtils;
import savant.view.dialog.FormatProgressDialog;

public final class DataFormatForm
extends JDialog {
    boolean loadingTrack = false;
    private JTextArea descriptionArea;
    private JButton formatButton;
    private JList formatList;
    private JButton inputButton;
    private JTextField inputField;
    private JButton outputButton;
    private JTextField outputField;
    private JCheckBox zeroBasedCheck;

    public DataFormatForm(Window parent, URI input, boolean asTrack) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.loadingTrack = asTrack;
        this.initComponents();
        this.formatList.setListData(new FormatDef[]{new FormatDef("BED", false, false, FileType.INTERVAL_BED, "BED format is an alternative to GFF format for describing co-ordinates of localized features on genomes."), new FormatDef("GenePred", false, false, FileType.INTERVAL_KNOWNGENE, "UCSC Gene Prediction format."), new FormatDef("GFF", true, false, FileType.INTERVAL_GFF, "GFF (General Feature Format) is a format for locating & describing genes and other localized features associated with DNA, RNA and Protein sequences."), new FormatDef("GTF", true, false, FileType.INTERVAL_GTF, "GTF (Gene Transfer Format) is a refinement to GFF which stores gene and transcript IDs in a standard way."), new FormatDef("VCF", false, false, FileType.INTERVAL_VCF, "VCF (Variant Call Format) is a format for storing gene sequence variants."), new FormatDef("WIG/BedGraph", true, false, FileType.CONTINUOUS_WIG, "WIG format allows display of continuous-valued data in track format. This display type is useful for GC percent, probability scores, and transcriptome data."), new FormatDef("BAM Coverage", true, false, FileType.INTERVAL_BAM, "SAM format (binary, for BAM) is a generic format for storing large nucleotide sequence alignments. This option generates a coverage graph which will represent the BAM data at low resolutions.")});
        if (input != null) {
            this.inputField.setText(input.getPath());
            if (!this.guessFileType()) {
                this.setOutputPath();
            }
        }
        this.setLocationRelativeTo(parent);
        this.validateReadyToFormat();
    }

    private void initComponents() {
        this.inputField = new JTextField();
        JScrollPane jScrollPane2 = new JScrollPane();
        this.descriptionArea = new JTextArea();
        JLabel jLabel2 = new JLabel();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.formatList = new JList();
        this.inputButton = new JButton();
        JLabel jLabel1 = new JLabel();
        JLabel jLabel3 = new JLabel();
        this.outputButton = new JButton();
        this.formatButton = new JButton();
        JLabel jLabel4 = new JLabel();
        this.outputField = new JTextField();
        this.zeroBasedCheck = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Format");
        this.inputField.setEditable(false);
        this.inputField.setDisabledTextColor(new Color(255, 255, 255));
        this.descriptionArea.setColumns(20);
        this.descriptionArea.setEditable(false);
        this.descriptionArea.setFont(new Font("Verdana", 0, 10));
        this.descriptionArea.setLineWrap(true);
        this.descriptionArea.setRows(3);
        this.descriptionArea.setWrapStyleWord(true);
        jScrollPane2.setViewportView(this.descriptionArea);
        jLabel2.setText("Format");
        this.formatList.setModel(new DefaultListModel());
        this.formatList.setSelectionMode(0);
        this.formatList.setVisibleRowCount(6);
        this.formatList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                DataFormatForm.this.formatListValueChanged(evt);
            }
        });
        jScrollPane1.setViewportView(this.formatList);
        this.inputButton.setText("...");
        this.inputButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataFormatForm.this.inputButtonActionPerformed(evt);
            }
        });
        jLabel1.setText("Input File");
        jLabel3.setText("Output File");
        this.outputButton.setText("...");
        this.outputButton.setEnabled(false);
        this.outputButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataFormatForm.this.outputButtonActionPerformed(evt);
            }
        });
        this.formatButton.setText("Format");
        this.formatButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataFormatForm.this.formatButtonActionPerformed(evt);
            }
        });
        jLabel4.setText("Format Description");
        this.outputField.setEditable(false);
        this.outputField.setDisabledTextColor(new Color(255, 255, 255));
        this.zeroBasedCheck.setText("Input file is 0-based");
        this.zeroBasedCheck.setToolTipText("Checked for 1-based; unchecked for 0-based.");
        this.zeroBasedCheck.setEnabled(false);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jScrollPane1, -1, 483, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.inputField, -1, 399, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inputButton)).addComponent(jLabel1).addComponent(jLabel2).addComponent(jLabel4).addComponent(jScrollPane2, -1, 483, Short.MAX_VALUE).addComponent(this.zeroBasedCheck).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.outputField, -1, 397, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.outputButton)).addComponent(jLabel3).addComponent(this.formatButton, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jLabel1).addGap(2, 2, 2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.inputField, -2, -1, -2).addComponent(this.inputButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jScrollPane1, -2, -1, -2).addGap(18, 18, 18).addComponent(jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jScrollPane2, -1, 103, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.zeroBasedCheck).addGap(16, 16, 16).addComponent(jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.outputButton).addComponent(this.outputField, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.formatButton).addContainerGap()));
        this.pack();
    }

    private void inputButtonActionPerformed(ActionEvent evt) {
        File selectedFile = DialogUtils.chooseFileForOpen("Input File", null, null);
        if (selectedFile != null) {
            this.inputField.setText(selectedFile.getPath());
            if (this.guessFileType()) {
                return;
            }
            this.setOutputPath();
        }
        this.validateReadyToFormat();
    }

    private void formatButtonActionPerformed(ActionEvent evt) {
        File inFile = new File(this.inputField.getText());
        File outFile = new File(this.outputField.getText());
        FileType ft = ((FormatDef)this.formatList.getSelectedValue()).type;
        try {
            SavantFileFormatter sff = SavantFileFormatter.getFormatter(inFile, outFile, ft);
            if (sff != null) {
                FormatProgressDialog fpd = new FormatProgressDialog((Window)this, sff, this.loadingTrack);
                fpd.setLocationRelativeTo(this);
                fpd.setVisible(true);
                this.setVisible(false);
            }
        }
        catch (Exception x) {
            SavantFileFormatter.reportFormattingError(x, inFile);
        }
    }

    private void formatListValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            if (!this.formatList.isSelectionEmpty()) {
                FormatDef picked = (FormatDef)this.formatList.getSelectedValue();
                this.descriptionArea.setText(picked.description);
                this.zeroBasedCheck.setSelected(picked.defaultIsZeroBased);
                this.zeroBasedCheck.setEnabled(picked.canChooseBase);
            }
            this.setOutputPath();
            this.validateReadyToFormat();
        }
    }

    private void outputButtonActionPerformed(ActionEvent evt) {
        File outputFile = new File(this.outputField.getText());
        if ((outputFile = DialogUtils.chooseFileForSave("Output File", outputFile.getName(), null, outputFile.getParentFile())) != null) {
            this.outputField.setText(outputFile.getPath());
        }
        this.validateReadyToFormat();
    }

    private void setOutputPath() {
        FormatDef format = (FormatDef)this.formatList.getSelectedValue();
        if (format != null) {
            FileType ft = format.type;
            String inputPath = this.inputField.getText();
            boolean bam = ft == null && inputPath.endsWith(".bam") || ft == FileType.INTERVAL_BAM;
            this.outputButton.setEnabled(!bam);
            this.outputField.setEnabled(!bam);
            if (bam) {
                this.outputField.setText("Directory of BAM file");
            } else if (inputPath.equals("")) {
                this.outputField.setText("No input file selected");
            } else {
                String outputPath = inputPath;
                switch (ft) {
                    case CONTINUOUS_WIG: {
                        outputPath = outputPath + ".tdf";
                        break;
                    }
                    case INTERVAL_BED: 
                    case INTERVAL_BED1: 
                    case INTERVAL_GENERIC: 
                    case INTERVAL_GFF: 
                    case INTERVAL_GTF: 
                    case INTERVAL_PSL: 
                    case INTERVAL_VCF: 
                    case INTERVAL_KNOWNGENE: 
                    case INTERVAL_REFGENE: {
                        outputPath = outputPath + ".gz";
                        break;
                    }
                    default: {
                        outputPath = outputPath + ".savant";
                    }
                }
                this.outputField.setText(outputPath);
            }
            this.validateReadyToFormat();
        }
    }

    private void validateReadyToFormat() {
        if (this.inputField.getText().equals("") || this.outputField.getText().equals("") || this.formatList.isSelectionEmpty()) {
            this.formatButton.setEnabled(false);
        } else {
            this.formatButton.setEnabled(true);
            this.getRootPane().setDefaultButton(this.formatButton);
        }
    }

    private boolean guessFileType() {
        FileType guess = SavantFileFormatterUtils.guessFileTypeFromPath(this.inputField.getText());
        if (guess != null) {
            int numItems = this.formatList.getModel().getSize();
            for (int i = 0; i < numItems; ++i) {
                if (((FormatDef)this.formatList.getModel().getElementAt((int)i)).type != guess) continue;
                if (i == this.formatList.getSelectedIndex()) break;
                this.formatList.setSelectedIndex(i);
                return true;
            }
        }
        return false;
    }

    static class FormatDef {
        final String name;
        final boolean defaultIsZeroBased;
        final boolean canChooseBase;
        final FileType type;
        final String description;

        FormatDef(String name, boolean defaultIsZeroBased, boolean canChooseBase, FileType type, String description) {
            this.name = name;
            this.defaultIsZeroBased = defaultIsZeroBased;
            this.canChooseBase = canChooseBase;
            this.type = type;
            this.description = description;
        }

        public String toString() {
            return this.name;
        }
    }
}

