/*
 * Decompiled with CFR 0.152.
 */
package savant.view.dialog;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import savant.controller.LocationController;
import savant.data.filters.BAMRecordFilter;
import savant.util.MiscUtils;
import savant.util.SAMReadUtils;
import savant.view.tracks.BAMTrack;

public class BAMFilterDialog
extends JDialog {
    private static final int DEFAULT_DISCORDANT_MIN = 50;
    private static final int DEFAULT_DISCORDANT_MAX = 1000;
    private static final int DEFAULT_ARC_YMAX_THRESHOLD = 10000;
    private final BAMTrack track;
    private final BAMRecordFilter filter;
    private JTextField errField = null;
    private JTextField arcThresholdField;
    private JTextField arcYMaxThresholdField;
    private JButton cancelButton;
    private JTextField discordantMaxField;
    private JTextField discordantMinField;
    private JCheckBox duplicateReadsCheck;
    private JSlider mappingQualitySlider;
    private JButton okButton;
    private JRadioButton oppositeRadio;
    private JCheckBox pairedCheck;
    private JRadioButton pairedEndRadio;
    private JCheckBox unmappedMateCheck;
    private JCheckBox unpairedCheck;
    private JCheckBox vendorFailedReadsCheck;

    public BAMFilterDialog(Window parent, BAMTrack t) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.initComponents();
        this.track = t;
        this.filter = t.getFilter();
        this.duplicateReadsCheck.setSelected(this.filter.getIncludeDuplicateReads());
        this.vendorFailedReadsCheck.setSelected(this.filter.getIncludeVendorFailedReads());
        this.pairedCheck.setSelected(this.filter.getIncludePairedReads());
        this.unmappedMateCheck.setSelected(this.filter.getIncludeUnmappedMate());
        this.unmappedMateCheck.setEnabled(this.filter.getIncludePairedReads());
        this.unpairedCheck.setSelected(this.filter.getIncludeUnpairedReads());
        this.mappingQualitySlider.setValue(this.filter.getMappingQualityThreshold());
        double arcThreshold = this.filter.getArcLengthThreshold();
        if (arcThreshold < 1.0 && arcThreshold > 0.0) {
            this.arcThresholdField.setText(String.format("%d%%", (int)(arcThreshold * 100.0)));
        } else {
            this.arcThresholdField.setText(String.valueOf((int)arcThreshold));
        }
        this.discordantMinField.setText(String.valueOf(t.getConcordantMin()));
        this.discordantMaxField.setText(String.valueOf(t.getConcordantMax()));
        this.arcYMaxThresholdField.setText(String.valueOf(t.getMaxBPForYMax()));
        if (t.getPairedProtocol() == SAMReadUtils.PairedSequencingProtocol.PAIREDEND) {
            this.pairedEndRadio.setSelected(true);
        } else {
            this.oppositeRadio.setSelected(true);
        }
        this.getRootPane().setDefaultButton(this.okButton);
        MiscUtils.registerCancelButton(this.cancelButton);
        this.setLocationRelativeTo(parent);
    }

    private void initComponents() {
        ButtonGroup strandGroup = new ButtonGroup();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        JPanel jPanel1 = new JPanel();
        this.duplicateReadsCheck = new JCheckBox();
        this.vendorFailedReadsCheck = new JCheckBox();
        this.pairedCheck = new JCheckBox();
        this.unpairedCheck = new JCheckBox();
        JLabel mappingQualityLabel = new JLabel();
        this.mappingQualitySlider = new JSlider();
        this.unmappedMateCheck = new JCheckBox();
        JPanel jPanel2 = new JPanel();
        JLabel arcYMaxThresholdLabel = new JLabel();
        JLabel oppositeIcon = new JLabel();
        JLabel minConcordantLabel = new JLabel();
        this.oppositeRadio = new JRadioButton();
        JLabel maxConcordantLabel = new JLabel();
        this.arcYMaxThresholdField = new JTextField();
        JLabel arcThresholdLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        this.discordantMinField = new JTextField();
        this.discordantMaxField = new JTextField();
        JLabel pairedEndIcon = new JLabel();
        this.arcThresholdField = new JTextField();
        JLabel jLabel1 = new JLabel();
        JLabel jLabel4 = new JLabel();
        this.pairedEndRadio = new JRadioButton();
        JLabel jLabel3 = new JLabel();
        JLabel pairLabel = new JLabel();
        strandGroup.add(this.pairedEndRadio);
        strandGroup.add(this.oppositeRadio);
        this.setDefaultCloseOperation(0);
        this.setTitle("Read Pair Settings");
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BAMFilterDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BAMFilterDialog.this.okButtonActionPerformed(evt);
            }
        });
        jPanel1.setBorder(BorderFactory.createTitledBorder("General Filters"));
        jPanel1.setLayout(new GridBagLayout());
        this.duplicateReadsCheck.setSelected(true);
        this.duplicateReadsCheck.setText("Include duplicate reads");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 5, 0);
        jPanel1.add((Component)this.duplicateReadsCheck, gridBagConstraints);
        this.vendorFailedReadsCheck.setSelected(true);
        this.vendorFailedReadsCheck.setText("Include vendor failed reads");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        jPanel1.add((Component)this.vendorFailedReadsCheck, gridBagConstraints);
        this.pairedCheck.setSelected(true);
        this.pairedCheck.setText("Include paired reads");
        this.pairedCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BAMFilterDialog.this.pairedCheckActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        jPanel1.add((Component)this.pairedCheck, gridBagConstraints);
        this.unpairedCheck.setSelected(true);
        this.unpairedCheck.setText("Include unpaired reads");
        this.unpairedCheck.setActionCommand("Include unpaired reads");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        jPanel1.add((Component)this.unpairedCheck, gridBagConstraints);
        mappingQualityLabel.setText("Mapping quality threshold");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 10, 5);
        jPanel1.add((Component)mappingQualityLabel, gridBagConstraints);
        this.mappingQualitySlider.setMajorTickSpacing(50);
        this.mappingQualitySlider.setMaximum(255);
        this.mappingQualitySlider.setPaintLabels(true);
        this.mappingQualitySlider.setValue(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 322;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 10);
        jPanel1.add((Component)this.mappingQualitySlider, gridBagConstraints);
        this.unmappedMateCheck.setSelected(true);
        this.unmappedMateCheck.setText("Include reads with unmapped mates");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 30, 5, 0);
        jPanel1.add((Component)this.unmappedMateCheck, gridBagConstraints);
        jPanel2.setBorder(BorderFactory.createTitledBorder("Arc Mode Settings"));
        arcYMaxThresholdLabel.setText("Don't adjust ymax for arcs larger than:");
        oppositeIcon.setIcon(new ImageIcon(this.getClass().getResource("/savant/images/reads_opposite.png")));
        minConcordantLabel.setText("Min concordant insert size:");
        this.oppositeRadio.setSelected(true);
        this.oppositeRadio.setText("opposite strands");
        maxConcordantLabel.setText("Max concordant insert size:");
        arcThresholdLabel.setText("Ignore sizes smaller than:");
        jLabel2.setText("bp");
        pairedEndIcon.setIcon(new ImageIcon(this.getClass().getResource("/savant/images/reads_same.png")));
        this.arcThresholdField.setToolTipText("Either enter an absolute number of base pairs, or a percentage of ymax");
        jLabel1.setText("bp");
        jLabel4.setText("bp");
        this.pairedEndRadio.setText("same strand");
        jLabel3.setText("bp or %");
        pairLabel.setText("Pairs are sequenced from:");
        GroupLayout jPanel2Layout = new GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(pairLabel).addComponent(minConcordantLabel).addComponent(maxConcordantLabel).addComponent(arcYMaxThresholdLabel).addComponent(arcThresholdLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.oppositeRadio).addComponent(this.pairedEndRadio)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(pairedEndIcon).addComponent(oppositeIcon))).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.arcYMaxThresholdField, GroupLayout.Alignment.LEADING).addComponent(this.arcThresholdField, GroupLayout.Alignment.LEADING).addComponent(this.discordantMaxField, GroupLayout.Alignment.LEADING).addComponent(this.discordantMinField, GroupLayout.Alignment.LEADING, -2, 143, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel3).addComponent(jLabel2).addComponent(jLabel1).addComponent(jLabel4)))).addContainerGap(48, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(oppositeIcon).addComponent(this.oppositeRadio)).addGap(5, 5, 5).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(pairedEndIcon).addComponent(this.pairedEndRadio)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.discordantMinField, -2, -1, -2).addComponent(minConcordantLabel, -2, 14, -2).addComponent(jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.discordantMaxField, -2, -1, -2).addComponent(maxConcordantLabel).addComponent(jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.arcThresholdField, -2, -1, -2).addComponent(arcThresholdLabel).addComponent(jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.arcYMaxThresholdField, -2, -1, -2).addComponent(arcYMaxThresholdLabel).addComponent(jLabel4))).addGroup(jPanel2Layout.createSequentialGroup().addGap(4, 4, 4).addComponent(pairLabel, -2, 47, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton, -2, 71, -2)).addComponent(jPanel1, -1, 601, Short.MAX_VALUE).addComponent(jPanel2, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jPanel2, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap(29, Short.MAX_VALUE)));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        try {
            SAMReadUtils.PairedSequencingProtocol prot = this.parseProtocol();
            int discordantMin = this.parseField(this.discordantMinField, 50);
            int discordantMax = this.parseField(this.discordantMaxField, 1000);
            double arcThreshold = this.parseArcThreshold();
            int maxBPForYMax = this.parseField(this.arcYMaxThresholdField, 10000);
            this.filter.setArcLengthThreshold(arcThreshold);
            this.filter.setIncludeDuplicateReads(this.duplicateReadsCheck.isSelected());
            this.filter.setIncludeVendorFailedReads(this.vendorFailedReadsCheck.isSelected());
            this.filter.setIncludePairedReads(this.pairedCheck.isSelected());
            this.filter.setIncludeUnmappedMate(this.filter.getIncludePairedReads() && this.unmappedMateCheck.isSelected());
            this.filter.setIncludeUnpairedReads(this.unpairedCheck.isSelected());
            this.filter.setMappingQualityThreshold(this.mappingQualitySlider.getValue());
            this.track.setPairedProtocol(prot);
            this.track.setConcordantMin(discordantMin);
            this.track.setConcordantMax(discordantMax);
            this.track.setMaxBPForYMax(maxBPForYMax);
            this.setVisible(false);
            this.track.prepareForRendering(LocationController.getInstance().getReferenceName(), LocationController.getInstance().getRange());
            this.track.repaint();
        }
        catch (NumberFormatException e) {
            Toolkit.getDefaultToolkit().beep();
            this.errField.setText("");
            this.errField.grabFocus();
        }
    }

    private void pairedCheckActionPerformed(ActionEvent evt) {
        this.unmappedMateCheck.setEnabled(this.pairedCheck.isSelected());
    }

    private SAMReadUtils.PairedSequencingProtocol parseProtocol() {
        return this.pairedEndRadio.isSelected() ? SAMReadUtils.PairedSequencingProtocol.PAIREDEND : SAMReadUtils.PairedSequencingProtocol.MATEPAIR;
    }

    private int parseField(JTextField f, int dflt) throws NumberFormatException {
        this.errField = f;
        String str = f.getText();
        return str.equals("") ? dflt : Integer.parseInt(str);
    }

    private double parseArcThreshold() {
        double result;
        this.errField = this.arcThresholdField;
        String threshStr = this.arcThresholdField.getText();
        if (threshStr.equals("")) {
            result = 1.0;
        } else if (threshStr.endsWith("%")) {
            result = Double.parseDouble(threshStr.substring(0, threshStr.length() - 1)) * 0.01;
            if (result >= 1.0) {
                throw new NumberFormatException();
            }
        } else {
            result = Double.parseDouble(threshStr);
        }
        return result;
    }
}

