/*
 * Decompiled with CFR 0.152.
 */
package savant.util.swing;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import savant.api.data.Record;
import savant.api.event.SelectionChangedEvent;
import savant.api.util.Listener;
import savant.controller.TrackController;
import savant.selection.SelectionController;
import savant.util.swing.RecordTableModel;
import savant.view.tracks.Track;

public class RecordTable
extends JTable {
    private List<Integer> selectedRows = new ArrayList<Integer>();

    public RecordTable(RecordTableModel model) {
        super(model);
        this.setAutoCreateRowSorter(true);
        this.setDefaultRenderer(Boolean.class, new BooleanRenderer());
        SelectionController.getInstance().addListener(new Listener<SelectionChangedEvent>(){

            @Override
            public void handleEvent(SelectionChangedEvent event) {
                RecordTable.this.refreshSelection();
            }
        });
    }

    public void refreshSelection() {
        this.selectedRows.clear();
        HashSet<Record> allSelected = new HashSet<Record>();
        for (Track t : TrackController.getInstance().getTracks()) {
            List<Record> selected = t.getSelectedDataInRange();
            if (selected == null) continue;
            allSelected.addAll(selected);
        }
        RecordTableModel model = (RecordTableModel)this.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            Object rec = model.getRecord(i);
            if (!allSelected.contains(rec)) continue;
            this.selectedRows.add(i);
        }
        this.updateUI();
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        int modRow = this.getRowSorter().convertRowIndexToModel(row);
        if (this.selectedRows.contains(modRow)) {
            super.getCellRenderer(row, column).getTableCellRendererComponent(this, null, false, false, row, column).setBackground(Color.GREEN);
        } else {
            super.getCellRenderer(row, column).getTableCellRendererComponent(this, null, false, false, row, column).setBackground(Color.WHITE);
        }
        return super.getCellRenderer(row, column);
    }

    private class BooleanRenderer
    implements TableCellRenderer {
        private final TableCellRenderer defaultRenderer;

        public BooleanRenderer() {
            this.defaultRenderer = RecordTable.this.getDefaultRenderer(Boolean.class);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = this.defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int modRow = RecordTable.this.getRowSorter().convertRowIndexToModel(row);
            if (!isSelected && RecordTable.this.selectedRows.contains(modRow)) {
                comp.setBackground(Color.green);
            }
            return comp;
        }
    }
}

