/*
 * Decompiled with CFR 0.152.
 */
package savant.util.swing;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;

public class ProgressDialog
extends JDialog {
    private static ProgressDialog instance = null;
    private JButton cancelButton;
    private JLabel messageLabel;
    private JProgressBar progressBar;

    private ProgressDialog(Window parent) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.initComponents();
    }

    private void setProgress(double fraction) {
        if (fraction < 0.0) {
            this.progressBar.setIndeterminate(true);
        } else {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue((int)(fraction * 100.0));
        }
    }

    private void initComponents() {
        this.messageLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.messageLabel.setText("jLabel1");
        this.progressBar.setMinimumSize(new Dimension(200, 20));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgressDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.messageLabel).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.progressBar, -1, 360, Short.MAX_VALUE).addGap(20, 20, 20)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.cancelButton).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.messageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.progressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cancelButton).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        ProgressDialog.showProgress(null, 1.0);
    }

    public static void showProgress(String message, double fraction) {
        if (fraction >= 1.0) {
            if (instance != null) {
                instance.setVisible(false);
                instance = null;
            }
        } else if (instance == null) {
            Window parent = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            instance = new ProgressDialog(parent);
            instance.setProgress(fraction);
            ProgressDialog.instance.messageLabel.setText(message);
            instance.setLocationRelativeTo(parent);
            instance.setVisible(true);
        } else {
            instance.setProgress(fraction);
            ProgressDialog.instance.messageLabel.setText(message);
        }
    }
}

