/*
 * Decompiled with CFR 0.152.
 */
package savant.util;

import java.util.ArrayList;
import java.util.List;
import savant.api.data.Interval;
import savant.api.data.IntervalRecord;

public class StuffedIntervalRecord
implements IntervalRecord {
    private final int start;
    private final int end;
    private final IntervalRecord originalRecord;

    public StuffedIntervalRecord(IntervalRecord record, int leftStuffing, int rightStuffing) {
        this.originalRecord = record;
        if (record.getInterval().getLength() == 0) {
            leftStuffing = Math.max(1, leftStuffing);
            rightStuffing = Math.max(1, rightStuffing);
        }
        this.start = Math.max(0, record.getInterval().getStart() - leftStuffing);
        this.end = record.getInterval().getEnd() + rightStuffing;
    }

    @Override
    public String getReference() {
        return this.originalRecord.getReference();
    }

    @Override
    public Interval getInterval() {
        return Interval.valueOf(this.start, this.end);
    }

    @Override
    public String getName() {
        return this.originalRecord.getName();
    }

    public int compareTo(Object o) {
        StuffedIntervalRecord other = (StuffedIntervalRecord)o;
        if (!this.getReference().equals(other.getReference())) {
            return this.getReference().compareTo(other.getReference());
        }
        int start = this.getInterval().getStart();
        int otherStart = other.getInterval().getStart();
        int end = this.getInterval().getEnd();
        int otherEnd = other.getInterval().getEnd();
        if (start == otherStart) {
            if (otherEnd < end) {
                return -1;
            }
            if (otherEnd > end) {
                return 1;
            }
            return 0;
        }
        if (start < otherStart) {
            return -1;
        }
        return 1;
    }

    private IntervalRecord getOriginalInterval() {
        return this.originalRecord;
    }

    public static List<List<IntervalRecord>> getOriginalIntervals(List<List<IntervalRecord>> pack) {
        ArrayList<List<IntervalRecord>> result = new ArrayList<List<IntervalRecord>>();
        for (List<IntervalRecord> list : pack) {
            ArrayList<IntervalRecord> subResult = new ArrayList<IntervalRecord>();
            for (IntervalRecord r : list) {
                subResult.add(((StuffedIntervalRecord)r).getOriginalInterval());
            }
            result.add(subResult);
        }
        return result;
    }
}

