/*
 * Decompiled with CFR 0.152.
 */
package savant.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IOUtils {
    public static void copyFile(File srcFile, File destFile) throws IOException {
        if (srcFile.equals(destFile)) {
            return;
        }
        IOUtils.copyStream(new FileInputStream(srcFile), new FileOutputStream(destFile));
    }

    public static void copyDir(File srcDir, File destDir) throws IOException {
        File[] files;
        for (File f : files = srcDir.listFiles()) {
            IOUtils.copyFile(f, new File(destDir, f.getName()));
        }
    }

    public static void copyDir(File srcDir, File destDir, FilenameFilter filter) throws IOException {
        File[] files;
        for (File f : files = srcDir.listFiles(filter)) {
            IOUtils.copyFile(f, new File(destDir, f.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(InputStream input, OutputStream output) throws IOException {
        byte[] buf = new byte[8192];
        try {
            int len;
            while ((len = input.read(buf)) > 0) {
                output.write(buf, 0, len);
            }
        }
        catch (IOException x) {
            if (!x.getMessage().equals("Unexpected compressed block length: 1")) {
                throw x;
            }
        }
        finally {
            input.close();
            output.close();
        }
    }

    public static String readLine(InputStream input) throws IOException {
        int c;
        StringBuilder buf = new StringBuilder();
        while ((c = input.read()) >= 0 && c != 10) {
            buf.append((char)c);
        }
        return c >= 0 ? buf.toString() : null;
    }

    public static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    IOUtils.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }
}

