/*
 * Decompiled with CFR 0.152.
 */
package savant.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import savant.util.IOUtils;
import savant.util.NetworkUtils;
import savant.util.ReferenceComparator;

public class FastaUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, IndexEntry> createIndex(URI uri, File destFile) throws IOException {
        BufferedInputStream input = null;
        OutputStream faiOutput = null;
        try {
            String s;
            input = new BufferedInputStream((InputStream)NetworkUtils.getSeekableStreamForURI(uri));
            faiOutput = new FileOutputStream(destFile.getAbsolutePath());
            long readPos = 0L;
            int lineLen = -1;
            String ref = null;
            long refStart = -1L;
            int numBases = -1;
            ArrayList<IndexEntry> entries = new ArrayList<IndexEntry>();
            while ((s = IOUtils.readLine(input)) != null) {
                if (s.charAt(0) == '>') {
                    if (ref != null) {
                        entries.add(new IndexEntry(ref, numBases, refStart, lineLen));
                    }
                    refStart = readPos + (long)s.length() + 1L;
                    int spacePos = s.indexOf(32);
                    if (spacePos < 0) {
                        spacePos = s.length();
                    }
                    ref = s.substring(1, spacePos);
                    numBases = 0;
                } else {
                    if (lineLen < 0) {
                        lineLen = s.length();
                    }
                    numBases += s.length();
                }
                readPos += (long)(s.length() + 1);
            }
            if (ref != null) {
                entries.add(new IndexEntry(ref, numBases, refStart, lineLen));
            }
            Map<String, IndexEntry> sortedEntryMap = FastaUtils.sortEntries(entries);
            for (IndexEntry entry : entries) {
                faiOutput.write(String.format("%s\t%d\t%d\t%d\t%d\n", entry.reference, entry.length, entry.offset, entry.lineLength, entry.lineLength + 1).getBytes());
            }
            Map<String, IndexEntry> map = sortedEntryMap;
            return map;
        }
        finally {
            if (input != null) {
                ((InputStream)input).close();
                if (faiOutput != null) {
                    faiOutput.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, IndexEntry> readIndex(File faiFile) throws IOException {
        BufferedReader faiReader = null;
        try {
            String line;
            faiReader = new BufferedReader(new FileReader(faiFile));
            ArrayList<IndexEntry> unsortedEntries = new ArrayList<IndexEntry>();
            while ((line = faiReader.readLine()) != null) {
                String[] fields = StringUtils.split((String)line, (char)'\t');
                unsortedEntries.add(new IndexEntry(fields[0], Integer.valueOf(fields[1]), Long.valueOf(fields[2]), Integer.valueOf(fields[3])));
            }
            Map<String, IndexEntry> map = FastaUtils.sortEntries(unsortedEntries);
            return map;
        }
        finally {
            if (faiReader != null) {
                faiReader.close();
            }
        }
    }

    private static Map<String, IndexEntry> sortEntries(List<IndexEntry> unsortedEntries) {
        Collections.sort(unsortedEntries, new Comparator<IndexEntry>(){
            private ReferenceComparator comparator = new ReferenceComparator();

            @Override
            public int compare(IndexEntry t1, IndexEntry t2) {
                return this.comparator.compare(t1.reference, t2.reference);
            }
        });
        LinkedHashMap<String, IndexEntry> referenceMap = new LinkedHashMap<String, IndexEntry>();
        for (IndexEntry entry : unsortedEntries) {
            referenceMap.put(entry.reference, entry);
        }
        return referenceMap;
    }

    public static class IndexEntry {
        public final String reference;
        public final int length;
        public final long offset;
        public final int lineLength;

        IndexEntry(String ref, int l, long off, int line) {
            this.reference = ref;
            this.length = l;
            this.offset = off;
            this.lineLength = line;
        }
    }
}

