/*
 * Decompiled with CFR 0.152.
 */
package savant.util;

import java.io.File;

public class DownloadEvent {
    final Type type;
    final double progress;
    final File file;
    final Throwable error;

    private DownloadEvent(Type type, double progress, File file, Throwable error) {
        this.type = type;
        this.progress = progress;
        this.file = file;
        this.error = error;
    }

    public DownloadEvent(Type type) {
        this(type, Double.NaN, null, null);
    }

    public DownloadEvent(double progress) {
        this(Type.PROGRESS, progress, null, null);
    }

    public DownloadEvent(File file) {
        this(Type.COMPLETED, Double.NaN, file, null);
    }

    public DownloadEvent(Throwable error) {
        this(Type.FAILED, Double.NaN, null, error);
    }

    public Type getType() {
        return this.type;
    }

    public double getProgress() {
        return this.progress;
    }

    public File getFile() {
        return this.file;
    }

    public Throwable getError() {
        return this.error;
    }

    public static enum Type {
        STARTED,
        COMPLETED,
        FAILED,
        PROGRESS;

    }
}

