/*
 * Decompiled with CFR 0.152.
 */
package savant.util;

public enum ColourKey {
    A,
    C,
    G,
    T,
    N,
    DELETED_BASE,
    INSERTED_BASE,
    SKIPPED,
    FORWARD_STRAND,
    REVERSE_STRAND,
    CONCORDANT_LENGTH,
    DISCORDANT_LENGTH,
    ONE_READ_INVERTED,
    EVERTED_PAIR,
    UNMAPPED_MATE,
    INTERVAL_LINE,
    INTERVAL_TEXT,
    CONTINUOUS_FILL,
    CONTINUOUS_LINE,
    POINT_FILL,
    POINT_LINE,
    OPAQUE_GRAPH,
    TRANSLUCENT_GRAPH,
    GRAPH_PANE_MESSAGE,
    GRAPH_PANE_BACKGROUND_TOP,
    GRAPH_PANE_BACKGROUND_BOTTOM,
    GRAPH_PANE_ZOOM_FILL,
    GRAPH_PANE_SELECTION_FILL,
    SPLITTER,
    AXIS_GRID,
    HEATMAP_LOW,
    HEATMAP_MEDIUM,
    HEATMAP_HIGH;


    public String getName() {
        switch (this) {
            case SKIPPED: {
                return "Skipped";
            }
            case FORWARD_STRAND: {
                return "Forward Strand";
            }
            case REVERSE_STRAND: {
                return "Reverse Strand";
            }
            case CONCORDANT_LENGTH: {
                return "Concordant Length";
            }
            case DISCORDANT_LENGTH: {
                return "Discordant Length";
            }
            case ONE_READ_INVERTED: {
                return "One Read Inverted";
            }
            case EVERTED_PAIR: {
                return "Everted Pair";
            }
            case UNMAPPED_MATE: {
                return "Unmapped Mate";
            }
            case INTERVAL_LINE: {
                return "Interval Line";
            }
            case INTERVAL_TEXT: {
                return "Interval Text";
            }
            case CONTINUOUS_FILL: {
                return "Continuous Fill";
            }
            case CONTINUOUS_LINE: {
                return "Continuous Line";
            }
            case POINT_LINE: {
                return "Point Line";
            }
            case POINT_FILL: {
                return "Point Fill";
            }
        }
        return this.toString();
    }

    public String getDescription() {
        switch (this) {
            case A: {
                return "Nucleotide A";
            }
            case C: {
                return "Nucleotide C";
            }
            case G: {
                return "Nucleotide G";
            }
            case T: {
                return "Nucleotide T";
            }
            case N: {
                return "Missing/unknown nucleotides";
            }
            case FORWARD_STRAND: {
                return "Colour of forward strands";
            }
            case REVERSE_STRAND: {
                return "Colour of reverse strands";
            }
            case CONCORDANT_LENGTH: {
                return "Colour of concordant lengths";
            }
            case DISCORDANT_LENGTH: {
                return "Colour of discordant lengths";
            }
            case ONE_READ_INVERTED: {
                return "Colour of inverted reads";
            }
            case EVERTED_PAIR: {
                return "Colour of everted pairs";
            }
            case UNMAPPED_MATE: {
                return "Colour of read whose mate is unmapped";
            }
            case INTERVAL_LINE: {
                return "Line colour for interval tracks";
            }
            case INTERVAL_TEXT: {
                return "Text colour for interval tracks";
            }
            case CONTINUOUS_FILL: {
                return "Fill colour for continuous tracks";
            }
            case CONTINUOUS_LINE: {
                return "Outline colour for continuous tracks";
            }
            case POINT_FILL: {
                return "Fill colour for point tracks";
            }
            case POINT_LINE: {
                return "Line colour for point tracks";
            }
        }
        return null;
    }
}

