/*
 * Decompiled with CFR 0.152.
 */
package savant.util;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Path2D;
import java.util.HashMap;
import java.util.Map;
import savant.util.ColourKey;
import savant.util.ColourScheme;

public class ColourAccumulator {
    private final ColourScheme scheme;
    private final Map<Color, Path2D> areas = new HashMap<Color, Path2D>();

    public ColourAccumulator(ColourScheme cs) {
        this.scheme = cs;
    }

    public ColourScheme getScheme() {
        return this.scheme;
    }

    public void addShape(ColourKey col, Shape shape) {
        this.addShape(this.scheme.getColor(col), shape);
    }

    public void addBaseShape(char baseChar, Shape shape) {
        this.addShape(this.scheme.getBaseColor(baseChar), shape);
    }

    public void addShape(Color col, Shape shape) {
        if (col != null) {
            if (!this.areas.containsKey(col)) {
                this.areas.put(col, new Path2D.Double());
            }
            this.areas.get(col).append(shape.getPathIterator(null), false);
        }
    }

    public void fill(Graphics2D g2) {
        for (Color c : this.areas.keySet()) {
            g2.setColor(c);
            g2.fill(this.areas.get(c));
        }
    }

    public void draw(Graphics2D g2) {
        for (Color c : this.areas.keySet()) {
            g2.draw(this.areas.get(c));
        }
    }
}

