/*
 * Decompiled with CFR 0.152.
 */
package savant.util;

import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.api.util.DialogUtils;
import savant.util.MiscUtils;

public abstract class BackgroundWorker<T>
extends SwingWorker<T, Object> {
    private static final Log LOG = LogFactory.getLog(BackgroundWorker.class);

    @Override
    public void done() {
        this.showProgress(1.0);
        if (!this.isCancelled()) {
            try {
                this.showSuccess(this.get());
            }
            catch (InterruptedException x) {
                this.showFailure(x);
            }
            catch (ExecutionException x) {
                this.showFailure(x.getCause());
            }
        }
    }

    protected abstract void showProgress(double var1);

    protected abstract void showSuccess(T var1);

    protected void showFailure(Throwable t) {
        if (t instanceof InterruptedException) {
            DialogUtils.displayMessage("Background task interrupted.");
        } else {
            LOG.error((Object)"Exception thrown by background task.", t);
            DialogUtils.displayException("Savant", String.format("<html>Exception thrown by background task:<br><br><i>%s</i></html>", MiscUtils.getMessage(t)), t);
        }
    }
}

