/*
 * Decompiled with CFR 0.152.
 */
package savant.settings;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import savant.controller.FrameController;
import savant.controller.TrackController;
import savant.settings.InterfaceSettings;
import savant.settings.PersistentSettings;
import savant.settings.Section;
import savant.settings.SettingsDialog;
import savant.view.swing.Frame;
import savant.view.tracks.Track;

public class InterfaceSection
extends Section {
    private JFormattedTextField bamIntervalHeightField;
    private JFormattedTextField richIntervalHeightField;
    private JFormattedTextField otherIntervalHeightField;
    private JCheckBox disablePopupsCheck;
    private JCheckBox disableLegendsCheck;
    private JCheckBox wheelZoomsCheck;

    public String getTitle() {
        return "Interface Settings";
    }

    public void lazyInitialize() {
        GridBagConstraints gbc = this.getFullRowConstraints();
        this.add(SettingsDialog.getHeader(this.getTitle()), gbc);
        this.add(this.getIntervalHeightsPanel(), gbc);
        this.disablePopupsCheck = new JCheckBox("Disable Informational Popups");
        this.disablePopupsCheck.setSelected(InterfaceSettings.arePopupsDisabled());
        this.disablePopupsCheck.addActionListener(this.enablingActionListener);
        this.add(this.disablePopupsCheck, gbc);
        this.disableLegendsCheck = new JCheckBox("Disable Track Legends");
        this.disableLegendsCheck.setSelected(InterfaceSettings.areLegendsDisabled());
        this.disableLegendsCheck.addActionListener(this.enablingActionListener);
        this.add(this.disableLegendsCheck, gbc);
        this.wheelZoomsCheck = new JCheckBox("Mouse Wheel Zooms (Instead of Scrolling)");
        this.wheelZoomsCheck.setSelected(InterfaceSettings.doesWheelZoom());
        this.wheelZoomsCheck.addActionListener(this.enablingActionListener);
        gbc.weighty = 1.0;
        this.add(this.wheelZoomsCheck, gbc);
    }

    @Override
    public void applyChanges() {
        if (this.bamIntervalHeightField != null) {
            InterfaceSettings.setBamIntervalHeight(Integer.parseInt(this.bamIntervalHeightField.getText().replaceAll(",", "")));
            InterfaceSettings.setRichIntervalHeight(Integer.parseInt(this.richIntervalHeightField.getText().replaceAll(",", "")));
            InterfaceSettings.setGenericIntervalHeight(Integer.parseInt(this.otherIntervalHeightField.getText().replaceAll(",", "")));
            InterfaceSettings.setPopupsDisabled(this.disablePopupsCheck.isSelected());
            InterfaceSettings.setLegendsDisabled(this.disableLegendsCheck.isSelected());
            InterfaceSettings.setWheelZooms(this.wheelZoomsCheck.isSelected());
            try {
                PersistentSettings.getInstance().store();
            }
            catch (IOException iox) {
                this.LOG.error((Object)"Unable to save remote file settings.", (Throwable)iox);
            }
            Frame f = FrameController.getInstance().getActiveFrame();
            if (f != null) {
                f.setLegendVisible(!InterfaceSettings.areLegendsDisabled());
            }
            for (Track t : TrackController.getInstance().getTracks()) {
                t.getFrame().forceRedraw();
            }
        }
    }

    private JPanel getIntervalHeightsPanel() {
        this.bamIntervalHeightField = this.getFormattedTextField(InterfaceSettings.getBamIntervalHeight());
        this.richIntervalHeightField = this.getFormattedTextField(InterfaceSettings.getRichIntervalHeight());
        this.otherIntervalHeightField = this.getFormattedTextField(InterfaceSettings.getGenericIntervalHeight());
        JPanel panel = new JPanel(new GridBagLayout());
        TitledBorder sequenceTitle = BorderFactory.createTitledBorder("Interval Heights");
        panel.setBorder(sequenceTitle);
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        JLabel label1 = new JLabel("BAM Interval Height ");
        JLabel label2 = new JLabel("BED Interval Height ");
        JLabel label3 = new JLabel("Generic Interval Height ");
        JFormattedTextField tf1 = this.bamIntervalHeightField;
        JFormattedTextField tf2 = this.richIntervalHeightField;
        JFormattedTextField tf3 = this.otherIntervalHeightField;
        JLabel label4 = new JLabel(" pixels");
        JLabel label5 = new JLabel(" pixels");
        JLabel label6 = new JLabel(" pixels");
        GroupLayout.SequentialGroup hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(label1).addComponent(label2).addComponent(label3));
        hGroup.addGroup(layout.createParallelGroup().addComponent(tf1).addComponent(tf2).addComponent(tf3));
        hGroup.addGroup(layout.createParallelGroup().addComponent(label4).addComponent(label5).addComponent(label6));
        layout.setHorizontalGroup(hGroup);
        GroupLayout.SequentialGroup vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(label1).addComponent(tf1).addComponent(label4));
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(label2).addComponent(tf2).addComponent(label5));
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(label3).addComponent(tf3).addComponent(label6));
        layout.setVerticalGroup(vGroup);
        return panel;
    }

    private JFormattedTextField getFormattedTextField(int amount) {
        JFormattedTextField result = new JFormattedTextField(NumberFormat.getNumberInstance());
        result.setValue(new Double(amount));
        result.setColumns(10);
        result.setPreferredSize(new Dimension(100, 18));
        result.setMaximumSize(new Dimension(100, 18));
        result.addKeyListener(this.enablingKeyListener);
        return result;
    }
}

