/*
 * Decompiled with CFR 0.152.
 */
package savant.settings;

import java.awt.Font;
import java.net.URL;
import savant.settings.PersistentSettings;
import savant.util.NetworkUtils;

public class BrowserSettings {
    private static PersistentSettings settings = PersistentSettings.getInstance();
    private static final String CHECKVERSION_KEY = "CHECKVERSION";
    private static final String COLLECTSTATS_KEY = "COLLECTSTATS";
    private static final String CACHINGENABLED_KEY = "CACHINGENABLED";
    private static final String SHOWSTARTPAGE_KEY = "SHOWSTARTPAGE";
    private static final Font TRACK_FONT = new Font("Sans-Serif", 1, 12);
    private static final String REMOTE_BUFFER_SIZE = "REMOTE_BUFFER_SIZE";
    public static final int DEFAULT_BUFFER_SIZE = 65536;
    public static final URL URL = NetworkUtils.getKnownGoodURL("http://www.genomesavant.com/savant");
    public static final URL VERSION_URL = NetworkUtils.getKnownGoodURL(URL, "serve/version/version.xml");
    public static final URL GENOMES_URL = NetworkUtils.getKnownGoodURL(URL, "serve/data/genomes.xml");
    public static final URL DATA_URL = NetworkUtils.getKnownGoodURL(URL, "serve/data/data.xml");
    public static final URL PLUGIN_URL = NetworkUtils.getKnownGoodURL(URL, "serve/plugin/plugin.xml");
    public static final URL LOG_USAGE_STATS_URL = NetworkUtils.getKnownGoodURL(URL, "scripts/logUsageStats.cgi");
    public static final URL MEDIA_URL = NetworkUtils.getKnownGoodURL(URL, "media.html");
    public static final URL DOCUMENTATION_URL = NetworkUtils.getKnownGoodURL(URL, "documentation.html");
    public static final URL SHORTCUTS_URL = NetworkUtils.getKnownGoodURL(URL, "docs/SavantShortcuts.pdf");
    public static final URL NEWS_URL = NetworkUtils.getKnownGoodURL(URL, "serve/start/news.xml");
    public static final URL SAFE_URL = NetworkUtils.getKnownGoodURL(URL, "safe/savantsafe.php");
    public static final String VERSION = "2.0.4";
    public static String BUILD = "";

    public static boolean isBeta() {
        return BUILD.startsWith("beta") || BUILD.startsWith("alpha");
    }

    public static boolean getCheckVersionOnStartup() {
        return BrowserSettings.isBeta() || settings.getBoolean(CHECKVERSION_KEY, true);
    }

    public static boolean getCollectAnonymousUsage() {
        return settings.getBoolean(COLLECTSTATS_KEY, true);
    }

    public static boolean getCachingEnabled() {
        return settings.getBoolean(CACHINGENABLED_KEY, true);
    }

    public static boolean getShowStartPage() {
        return settings.getBoolean(SHOWSTARTPAGE_KEY, true);
    }

    public static int getRemoteBufferSize() {
        String s = settings.getString(REMOTE_BUFFER_SIZE);
        return s != null ? Integer.parseInt(s) : 65536;
    }

    public static void setCheckVersionOnStartup(boolean b) {
        settings.setBoolean(CHECKVERSION_KEY, b);
    }

    public static void setCollectAnonymousUsage(boolean b) {
        settings.setBoolean(COLLECTSTATS_KEY, b);
    }

    public static void setCachingEnabled(boolean b) {
        settings.setBoolean(CACHINGENABLED_KEY, b);
    }

    public static void setRemoteBufferSize(int size) {
        settings.setString(REMOTE_BUFFER_SIZE, String.valueOf(size));
    }

    public static void setShowStartPage(boolean b) {
        settings.setBoolean(SHOWSTARTPAGE_KEY, b);
    }

    public static Font getTrackFont() {
        return TRACK_FONT;
    }
}

