/*
 * Decompiled with CFR 0.152.
 */
package savant.selection;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import savant.api.adapter.DataSourceAdapter;
import savant.api.adapter.PopupHostingAdapter;
import savant.api.data.DataFormat;
import savant.api.data.Interval;
import savant.api.data.IntervalRecord;
import savant.api.data.Record;
import savant.controller.BookmarkController;
import savant.controller.LocationController;
import savant.data.types.TabixIntervalRecord;
import savant.selection.ContinuousPopup;
import savant.selection.IntervalBamPopup;
import savant.selection.IntervalBedPopup;
import savant.selection.IntervalGenericPopup;
import savant.selection.PileupPopup;
import savant.selection.PointGenericPopup;
import savant.selection.TabixPopup;
import savant.selection.VariantPopup;
import savant.util.Bookmark;
import savant.util.DrawingMode;
import savant.util.MiscUtils;
import savant.util.Range;
import savant.view.tracks.Track;

public abstract class PopupPanel
extends JPanel {
    private static JPopupMenu activePopup;
    private static PopupHostingAdapter activeHost;
    protected PopupHostingAdapter host;
    protected DrawingMode mode;
    protected DataFormat fileFormat;
    protected Record record;
    protected String name;
    protected String ref;
    protected int start;
    protected int end;

    private static PopupPanel create(PopupHostingAdapter parent, DrawingMode mode, DataSourceAdapter dataSource, Record rec) {
        PopupPanel p = null;
        switch (dataSource.getDataFormat()) {
            case POINT: {
                p = new PointGenericPopup();
                break;
            }
            case ALIGNMENT: {
                if (mode != DrawingMode.SNP && mode != DrawingMode.STRAND_SNP) {
                    p = new IntervalBamPopup();
                    break;
                }
                p = new PileupPopup();
                break;
            }
            case RICH_INTERVAL: {
                if (mode == DrawingMode.SQUISH) break;
                if (rec instanceof TabixIntervalRecord) {
                    p = new TabixPopup(dataSource);
                    break;
                }
                p = new IntervalBedPopup();
                break;
            }
            case GENERIC_INTERVAL: {
                if (rec instanceof TabixIntervalRecord) {
                    p = new TabixPopup(dataSource);
                    break;
                }
                p = new IntervalGenericPopup();
                break;
            }
            case CONTINUOUS: {
                p = new ContinuousPopup();
                break;
            }
            case VARIANT: {
                p = new VariantPopup();
                break;
            }
        }
        if (p != null) {
            p.init(parent, mode, dataSource.getDataFormat(), rec);
        }
        return p;
    }

    public static void showPopup(PopupHostingAdapter parent, Point globalPt, Track t, Record overRecord) {
        JPopupMenu jp = new JPopupMenu();
        PopupPanel pp = PopupPanel.create(parent, t.getDrawingMode(), t.getDataSource(), overRecord);
        parent.firePopupEvent(pp);
        if (pp != null) {
            jp.setLayout(new BorderLayout());
            jp.add((Component)pp, "Center");
            jp.setLocation(globalPt.x - 2, globalPt.y - 2);
            activePopup = jp;
            activeHost = parent;
            jp.setVisible(true);
        }
    }

    public static void hidePopup() {
        if (activePopup != null) {
            activePopup.setVisible(false);
            activePopup = null;
        }
        if (activeHost != null) {
            activeHost.popupHidden();
            activeHost = null;
        }
    }

    protected void init(PopupHostingAdapter parent, DrawingMode m, DataFormat ff, Record rec) {
        this.fileFormat = ff;
        this.mode = m;
        this.host = parent;
        this.record = rec;
        this.setBackground(Color.WHITE);
        this.setLayout(new GridLayout(0, 1));
        this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.initInfo();
        this.initStandardButtons();
        this.initSpecificButtons();
    }

    protected void initStandardButtons() {
        this.add(new JSeparator());
        Buttonoid select = new Buttonoid("Select/Deselect");
        select.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PopupPanel.this.host.recordSelected(PopupPanel.this.record);
                PopupPanel.hidePopup();
            }
        });
        this.add(select);
        if (this.ref == null) {
            this.ref = LocationController.getInstance().getReferenceName();
        }
        if (this.start != -1 && this.end != -1) {
            Buttonoid bookmark = new Buttonoid("Add to Bookmarks");
            bookmark.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    PopupPanel.this.ref = PopupPanel.this.homogenizeRef(PopupPanel.this.ref);
                    if (PopupPanel.this.name != null) {
                        BookmarkController.getInstance().addBookmark(new Bookmark(PopupPanel.this.ref, new Range(PopupPanel.this.start, PopupPanel.this.end), PopupPanel.this.name, true));
                    } else {
                        BookmarkController.getInstance().addBookmark(new Bookmark(PopupPanel.this.ref, new Range(PopupPanel.this.start, PopupPanel.this.end), true));
                    }
                    PopupPanel.hidePopup();
                }
            });
            this.add(bookmark);
        }
    }

    protected void initSpecificButtons() {
    }

    protected abstract void initInfo();

    protected String homogenizeRef(String orig) {
        if (!LocationController.getInstance().getAllReferenceNames().contains(orig)) {
            for (String current : LocationController.getInstance().getAllReferenceNames()) {
                if (!MiscUtils.homogenizeSequence(current).equals(orig)) continue;
                return current;
            }
        }
        return orig;
    }

    public Record getRecord() {
        return this.record;
    }

    protected void initIntervalJumps() {
        if (LocationController.getInstance().getRangeStart() > ((IntervalRecord)this.record).getInterval().getStart()) {
            Buttonoid startJump = new Buttonoid("Jump to Start of Interval");
            startJump.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    LocationController lc = LocationController.getInstance();
                    int len = lc.getRangeEnd() - lc.getRangeStart();
                    Interval inter = ((IntervalRecord)PopupPanel.this.record).getInterval();
                    lc.setLocation(inter.getStart() - len / 2, inter.getStart() + len / 2);
                    PopupPanel.hidePopup();
                }
            });
            this.add(startJump);
        }
        if (LocationController.getInstance().getRangeEnd() < ((IntervalRecord)this.record).getInterval().getEnd()) {
            Buttonoid endJump = new Buttonoid("Jump to End of Interval");
            endJump.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    LocationController lc = LocationController.getInstance();
                    int len = lc.getRangeEnd() - lc.getRangeStart();
                    Interval inter = ((IntervalRecord)PopupPanel.this.record).getInterval();
                    lc.setLocation(inter.getEnd() - len / 2, inter.getEnd() + len / 2);
                    PopupPanel.hidePopup();
                }
            });
            this.add(endJump);
        }
    }

    class PopupLabel
    extends JLabel {
        PopupLabel(String text) {
            super(text);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension result = super.getPreferredSize();
            return new Dimension(Math.min(600, result.width), result.height);
        }
    }

    class Buttonoid
    extends JLabel {
        Buttonoid(String text) {
            super(text);
            this.setForeground(Color.BLUE);
            this.setBackground(Color.WHITE);
            this.setCursor(new Cursor(12));
            this.setOpaque(true);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent me) {
                    Buttonoid.this.setBackground(Color.BLUE);
                    Buttonoid.this.setForeground(Color.WHITE);
                }

                @Override
                public void mouseExited(MouseEvent me) {
                    Buttonoid.this.setBackground(Color.WHITE);
                    Buttonoid.this.setForeground(Color.BLUE);
                }
            });
        }
    }
}

