/*
 * Decompiled with CFR 0.152.
 */
package savant.selection;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import net.sf.samtools.SAMRecord;
import savant.api.data.Record;
import savant.api.event.DataRetrievalEvent;
import savant.api.util.Listener;
import savant.api.util.RangeUtils;
import savant.controller.LocationController;
import savant.data.types.BAMIntervalRecord;
import savant.selection.PopupPanel;
import savant.util.MiscUtils;
import savant.util.Range;
import savant.view.swing.GraphPane;
import savant.view.tracks.Track;

public class IntervalBamPopup
extends PopupPanel
implements Listener<DataRetrievalEvent> {
    private SAMRecord samRec;

    protected IntervalBamPopup() {
    }

    @Override
    protected void initInfo() {
        this.samRec = ((BAMIntervalRecord)this.record).getSAMRecord();
        this.name = this.samRec.getReadName();
        this.ref = this.samRec.getReferenceName();
        this.start = this.samRec.getAlignmentStart();
        this.end = this.samRec.getAlignmentEnd();
        this.add(new JLabel("Read Name: " + this.name));
        this.add(new JLabel("Position: " + this.start));
        this.add(new JLabel("Read Length: " + this.samRec.getReadLength()));
        this.add(new JLabel("Mapping Quality: " + this.samRec.getMappingQuality()));
        this.add(new JLabel("Base Quality: " + this.samRec.getBaseQualityString()));
        if (this.samRec.getReadPairedFlag()) {
            this.add(new JLabel("Mate Position: " + this.homogenizeRef(this.samRec.getMateReferenceName()) + ": " + this.samRec.getMateAlignmentStart()));
        }
    }

    @Override
    protected void initSpecificButtons() {
        if (this.samRec.getReadPairedFlag() && !this.samRec.getMateReferenceName().equals("*") && this.samRec.getMateAlignmentStart() != 0) {
            PopupPanel.Buttonoid mateJump = new PopupPanel.Buttonoid(this, "Jump to Mate");
            mateJump.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    LocationController lc = LocationController.getInstance();
                    int offset = (int)Math.ceil((float)lc.getRange().getLength() / 2.0f);
                    int start = IntervalBamPopup.this.samRec.getMateAlignmentStart() - offset;
                    int end = start + lc.getRange().getLength() - 1;
                    lc.setLocation(IntervalBamPopup.this.homogenizeRef(IntervalBamPopup.this.samRec.getMateReferenceName()), new Range(start, end));
                    PopupPanel.hidePopup();
                }
            });
            this.add(mateJump);
            PopupPanel.Buttonoid pairSelect = new PopupPanel.Buttonoid(this, "Select Pair");
            if (this.samRec.getReferenceName().equals(this.samRec.getMateReferenceName())) {
                pairSelect.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        for (Track t : ((GraphPane)IntervalBamPopup.this.host).getTracks()) {
                            if (t.getDataFormat() != IntervalBamPopup.this.fileFormat) continue;
                            t.getRenderer().forceAddToSelected(IntervalBamPopup.this.record);
                            break;
                        }
                        int start = Math.min(IntervalBamPopup.this.samRec.getAlignmentStart(), IntervalBamPopup.this.samRec.getMateAlignmentStart());
                        int end = Math.max(IntervalBamPopup.this.samRec.getAlignmentEnd(), IntervalBamPopup.this.samRec.getMateAlignmentStart() + IntervalBamPopup.this.samRec.getReadLength());
                        ((GraphPane)IntervalBamPopup.this.host).getTracks()[0].addListener(IntervalBamPopup.this);
                        LocationController.getInstance().setLocation((Range)RangeUtils.addMargin(new Range(start, end)));
                    }
                });
            } else {
                pairSelect.setEnabled(false);
                pairSelect.setToolTipText("Disabled because mate is in " + this.samRec.getMateReferenceName());
            }
            this.add(pairSelect);
        }
        this.initIntervalJumps();
    }

    @Override
    public void handleEvent(DataRetrievalEvent evt) {
        switch (evt.getType()) {
            case COMPLETED: {
                block3: for (Record r : evt.getData()) {
                    SAMRecord current = ((BAMIntervalRecord)r).getSAMRecord();
                    if (!MiscUtils.isMate(this.samRec, current, true)) continue;
                    for (Track t : ((GraphPane)this.host).getTracks()) {
                        if (t.getDataFormat() != this.fileFormat) continue;
                        t.getRenderer().forceAddToSelected(r);
                        break block3;
                    }
                }
                IntervalBamPopup.hidePopup();
                ((GraphPane)this.host).getTracks()[0].removeListener(this);
            }
        }
    }
}

