/*
 * Decompiled with CFR 0.152.
 */
package savant.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import savant.api.util.DialogUtils;
import savant.plugin.PluginController;
import savant.plugin.PluginVersionException;
import savant.settings.DirectorySettings;
import savant.view.dialog.DownloadDialog;

public class PluginDescriptor
implements Comparable<PluginDescriptor> {
    final String className;
    final String id;
    final String version;
    final String name;
    final String sdkVersion;
    final File file;
    final File[] libs;
    final URL[] downloads;
    private static XMLStreamReader reader;

    private PluginDescriptor(String className, String id, String version, String name, String sdkVersion, File file, File[] libs, URL[] downloads) {
        if (className == null || id == null || version == null || name == null || file == null) {
            throw new IllegalArgumentException("Null argument passed to PluginDescriptor constructor.");
        }
        this.className = className;
        this.id = id;
        this.version = version;
        this.name = name;
        this.sdkVersion = sdkVersion != null ? sdkVersion : "1.4.2 or earlier";
        this.file = file;
        this.libs = libs;
        this.downloads = downloads;
    }

    public String toString() {
        return this.id + "-" + this.version;
    }

    public String getClassName() {
        return this.className;
    }

    public String getID() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getSDKVersion() {
        return this.sdkVersion;
    }

    public File getFile() {
        return this.file;
    }

    public URL[] getJars() throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (this.file.getName().endsWith(".jar")) {
            urls.add(this.file.toURI().toURL());
            for (File f : this.libs) {
                if (f.isAbsolute()) {
                    urls.add(f.toURI().toURL());
                    continue;
                }
                urls.add(new File(this.file.getParentFile(), f.getPath()).toURI().toURL());
            }
        }
        return urls.toArray(new URL[0]);
    }

    public void downloadExtras() throws MalformedURLException {
        for (URL u : this.downloads) {
            DownloadDialog dd = new DownloadDialog(DialogUtils.getMainWindow(), true);
            dd.downloadFile(u, DirectorySettings.getPluginsDirectory(), null);
        }
    }

    @Override
    public int compareTo(PluginDescriptor t) {
        return (this.id + this.version).compareTo(t.id + t.version);
    }

    public boolean isCompatible() {
        return this.sdkVersion.equals("2.0.0");
    }

    private static PluginDescriptor fromStream(InputStream input, File f) throws XMLStreamException, MalformedURLException {
        reader = XMLInputFactory.newInstance().createXMLStreamReader(input);
        String className = null;
        String id = null;
        String version = null;
        String sdkVersion = null;
        String name = null;
        ArrayList<File> libs = new ArrayList<File>();
        ArrayList<URL> downloads = new ArrayList<URL>();
        block11: do {
            switch (reader.next()) {
                case 1: {
                    switch (PluginDescriptor.readElement()) {
                        case PLUGIN: {
                            className = PluginDescriptor.readAttribute(PluginXMLAttribute.CLASS);
                            id = PluginDescriptor.readAttribute(PluginXMLAttribute.ID);
                            version = PluginDescriptor.readAttribute(PluginXMLAttribute.VERSION);
                            sdkVersion = PluginDescriptor.readAttribute(PluginXMLAttribute.SDK_VERSION);
                            name = PluginDescriptor.readAttribute(PluginXMLAttribute.NAME);
                            break;
                        }
                        case ATTRIBUTE: {
                            if (!"sdk-version".equals(PluginDescriptor.readAttribute(PluginXMLAttribute.ID))) break;
                            sdkVersion = PluginDescriptor.readAttribute(PluginXMLAttribute.VALUE);
                            break;
                        }
                        case PARAMETER: {
                            if (!"name".equals(PluginDescriptor.readAttribute(PluginXMLAttribute.ID))) break;
                            name = PluginDescriptor.readAttribute(PluginXMLAttribute.VALUE);
                            break;
                        }
                        case LIB: {
                            libs.add(new File(reader.getElementText()));
                            break;
                        }
                        case DOWNLOAD: {
                            downloads.add(new URL(reader.getElementText()));
                        }
                    }
                    continue block11;
                }
                case 8: {
                    reader.close();
                    reader = null;
                }
            }
        } while (reader != null);
        return new PluginDescriptor(className, id, version, name, sdkVersion, f, libs.toArray(new File[0]), downloads.toArray(new URL[0]));
    }

    public static PluginDescriptor fromFile(File f) throws PluginVersionException {
        block4: {
            try {
                if (f.getName().endsWith(".jar")) {
                    JarFile jar = new JarFile(f);
                    ZipEntry entry = jar.getEntry("plugin.xml");
                    if (entry != null) {
                        return PluginDescriptor.fromStream(jar.getInputStream(entry), f);
                    }
                    break block4;
                }
                return PluginDescriptor.fromStream(new FileInputStream(f), f);
            }
            catch (Exception x) {
                PluginController.LOG.info((Object)("Unable to get plugin from " + f), (Throwable)x);
            }
        }
        throw new PluginVersionException(f.getName() + " did not contain a valid plugin");
    }

    private static PluginXMLElement readElement() {
        try {
            String elemName = reader.getLocalName().toUpperCase();
            return Enum.valueOf(PluginXMLElement.class, elemName);
        }
        catch (IllegalArgumentException ignored) {
            return PluginXMLElement.IGNORED;
        }
    }

    private static String readAttribute(PluginXMLAttribute attr) {
        return reader.getAttributeValue(null, attr.toString().toLowerCase().replace('_', '-'));
    }

    private static enum PluginXMLAttribute {
        ID,
        VALUE,
        VERSION,
        CLASS,
        SDK_VERSION,
        NAME,
        IGNORED;

    }

    private static enum PluginXMLElement {
        PLUGIN,
        ATTRIBUTE,
        PARAMETER,
        LIB,
        DOWNLOAD,
        IGNORED;

    }
}

