/*
 * Decompiled with CFR 0.152.
 */
package savant.format;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.Cytoband;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.tools.PreprocessingException;
import org.broad.igv.tools.Preprocessor;
import org.broad.igv.tools.StatusMonitor;
import org.broad.igv.track.WindowFunction;
import savant.format.SavantFileFormatter;
import savant.util.MiscUtils;

public class TDFFormatter
extends SavantFileFormatter {
    protected static final List<WindowFunction> MEAN = Arrays.asList(WindowFunction.mean);
    protected static final int DEFAULT_ZOOMS = 9;
    private static final int RECORDS_PER_INTERRUPT_CHECK = 100;
    protected static final double INFER_CHROMOSOMES_FRACTION = 0.2;
    protected static final double GENERATE_TDF_FRACTION = 0.8;
    protected int lineCount;

    public TDFFormatter(File inFile, File outFile) {
        super(inFile, outFile);
    }

    @Override
    public void format() throws InterruptedException, IOException {
        Genome genome = this.getTDFGenome();
        this.setProgress(0.2, "Generating TDF file...");
        Preprocessor pp = new Preprocessor(this.outFile, genome, MEAN, this.lineCount, new TDFProgressMonitor());
        try {
            pp.preprocess(this.inFile, 9);
            pp.finish();
        }
        catch (PreprocessingException x) {
            throw new IOException(x.getMessage());
        }
    }

    protected Genome getTDFGenome() throws InterruptedException, IOException {
        Genome tdfGenome = new Genome("unknown");
        LinkedHashMap<String, Integer> chromosomeLengths = this.inferChromosomes();
        LinkedHashMap<String, Chromosome> chromosomes = new LinkedHashMap<String, Chromosome>();
        for (String ref : chromosomeLengths.keySet()) {
            String homoRef = MiscUtils.homogenizeSequence(ref);
            Cytoband band = new Cytoband(homoRef);
            band.setStart(1);
            band.setEnd(chromosomeLengths.get(ref));
            Chromosome chrom = new Chromosome(homoRef);
            chrom.addCytoband(band);
            chromosomes.put(homoRef, chrom);
        }
        tdfGenome.setChromosomeMap(chromosomes, true);
        return tdfGenome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LinkedHashMap<String, Integer> inferChromosomes() throws InterruptedException, IOException {
        LinkedHashMap<String, Integer> result = new LinkedHashMap<String, Integer>();
        this.totalBytes = this.inFile.length();
        this.inFileReader = this.openInputFile();
        this.setProgress(0.0, "Processing input file...");
        String strLine = this.inFileReader.readLine();
        String[] tokens = strLine.split("\\s");
        String mode = "none";
        int span = 1;
        int start = 1;
        int step = 1;
        int nextWrite = 1;
        String ref = null;
        this.lineCount = 1;
        try {
            while (strLine != null) {
                tokens = strLine.split("\\s");
                if (tokens.length < 1 || tokens.length > 0 && (tokens[0].equals("track") || tokens[0].equals("#") || tokens[0].equals("browser"))) {
                    strLine = this.inFileReader.readLine();
                    this.byteCount += (long)(strLine.getBytes().length + 1);
                    ++this.lineCount;
                    continue;
                }
                if (tokens[0].equals("variableStep")) {
                    if (tokens.length < 2) {
                        throw new IOException(String.format("Error parsing file at line %d (variableStep).", this.lineCount));
                    }
                    mode = "variable";
                    ref = tokens[1].substring(6);
                    span = tokens.length == 3 ? Integer.parseInt(tokens[2].substring(5)) : 1;
                } else if (tokens[0].equals("fixedStep")) {
                    if (tokens.length < 4) {
                        throw new IOException(String.format("Error parsing file at line %d (fixedStep).", this.lineCount));
                    }
                    mode = "fixed";
                    ref = tokens[1].substring(6);
                    start = Integer.parseInt(tokens[2].substring(6));
                    step = Integer.parseInt(tokens[3].substring(5));
                    span = tokens.length == 5 ? Integer.parseInt(tokens[4].substring(5)) : 1;
                } else if (tokens.length == 4) {
                    int end;
                    mode = "bedGraph";
                    ref = tokens[0];
                    nextWrite = end = Integer.parseInt(tokens[2]);
                } else if (mode.equals("variable")) {
                    if (tokens.length < 2) {
                        throw new IOException(String.format("Error parsing file at line %d (too few tokens on variable line).", this.lineCount));
                    }
                    int dest = Integer.parseInt(tokens[0]);
                    nextWrite = dest + span;
                } else if (mode.equals("fixed")) {
                    nextWrite = start + span;
                    start += step;
                } else if (mode.equals("none")) {
                    throw new IOException("Error parsing file (no format line)");
                }
                Integer len = result.get(ref);
                if (len == null || nextWrite > len) {
                    result.put(ref, new Integer(nextWrite));
                }
                if ((strLine = this.inFileReader.readLine()) == null) continue;
                this.byteCount += (long)(strLine.getBytes().length + 1);
                ++this.lineCount;
                if (this.lineCount % 100 != 0) continue;
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                this.setProgress(0.2 * (double)this.byteCount / (double)this.totalBytes, null);
            }
        }
        finally {
            this.inFileReader.close();
        }
        return result;
    }

    class TDFProgressMonitor
    implements StatusMonitor {
        double percentComplete = 0.0;

        TDFProgressMonitor() {
        }

        @Override
        public void setPercentComplete(double d) {
            this.percentComplete = d;
            TDFFormatter.this.setProgress(0.2 + d * 0.01 * 0.8, null);
        }

        @Override
        public void incrementPercentComplete(double d) {
            this.setPercentComplete(d + this.percentComplete);
        }

        @Override
        public boolean isInterrupted() {
            return Thread.interrupted();
        }
    }
}

