/*
 * Decompiled with CFR 0.152.
 */
package savant.data.types;

import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.api.data.VariantRecord;
import savant.api.data.VariantType;
import savant.data.types.TabixIntervalRecord;
import savant.util.ColumnMapping;

public class VCFVariantRecord
extends TabixIntervalRecord
implements VariantRecord {
    private static final Log LOG = LogFactory.getLog(VCFVariantRecord.class);
    private static final int NAME_COLUMN = 2;
    private static final int REF_COLUMN = 3;
    private static final int ALT_COLUMN = 4;
    private static final int FIRST_PARTICIPANT_COLUMN = 9;
    private static final byte MISSING = -1;
    private final String reference = super.getReference().intern();
    private final String name = this.values[2].equals(".") ? null : this.values[2];
    private final String refBases = this.values[3].intern();
    private final String[] altBases;
    private final byte[] participants0;
    private final byte[] participants1;
    private boolean phased = true;

    protected VCFVariantRecord(String line, ColumnMapping mapping) {
        super(line, mapping);
        int i;
        String altValue = this.values[4];
        if (altValue.startsWith("<")) {
            this.altBases = new String[]{altValue.intern()};
        } else {
            this.altBases = altValue.split(",");
            for (i = 0; i < this.altBases.length; ++i) {
                this.altBases[i] = this.altBases[i].intern();
            }
        }
        if (this.values.length > 9) {
            this.participants0 = new byte[this.values.length - 9];
            this.participants1 = new byte[this.values.length - 9];
            for (i = 0; i < this.participants0.length; ++i) {
                String info = this.values[9 + i];
                this.participants0[i] = -1;
                this.participants1[i] = -1;
                if (info.equals(".")) continue;
                int colonPos = info.indexOf(58);
                if (colonPos >= 0) {
                    info = info.substring(0, colonPos);
                }
                this.phased &= info.indexOf(47) < 0;
                String[] alleleIndices = info.split("[|/]");
                if (!alleleIndices[0].equals(".")) {
                    this.participants0[i] = Byte.parseByte(alleleIndices[0]);
                }
                if (alleleIndices.length <= 1 || alleleIndices[1].equals(".")) continue;
                this.participants1[i] = Byte.parseByte(alleleIndices[1]);
            }
        } else {
            this.participants0 = new byte[0];
            this.participants1 = new byte[0];
        }
        this.values = null;
    }

    public String toString() {
        return this.getVariantType().toString() + "@" + this.getInterval().getStart();
    }

    @Override
    public int compareTo(Object t) {
        VariantRecord that = (VariantRecord)t;
        return new CompareToBuilder().append((Object)this.getReference(), (Object)that.getReference()).append(this.getPosition(), that.getPosition()).append((Object)this.getRefBases(), (Object)that.getRefBases()).append((Object[])this.getAltAlleles(), (Object[])that.getAltAlleles()).toComparison();
    }

    @Override
    public boolean equals(Object t) {
        if (t instanceof VariantRecord) {
            VariantRecord that = (VariantRecord)t;
            return new EqualsBuilder().append((Object)this.getReference(), (Object)that.getReference()).append(this.getPosition(), that.getPosition()).append((Object)this.getRefBases(), (Object)that.getRefBases()).append((Object[])this.getAltAlleles(), (Object[])that.getAltAlleles()).isEquals();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getReference()).append(this.getPosition()).append((Object)this.getRefBases()).append((Object[])this.getAltAlleles()).toHashCode();
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public int getPosition() {
        return this.interval.getStart();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getRefBases() {
        return this.refBases;
    }

    @Override
    public String[] getAltAlleles() {
        return this.altBases;
    }

    @Override
    public int getParticipantCount() {
        return this.participants0.length;
    }

    @Override
    public VariantType[] getVariantsForParticipant(int index) {
        int[] alleles = this.getAllelesForParticipant(index);
        if (alleles == null) {
            return null;
        }
        if (alleles.length == 1) {
            return new VariantType[]{this.getVariantType(alleles[0])};
        }
        return new VariantType[]{this.getVariantType(alleles[0]), this.getVariantType(alleles[1])};
    }

    @Override
    public int[] getAllelesForParticipant(int index) {
        int allele0 = this.participants0[index];
        if (allele0 == -1) {
            return null;
        }
        int allele1 = this.participants1[index];
        if (allele0 == allele1 || allele1 == -1) {
            return new int[]{allele0};
        }
        return new int[]{allele0, allele1};
    }

    @Override
    public VariantType getVariantType() {
        return this.getVariantType(this.altBases[0]);
    }

    @Override
    public boolean isPhased() {
        return this.phased;
    }

    private VariantType getVariantType(int index) {
        return index > 0 ? this.getVariantType(this.altBases[index - 1]) : VariantType.NONE;
    }

    private VariantType getVariantType(String alt) {
        if (this.refBases.length() == 1 && alt.length() == 1) {
            switch (alt.charAt(0)) {
                case 'A': {
                    return VariantType.SNP_A;
                }
                case 'C': {
                    return VariantType.SNP_C;
                }
                case 'G': {
                    return VariantType.SNP_G;
                }
                case 'T': {
                    return VariantType.SNP_T;
                }
            }
            LOG.info((Object)("Unrecognised base " + alt + " in VCFVariantRecord."));
            return VariantType.OTHER;
        }
        switch (alt.charAt(0)) {
            case '<': {
                if (alt.startsWith("<INS")) {
                    return VariantType.INSERTION;
                }
                if (alt.startsWith("<DEL")) {
                    return VariantType.DELETION;
                }
                return VariantType.OTHER;
            }
            case 'I': {
                return VariantType.INSERTION;
            }
            case 'D': {
                return VariantType.DELETION;
            }
        }
        if (alt.length() > this.refBases.length()) {
            return VariantType.INSERTION;
        }
        if (alt.length() < this.refBases.length()) {
            return VariantType.DELETION;
        }
        int numDiffs = 0;
        VariantType result = VariantType.NONE;
        for (int i = 0; i < alt.length() && numDiffs <= 1; ++i) {
            if (alt.charAt(i) == this.refBases.charAt(i)) continue;
            ++numDiffs;
            result = VariantType.fromChar(alt.charAt(i));
        }
        if (numDiffs <= 1) {
            return result;
        }
        return VariantType.OTHER;
    }
}

