/*
 * Decompiled with CFR 0.152.
 */
package savant.data.types;

import savant.api.adapter.RangeAdapter;
import savant.api.data.Interval;
import savant.api.data.IntervalRecord;
import savant.data.types.GFFIntervalRecord;
import savant.data.types.GTFIntervalRecord;
import savant.data.types.TabixRichIntervalRecord;
import savant.data.types.VCFVariantRecord;
import savant.util.ColumnMapping;

public class TabixIntervalRecord
implements IntervalRecord {
    protected String[] values;
    protected final ColumnMapping mapping;
    protected Interval interval;
    private int count = 0;

    protected TabixIntervalRecord(String s, ColumnMapping mapping) {
        int end;
        if (s.endsWith("\t")) {
            this.values = (s + " ").split("\\t");
            this.values[this.values.length - 1] = "";
        } else {
            this.values = s.split("\\t");
        }
        this.mapping = mapping;
        int start = Integer.parseInt(this.values[mapping.start]);
        int n = end = mapping.end >= 0 ? Integer.parseInt(this.values[mapping.end]) : start;
        if (!mapping.oneBased) {
            ++start;
        }
        this.interval = Interval.valueOf(start, end);
    }

    public static TabixIntervalRecord valueOf(String s, ColumnMapping mapping) {
        switch (mapping.format) {
            case RICH_INTERVAL: {
                if (mapping == ColumnMapping.GFF) {
                    return new GFFIntervalRecord(s);
                }
                if (mapping == ColumnMapping.GTF) {
                    return new GTFIntervalRecord(s);
                }
                return new TabixRichIntervalRecord(s, mapping);
            }
            case VARIANT: {
                return new VCFVariantRecord(s, mapping);
            }
        }
        return new TabixIntervalRecord(s, mapping);
    }

    @Override
    public String getReference() {
        return this.values[this.mapping.chrom];
    }

    @Override
    public Interval getInterval() {
        return this.interval;
    }

    @Override
    public String getName() {
        return this.mapping.name >= 0 ? this.values[this.mapping.name] : null;
    }

    public String[] getValues() {
        return this.values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TabixIntervalRecord that = (TabixIntervalRecord)o;
        if (!this.interval.equals(that.interval)) {
            return false;
        }
        if (this.values.length != that.values.length) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i].equals(that.values[i])) continue;
            return false;
        }
        return this.count == that.count;
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + (this.interval != null ? this.interval.hashCode() : 0);
        hash = 47 * hash + this.values.hashCode();
        hash = 47 * hash + this.count;
        return hash;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int compareTo(Object o) {
        TabixIntervalRecord that = (TabixIntervalRecord)o;
        if (!this.interval.equals(that.interval)) {
            return this.interval.compareTo(that.interval);
        }
        if (this.values.length < that.values.length) {
            return -1;
        }
        if (this.values.length > that.values.length) {
            return 1;
        }
        for (int i = 0; i < this.values.length; ++i) {
            int compare = this.values[i].compareTo(that.values[i]);
            if (compare == 0) continue;
            return compare;
        }
        if (this.count < that.count) {
            return -1;
        }
        if (this.count > that.count) {
            return 1;
        }
        return 0;
    }

    public RangeAdapter getExpandedRange(RangeAdapter r) {
        return null;
    }
}

