/*
 * Decompiled with CFR 0.152.
 */
package savant.data.types;

import savant.api.data.Interval;
import savant.api.data.IntervalRecord;

public class GenericIntervalRecord
implements IntervalRecord {
    public static final String[] COLUMN_NAMES = new String[]{"Reference", "From", "To", "Description"};
    private final String reference;
    private final Interval interval;
    private final String name;

    protected GenericIntervalRecord(String reference, Interval interval, String name) {
        if (reference == null) {
            throw new IllegalArgumentException("reference must not be null");
        }
        if (interval == null) {
            throw new IllegalArgumentException("Invalid argument. Interval must not be null");
        }
        this.reference = reference;
        this.interval = interval;
        this.name = name;
    }

    public static GenericIntervalRecord valueOf(String reference, Interval interval, String description) {
        return new GenericIntervalRecord(reference, interval, description);
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public Interval getInterval() {
        return this.interval;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericIntervalRecord that = (GenericIntervalRecord)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (!this.interval.equals(that.interval)) {
            return false;
        }
        return this.reference.equals(that.reference);
    }

    public int hashCode() {
        int result = this.reference.hashCode();
        result = 31 * result + this.interval.hashCode();
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GenericIntervalRecord");
        sb.append("{reference='").append(this.reference).append('\'');
        sb.append(", interval=").append(this.interval);
        sb.append(", description='").append(this.name).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public int compareTo(Object o) {
        int b;
        int a;
        GenericIntervalRecord other = (GenericIntervalRecord)o;
        if (!this.reference.equals(other.getReference())) {
            String a1 = this.reference;
            String a2 = other.getReference();
            for (int i = 0; i < Math.min(a1.length(), a2.length()); ++i) {
                if (a1.charAt(i) < a2.charAt(i)) {
                    return -1;
                }
                if (a1.charAt(i) <= a2.charAt(i)) continue;
                return 1;
            }
            if (a1.length() < a2.length()) {
                return -1;
            }
            if (a1.length() > a2.length()) {
                return 1;
            }
        }
        if ((a = this.getInterval().getStart()) == (b = other.getInterval().getStart())) {
            return this.name.compareTo(other.name);
        }
        if (a < b) {
            return -1;
        }
        return 1;
    }
}

