/*
 * Decompiled with CFR 0.152.
 */
package savant.data.types;

import java.util.Collections;
import java.util.List;
import savant.api.data.Block;
import savant.api.data.Interval;
import savant.api.data.RichIntervalRecord;
import savant.api.data.Strand;
import savant.data.types.ItemRGB;

public class BEDIntervalRecord
implements RichIntervalRecord {
    private final Interval interval;
    private final List<Block> blocks;
    private final String chrom;
    private final String name;
    private final float score;
    private final Strand strand;
    private final int thickStart;
    private final int thickEnd;
    private final ItemRGB itemRGB;

    protected BEDIntervalRecord(String chrom, int start, int end, String name, float score, Strand strand, int thickStart, int thickEnd, ItemRGB rgb, List<Block> blocks) {
        if (chrom == null) {
            throw new IllegalArgumentException("Invalid argument: chrom may not be null");
        }
        this.interval = Interval.valueOf(start, end - 1);
        this.chrom = chrom;
        this.name = name;
        this.score = score;
        this.strand = strand;
        this.thickStart = thickStart;
        this.thickEnd = thickEnd;
        this.itemRGB = rgb;
        this.blocks = blocks;
    }

    public static BEDIntervalRecord valueOf(String chrom, int start, int end, String name, float score, Strand strand, int thickStart, int thickEnd, ItemRGB rgb, List<Block> blocks) {
        return new BEDIntervalRecord(chrom, start, end, name, score, strand, thickStart, thickEnd, rgb, blocks);
    }

    @Override
    public Interval getInterval() {
        return this.interval;
    }

    @Override
    public String getAlternateName() {
        return null;
    }

    @Override
    public List<Block> getBlocks() {
        return this.blocks != null ? Collections.unmodifiableList(this.blocks) : null;
    }

    public String getChrom() {
        return this.chrom;
    }

    @Override
    public String getReference() {
        return this.getChrom();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getChromStart() {
        return this.getInterval().getStart();
    }

    public int getChromEnd() {
        return this.getInterval().getEnd();
    }

    @Override
    public float getScore() {
        return this.score;
    }

    @Override
    public Strand getStrand() {
        return this.strand;
    }

    @Override
    public int getThickStart() {
        return this.thickStart;
    }

    @Override
    public int getThickEnd() {
        return this.thickEnd;
    }

    @Override
    public ItemRGB getItemRGB() {
        return this.itemRGB;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BEDIntervalRecord that = (BEDIntervalRecord)o;
        if (this.score != that.score) {
            return false;
        }
        if (this.thickEnd != that.thickEnd) {
            return false;
        }
        if (this.thickStart != that.thickStart) {
            return false;
        }
        if (this.blocks != null ? !this.blocks.equals(that.blocks) : that.blocks != null) {
            return false;
        }
        if (!this.chrom.equals(that.chrom)) {
            return false;
        }
        if (!this.interval.equals(that.interval)) {
            return false;
        }
        if (this.itemRGB != null ? !this.itemRGB.equals(that.itemRGB) : that.itemRGB != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return this.strand == that.strand;
    }

    public int compareTo(Object o) {
        int b;
        int a;
        BEDIntervalRecord other = (BEDIntervalRecord)o;
        if (!this.getChrom().equals(other.getChrom())) {
            String a1 = this.getChrom();
            String a2 = other.getChrom();
            for (int i = 0; i < Math.min(a1.length(), a2.length()); ++i) {
                if (a1.charAt(i) < a2.charAt(i)) {
                    return -1;
                }
                if (a1.charAt(i) <= a2.charAt(i)) continue;
                return 1;
            }
            if (a1.length() < a2.length()) {
                return -1;
            }
            if (a1.length() > a2.length()) {
                return 1;
            }
        }
        if ((a = this.getChromStart()) == (b = other.getChromStart())) {
            String a1 = this.getName();
            String a2 = other.getName();
            for (int i = 0; i < Math.min(a1.length(), a2.length()); ++i) {
                if (a1.charAt(i) < a2.charAt(i)) {
                    return -1;
                }
                if (a1.charAt(i) <= a2.charAt(i)) continue;
                return 1;
            }
            if (a1.length() < a2.length()) {
                return -1;
            }
            if (a1.length() > a2.length()) {
                return 1;
            }
            return 0;
        }
        if (a < b) {
            return -1;
        }
        return 1;
    }

    public int hashCode() {
        int result = this.interval != null ? this.interval.hashCode() : 0;
        result = 31 * result + (this.blocks != null ? this.blocks.hashCode() : 0);
        result = 31 * result + (this.chrom != null ? this.chrom.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.score != 0.0f ? Float.floatToIntBits(this.score) : 0);
        result = 31 * result + (this.strand != null ? this.strand.hashCode() : 0);
        result = 31 * result + this.thickStart;
        result = 31 * result + this.thickEnd;
        result = 31 * result + (this.itemRGB != null ? this.itemRGB.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BEDIntervalRecord");
        sb.append("{interval=").append(this.interval);
        sb.append(", blocks=").append(this.blocks);
        sb.append(", chrom='").append(this.chrom).append('\'');
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", score=").append(this.score);
        sb.append(", strand=").append((Object)this.strand);
        sb.append(", thickStart=").append(this.thickStart);
        sb.append(", thickEnd=").append(this.thickEnd);
        sb.append(", itemRGB=").append(this.itemRGB);
        sb.append('}');
        return sb.toString();
    }
}

