/*
 * Decompiled with CFR 0.152.
 */
package savant.data.types;

import java.awt.Color;
import net.sf.samtools.SAMRecord;
import savant.api.data.Interval;
import savant.api.data.IntervalRecord;

public class BAMIntervalRecord
implements IntervalRecord {
    private final Interval interval;
    private final SAMRecord samRecord;
    private Color overrideColor = null;

    protected BAMIntervalRecord(SAMRecord samRecord) {
        if (samRecord == null) {
            throw new IllegalArgumentException("samRecord must not be null");
        }
        this.interval = Interval.valueOf(samRecord.getAlignmentStart(), samRecord.getAlignmentEnd());
        this.samRecord = samRecord;
    }

    public static BAMIntervalRecord valueOf(SAMRecord samRecord) {
        return new BAMIntervalRecord(samRecord);
    }

    @Override
    public String getReference() {
        return this.samRecord.getReferenceName();
    }

    @Override
    public Interval getInterval() {
        return this.interval;
    }

    @Override
    public String getName() {
        return this.samRecord.getReadName();
    }

    public SAMRecord getSAMRecord() {
        return this.samRecord;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BAMIntervalRecord that = (BAMIntervalRecord)o;
        if (!this.interval.equals(that.interval)) {
            return false;
        }
        return this.samRecord.equals((Object)that.samRecord);
    }

    public int hashCode() {
        int result = this.interval.hashCode();
        result = 31 * result + this.samRecord.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BAMIntervalRecord");
        sb.append("{interval=").append(this.interval);
        sb.append(", samRecord=").append(this.samRecord);
        sb.append('}');
        return sb.toString();
    }

    public int compareTo(Object o) {
        int b;
        int a;
        SAMRecord otherSam = ((BAMIntervalRecord)o).getSAMRecord();
        SAMRecord thisSam = this.getSAMRecord();
        if (!thisSam.getReferenceName().equals(otherSam.getReferenceName())) {
            String a1 = thisSam.getReferenceName();
            String a2 = otherSam.getReferenceName();
            for (int i = 0; i < Math.min(a1.length(), a2.length()); ++i) {
                if (a1.charAt(i) < a2.charAt(i)) {
                    return -1;
                }
                if (a1.charAt(i) <= a2.charAt(i)) continue;
                return 1;
            }
            if (a1.length() < a2.length()) {
                return -1;
            }
            if (a1.length() > a2.length()) {
                return 1;
            }
        }
        if ((a = thisSam.getAlignmentStart()) == (b = otherSam.getAlignmentStart())) {
            String a1 = thisSam.getReadName();
            String a2 = otherSam.getReadName();
            for (int i = 0; i < Math.min(a1.length(), a2.length()); ++i) {
                if (a1.charAt(i) < a2.charAt(i)) {
                    return -1;
                }
                if (a1.charAt(i) <= a2.charAt(i)) continue;
                return 1;
            }
            if (a1.length() < a2.length()) {
                return -1;
            }
            if (a1.length() > a2.length()) {
                return 1;
            }
            if (thisSam.getReadNegativeStrandFlag() == otherSam.getReadNegativeStrandFlag()) {
                return 0;
            }
            if (thisSam.getReadNegativeStrandFlag()) {
                return 1;
            }
            return -1;
        }
        if (a < b) {
            return -1;
        }
        return 1;
    }

    public Color getColor() {
        return this.overrideColor;
    }

    public void setColor(Color color) {
        this.overrideColor = color;
    }
}

