/*
 * Decompiled with CFR 0.152.
 */
package savant.data.sources;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sf.samtools.util.BlockCompressedInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.api.adapter.BookmarkAdapter;
import savant.api.adapter.DataSourceAdapter;
import savant.api.adapter.RangeAdapter;
import savant.api.data.Record;
import savant.api.util.RangeUtils;
import savant.controller.BookmarkController;
import savant.util.Bookmark;
import savant.util.IOUtils;
import savant.util.NetworkUtils;

public abstract class DataSource<E extends Record>
implements DataSourceAdapter {
    private static final Log LOG = LogFactory.getLog(DataSource.class);
    private TreeMap<String, List<BookmarkAdapter>> dictionary;
    private int dictionaryCount;

    @Override
    public String getName() {
        return NetworkUtils.getNeatPathFromURI(this.getURI());
    }

    @Override
    public void loadDictionary() throws IOException {
        TreeMap newDict = new TreeMap();
        this.dictionaryCount = 0;
        URI dictionaryURI = URI.create(this.getURI().toString() + ".dict");
        if (NetworkUtils.exists(dictionaryURI)) {
            LOG.info((Object)("Starting to load dictionary from " + dictionaryURI));
            int lineNum = 0;
            try {
                String line = null;
                BlockCompressedInputStream input = new BlockCompressedInputStream(NetworkUtils.getSeekableStreamForURI(dictionaryURI));
                while ((line = IOUtils.readLine((InputStream)input)) != null) {
                    String[] words = line.split("\\t");
                    String key = words[0].toLowerCase();
                    ArrayList<Bookmark> marks = (ArrayList<Bookmark>)newDict.get(key);
                    if (marks == null) {
                        marks = new ArrayList<Bookmark>();
                        newDict.put(key, marks);
                    }
                    Bookmark newMark = new Bookmark(words[1], words[0]);
                    for (BookmarkAdapter bookmarkAdapter : marks) {
                        if (!bookmarkAdapter.getReference().equals(newMark.getReference()) || !RangeUtils.intersects(bookmarkAdapter.getRange(), newMark.getRange())) continue;
                        RangeAdapter newRange = RangeUtils.union(bookmarkAdapter.getRange(), newMark.getRange());
                        bookmarkAdapter.setRange(newRange);
                        newMark = null;
                        break;
                    }
                    if (newMark != null) {
                        marks.add(newMark);
                        ++this.dictionaryCount;
                    }
                    ++lineNum;
                }
                this.dictionary = newDict;
            }
            catch (ParseException x) {
                throw new IOException("Parse error in dictionary at line " + lineNum, x);
            }
            catch (NumberFormatException x) {
                throw new IOException("Parse error in dictionary at line " + lineNum, x);
            }
            LOG.info((Object)("Finished loading dictionary from " + dictionaryURI));
        }
    }

    @Override
    public List<BookmarkAdapter> lookup(String key) {
        if (this.dictionary != null) {
            if (key.endsWith("*")) {
                String k0 = key.substring(0, key.length() - 1);
                String k1 = k0 + '\uffff';
                SortedMap<String, List<BookmarkAdapter>> subDict = this.dictionary.subMap(k0, k1);
                ArrayList<BookmarkAdapter> result = new ArrayList<BookmarkAdapter>();
                for (List bms : subDict.values()) {
                    result.addAll(bms);
                }
                return result;
            }
            return this.dictionary.get(key);
        }
        return null;
    }

    public int getDictionaryCount() {
        return this.dictionaryCount;
    }

    public void addDictionaryToBookmarks() {
        if (this.dictionary != null) {
            for (String k : this.dictionary.keySet()) {
                for (BookmarkAdapter b : this.dictionary.get(k)) {
                    BookmarkController.getInstance().addBookmark((Bookmark)b);
                }
            }
        }
    }
}

