/*
 * Decompiled with CFR 0.152.
 */
package savant.data.sources;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.samtools.util.SeekableStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broad.igv.bbfile.BBFileReader;
import org.broad.igv.bbfile.BigWigIterator;
import org.broad.igv.bbfile.WigItem;
import savant.api.adapter.RangeAdapter;
import savant.api.adapter.RecordFilterAdapter;
import savant.api.data.DataFormat;
import savant.api.util.Resolution;
import savant.data.sources.DataSource;
import savant.data.types.GenericContinuousRecord;
import savant.util.NetworkUtils;

public class BigWigDataSource
extends DataSource<GenericContinuousRecord> {
    private static final Log LOG = LogFactory.getLog(BigWigDataSource.class);
    private BBFileReader bbReader;

    public BigWigDataSource(URI uri) throws IOException {
        this.bbReader = new BBFileReader(NetworkUtils.getNeatPathFromURI(uri), new TribbleStream(uri));
        if (!this.bbReader.isBigWigFile()) {
            throw new IOException("Input is not a BigWig file.");
        }
    }

    @Override
    public Set<String> getReferenceNames() {
        HashSet<String> result = new HashSet<String>();
        for (String chr : this.bbReader.getChromosomeNames()) {
            result.add(chr);
        }
        return result;
    }

    public List<GenericContinuousRecord> getRecords(String ref, RangeAdapter range, Resolution resolution, RecordFilterAdapter filt) throws IOException, InterruptedException {
        ArrayList<GenericContinuousRecord> result = new ArrayList<GenericContinuousRecord>();
        try {
            BigWigIterator wigIterator = this.bbReader.getBigWigIterator(ref, range.getFrom(), ref, range.getTo(), false);
            int nextPos = range.getFrom();
            int rangeEnd = range.getTo();
            while (wigIterator.hasNext()) {
                WigItem wig = wigIterator.next();
                int datumStart = wig.getStartBase();
                int datumEnd = wig.getEndBase();
                float value = wig.getWigValue();
                while (nextPos < datumStart && nextPos <= rangeEnd) {
                    result.add(GenericContinuousRecord.valueOf(ref, nextPos, Float.NaN));
                    ++nextPos;
                }
                while (nextPos < datumEnd && nextPos <= rangeEnd) {
                    result.add(GenericContinuousRecord.valueOf(ref, nextPos, value));
                    ++nextPos;
                }
                if (!Thread.interrupted()) continue;
                throw new InterruptedException();
            }
        }
        catch (RuntimeException ignored) {
            // empty catch block
        }
        return result;
    }

    @Override
    public URI getURI() {
        return NetworkUtils.getURIFromPath(this.bbReader.getBBFilePath());
    }

    @Override
    public void close() {
    }

    @Override
    public DataFormat getDataFormat() {
        return DataFormat.CONTINUOUS;
    }

    @Override
    public final String[] getColumnNames() {
        return GenericContinuousRecord.COLUMN_NAMES;
    }

    private static class TribbleStream
    extends org.broad.tribble.util.SeekableStream {
        SeekableStream samStream;
        long pos;

        TribbleStream(URI uri) throws IOException {
            this.samStream = NetworkUtils.getSeekableStreamForURI(uri, true);
            this.pos = 0L;
        }

        @Override
        public void seek(long position) throws IOException {
            this.samStream.seek(position);
            this.pos = position;
        }

        @Override
        public long position() throws IOException {
            return this.pos;
        }

        @Override
        public boolean eof() throws IOException {
            return this.samStream.eof();
        }

        @Override
        public long length() {
            return this.samStream.length();
        }

        @Override
        public int read() throws IOException {
            throw new UnsupportedOperationException("TribbleStream.read() not implemented.");
        }

        @Override
        public void readFully(byte[] buf) throws IOException {
            int numRead = this.samStream.read(buf, 0, buf.length);
            this.pos += (long)numRead;
        }
    }
}

