/*
 * Decompiled with CFR 0.152.
 */
package savant.controller;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import savant.api.util.DialogUtils;
import savant.api.util.Listener;
import savant.controller.ProjectController;
import savant.controller.event.ProjectEvent;
import savant.settings.DirectorySettings;

public class RecentProjectsController
implements Listener<ProjectEvent> {
    private final String RECENT_PROJECTS_FILE = ".recent_projects";
    private final int NUM_RECENTS_TO_SAVE = 10;
    JMenu menu;
    LinkedList<String> queue;
    File recentProjectsFile = new File(DirectorySettings.getSavantDirectory(), ".recent_projects");
    private static RecentProjectsController instance;

    public static RecentProjectsController getInstance() throws IOException {
        if (instance == null) {
            instance = new RecentProjectsController();
            ProjectController.getInstance().addListener(instance);
        }
        return instance;
    }

    private RecentProjectsController() throws IOException {
        if (!this.recentProjectsFile.exists()) {
            this.recentProjectsFile.createNewFile();
        }
        this.queue = new LinkedList();
        this.loadRecents(this.recentProjectsFile);
    }

    private void addProjectFile(File filename) {
        this.queue.remove(filename.getAbsolutePath());
        this.resizeQueue(this.queue, 10);
        this.queue.add(0, filename.getAbsolutePath());
        try {
            this.saveRecents(this.queue);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.updateMenuList();
    }

    private void saveRecents(LinkedList<String> queue) throws IOException {
        this.recentProjectsFile.delete();
        this.recentProjectsFile.createNewFile();
        BufferedWriter w = new BufferedWriter(new FileWriter(this.recentProjectsFile));
        for (String s : queue) {
            w.write(s + "\n");
        }
        w.close();
    }

    private void resizeQueue(LinkedList queue, int size) {
        while (queue.size() > size) {
            queue.removeLast();
        }
    }

    private void loadRecents(File f) throws IOException {
        BufferedReader r = new BufferedReader(new FileReader(f));
        String line = "";
        while ((line = r.readLine()) != null) {
            this.queue.add(line);
        }
        r.close();
    }

    public void populateMenu(JMenu m) {
        this.menu = m;
        this.updateMenuList();
    }

    private void updateMenuList() {
        this.menu.removeAll();
        for (final String s : this.queue) {
            JMenuItem item = new JMenuItem();
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        if (ProjectController.getInstance().promptToSaveChanges(false)) {
                            ProjectController.getInstance().loadProjectFromFile(new File(s));
                        }
                    }
                    catch (Exception ex) {
                        DialogUtils.displayException("Project Error", "Error opening project from file " + s, ex);
                    }
                }
            });
            item.setText(s);
            this.menu.add(item);
        }
        this.menu.add(new JSeparator());
        JMenuItem item = new JMenuItem();
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RecentProjectsController.getInstance().clearRecents();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        item.setText("Clear Recents");
        this.menu.add(item);
    }

    public List<String> getRecentProjects() {
        return this.queue;
    }

    private void clearRecents() {
        while (!this.queue.isEmpty()) {
            this.queue.remove(0);
        }
        try {
            this.saveRecents(this.queue);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.updateMenuList();
    }

    @Override
    public void handleEvent(ProjectEvent event) {
        switch (event.getType()) {
            case LOADED: 
            case SAVED: {
                File f = new File(event.getPath());
                if (!f.exists()) break;
                this.addProjectFile(f);
            }
        }
    }
}

