/*
 * Decompiled with CFR 0.152.
 */
package savant.controller;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.api.event.BookmarksChangedEvent;
import savant.api.event.LocationChangedEvent;
import savant.api.event.TrackEvent;
import savant.api.util.DialogUtils;
import savant.api.util.Listener;
import savant.controller.BookmarkController;
import savant.controller.GenomeController;
import savant.controller.LocationController;
import savant.controller.TrackController;
import savant.controller.event.ProjectEvent;
import savant.data.types.Genome;
import savant.file.Project;
import savant.settings.DirectorySettings;
import savant.util.Controller;
import savant.util.FileExtensionFilter;
import savant.util.NetworkUtils;
import savant.view.swing.Savant;

public class ProjectController
extends Controller {
    private static final Log LOG = LogFactory.getLog(ProjectController.class);
    private static final FileFilter PROJECT_FILTER = new FileExtensionFilter("Savant project files", "svp");
    private static final File UNTITLED_PROJECT_FILE = new File("Untitled Project.svp");
    private static ProjectController instance;
    private boolean projectSaved = true;
    private File currentProjectFile = null;
    private List<String> pendingTracks = null;

    public static ProjectController getInstance() {
        if (instance == null) {
            instance = new ProjectController();
        }
        return instance;
    }

    private ProjectController() {
        BookmarkController.getInstance().addListener(new Listener<BookmarksChangedEvent>(){

            @Override
            public void handleEvent(BookmarksChangedEvent event) {
                ProjectController.this.setProjectSaved(false);
            }
        });
        LocationController.getInstance().addListener(new Listener<LocationChangedEvent>(){

            @Override
            public void handleEvent(LocationChangedEvent event) {
                if (ProjectController.this.pendingTracks == null) {
                    ProjectController.this.setProjectSaved(false);
                }
            }
        });
        TrackController.getInstance().addListener(new Listener<TrackEvent>(){

            @Override
            public void handleEvent(TrackEvent event) {
                if (event.getType() == TrackEvent.Type.ADDED || event.getType() == TrackEvent.Type.REMOVED) {
                    if (ProjectController.this.pendingTracks != null) {
                        ProjectController.this.pendingTracks.remove(NetworkUtils.getNeatPathFromURI(event.getTrack().getDataSource().getURI()));
                        if (ProjectController.this.pendingTracks.isEmpty()) {
                            ProjectController.this.pendingTracks = null;
                            ProjectController.this.fireEvent(new ProjectEvent(ProjectEvent.Type.LOADED, ProjectController.this.getCurrentFile()));
                            ProjectController.this.setProjectSaved(true);
                        }
                    } else {
                        ProjectController.this.setProjectSaved(false);
                    }
                }
            }
        });
    }

    public void clearExistingProject() {
        TrackController.getInstance().closeTracks();
        BookmarkController.getInstance().clearBookmarks();
    }

    public boolean saveProjectAs(File f) throws Exception {
        try {
            this.fireEvent(new ProjectEvent(ProjectEvent.Type.SAVING, f));
            Project.saveToFile(f);
            this.currentProjectFile = f;
            this.setProjectSaved(true);
            return true;
        }
        catch (IOException ex) {
            LOG.error((Object)ex);
            if (DialogUtils.askYesNo("<html>Error saving project to <i>" + f.getAbsolutePath() + "</i>. Try another location?</html>") == 0) {
                return this.promptToSaveProjectAs();
            }
            return false;
        }
    }

    public static boolean isProjectOpen() {
        return GenomeController.getInstance().isGenomeLoaded();
    }

    public boolean isProjectSaved() {
        return this.projectSaved;
    }

    private void setProjectSaved(boolean saved) {
        if (this.projectSaved != saved) {
            this.projectSaved = saved;
            this.fireEvent(new ProjectEvent(saved ? ProjectEvent.Type.SAVED : ProjectEvent.Type.UNSAVED, this.getCurrentFile()));
        }
    }

    public void promptToLoadProject() throws Exception {
        File f;
        if (this.promptToSaveChanges(false) && (f = DialogUtils.chooseFileForOpen("Open Project File", PROJECT_FILTER, DirectorySettings.getProjectsDirectory())) != null) {
            this.loadProjectFromFile(f);
        }
    }

    public boolean promptToSaveChanges(boolean quitting) throws Exception {
        if (ProjectController.isProjectOpen() && Savant.getInstance().isStandalone() && !this.projectSaved) {
            int result = DialogUtils.askYesNoCancel(quitting ? "Save changes to current project before quitting?" : "Save changes to current project?");
            if (result == 0) {
                this.promptToSaveProject();
            } else if (result == 2) {
                return false;
            }
        }
        return true;
    }

    public boolean promptToSaveProject() throws Exception {
        if (this.currentProjectFile == null) {
            return this.promptToSaveProjectAs();
        }
        return this.saveProjectAs(this.currentProjectFile);
    }

    public boolean promptToSaveProjectAs() throws Exception {
        if (!ProjectController.isProjectOpen()) {
            DialogUtils.displayMessage("No project to save.");
            return false;
        }
        File selectedFile = DialogUtils.chooseFileForSave("Save Project", this.getCurrentFile().getName(), PROJECT_FILTER, DirectorySettings.getProjectsDirectory());
        if (selectedFile != null) {
            return this.saveProjectAs(selectedFile);
        }
        return false;
    }

    private File getCurrentFile() {
        return this.currentProjectFile != null ? this.currentProjectFile : UNTITLED_PROJECT_FILE;
    }

    public void loadProjectFromFile(File f) throws Exception {
        this.fireEvent(new ProjectEvent(ProjectEvent.Type.LOADING, f));
        this.currentProjectFile = f;
        this.clearExistingProject();
        Project proj = new Project(f);
        this.pendingTracks = proj.getInitialTracks();
        proj.load();
    }

    public void loadProjectFromURL(String urlString) throws Exception {
        int oneChar;
        URL url = new URL(urlString);
        InputStream is = url.openStream();
        FileOutputStream fos = null;
        String localName = null;
        StringTokenizer st = new StringTokenizer(url.getFile(), "/");
        while (st.hasMoreTokens()) {
            localName = st.nextToken();
        }
        File localFile = new File(DirectorySettings.getTmpDirectory(), localName);
        fos = new FileOutputStream(localFile);
        int count = 0;
        while ((oneChar = is.read()) != -1) {
            fos.write(oneChar);
            ++count;
        }
        is.close();
        fos.close();
        this.loadProjectFromFile(localFile);
    }

    public void setProjectFromGenome(Genome genome, URI[] trackURIs) throws Exception {
        if (this.promptToSaveChanges(false)) {
            this.projectSaved = false;
            this.currentProjectFile = null;
            this.fireEvent(new ProjectEvent(ProjectEvent.Type.LOADING, this.getCurrentFile()));
            this.clearExistingProject();
            Project proj = new Project(genome, trackURIs);
            this.pendingTracks = proj.getInitialTracks();
            proj.load();
        }
    }
}

