/*
 * Decompiled with CFR 0.152.
 */
package savant.controller;

import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.event.DockableFrameAdapter;
import com.jidesoft.docking.event.DockableFrameEvent;
import com.jidesoft.docking.event.DockableFrameListener;
import java.awt.Component;
import java.beans.PropertyVetoException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.savant.analytics.savantanalytics.AnalyticsAgent;
import savant.api.data.DataFormat;
import savant.api.event.LocationChangedEvent;
import savant.api.util.DialogUtils;
import savant.api.util.Listener;
import savant.controller.GraphPaneController;
import savant.controller.LocationController;
import savant.controller.TrackController;
import savant.selection.SelectionController;
import savant.util.DrawingMode;
import savant.util.NetworkUtils;
import savant.view.swing.DockableFrameFactory;
import savant.view.swing.Frame;
import savant.view.swing.Savant;
import savant.view.tracks.Track;
import savant.view.tracks.TrackFactory;

public class FrameController {
    private static final Log LOG = LogFactory.getLog(FrameController.class);
    private static FrameController instance;
    private static LocationController locationController;
    List<Frame> frames = new ArrayList<Frame>();

    public static synchronized FrameController getInstance() {
        if (instance == null) {
            instance = new FrameController();
        }
        return instance;
    }

    private FrameController() {
        locationController.addListener(new Listener<LocationChangedEvent>(){

            @Override
            public void handleEvent(LocationChangedEvent event) {
                FrameController.this.drawFrames();
            }
        });
        Savant.getInstance().getTrackDockingManager().addDockableFrameListener((DockableFrameListener)new TrackFrameAdapter());
        Savant.getInstance().getAuxDockingManager().addDockableFrameListener((DockableFrameListener)new TrackFrameAdapter());
    }

    public void closeAllFrames(boolean askFirst) {
        if (askFirst && DialogUtils.askYesNo("Confirm", "Are you sure you want to close all tracks?") == 1) {
            return;
        }
        for (int i = this.frames.size() - 1; i >= 0; --i) {
            this.closeFrame(this.frames.get(i), false);
        }
    }

    public void closeFrame(Frame frame, boolean askFirst) {
        if (!frame.isCloseable()) {
            return;
        }
        if (askFirst && DialogUtils.askYesNo("Confirm", "Are you sure you want to close this track?") == 1) {
            return;
        }
        frame.getDockingManager().removeFrame(frame.getName());
        try {
            for (Track t : frame.getTracks()) {
                AnalyticsAgent.log((NameValuePair[])new NameValuePair[]{new NameValuePair("track-event", "closed"), new NameValuePair("track-type", t.getClass().getSimpleName())});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Frame createFrame(Track[] tracks) {
        DataFormat df = tracks[0].getDataFormat();
        Frame frame = DockableFrameFactory.createTrackFrame(df);
        frame.setKey(tracks[0].getName());
        this.addFrame(frame, df);
        frame.setTracks(tracks);
        return frame;
    }

    public Frame addTrackFromPath(String fileOrURI, DataFormat df, DrawingMode dm) {
        if (df == null) {
            if (fileOrURI.endsWith(".fa") || fileOrURI.endsWith(".fa.savant")) {
                df = DataFormat.SEQUENCE;
            } else if (fileOrURI.endsWith(".vcf.gz")) {
                df = DataFormat.VARIANT;
            }
        }
        return this.addTrackFromURI(NetworkUtils.getURIFromPath(fileOrURI), df, dm);
    }

    public Frame addTrackFromURI(URI uri, DataFormat df, DrawingMode dm) {
        Frame frame = DockableFrameFactory.createTrackFrame(df);
        frame.setKey(uri.toString() + System.nanoTime());
        frame.setInitialDrawingMode(dm);
        this.addFrame(frame, df);
        TrackFactory.createTrack(uri, frame);
        return frame;
    }

    private void addFrame(Frame f, DataFormat df) {
        this.frames.add(f);
        DockingManager dm = Savant.getInstance().getTrackDockingManager();
        dm.addFrame((DockableFrame)f);
        if (this.frames.size() > 1) {
            DockingManager.FrameHandle lastFrame = this.getFrontmostFrame(dm);
            dm.moveFrame(f.getKey(), lastFrame.getKey(), 2);
        }
    }

    private DockingManager.FrameHandle getFrontmostFrame(DockingManager dm) {
        for (DockingManager.FrameHandle h : dm.getOrderedFrames()) {
            if (h.getKey().startsWith("#")) continue;
            return h;
        }
        return null;
    }

    public Frame getActiveFrame() {
        DockingManager dm = Savant.getInstance().getTrackDockingManager();
        DockingManager.FrameHandle fh = this.getFrontmostFrame(dm);
        return fh != null ? (Frame)dm.getFrame(fh.getKey()) : null;
    }

    public void drawFrames() {
        GraphPaneController.getInstance().clearRenderingList();
        for (Frame f : this.frames) {
            if (f.getTracks() == null) continue;
            GraphPaneController.getInstance().enlistRenderingGraphpane(f.getGraphPane());
            f.drawTracksInRange(locationController.getReferenceName(), locationController.getRange());
        }
    }

    public void hideFrame(Frame frame) {
        try {
            frame.setHidden(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void showFrame(Frame frame) {
        try {
            frame.setHidden(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public List<Frame> getFrames() {
        return this.frames;
    }

    public Frame[] getOrderedFrames() {
        Frame[] result = this.frames.toArray(new Frame[0]);
        Arrays.sort(result, new Comparator<Component>(){

            @Override
            public int compare(Component t, Component t1) {
                if (t == null) {
                    return t1 == null ? 0 : 1;
                }
                if (t1 == null) {
                    return -1;
                }
                int result = t.getY() - t1.getY();
                if (result == 0) {
                    result = t.getX() - t1.getX();
                }
                if (result == 0) {
                    result = this.compare(t.getParent(), t1.getParent());
                }
                return result;
            }
        });
        return result;
    }

    static {
        locationController = LocationController.getInstance();
    }

    private class TrackFrameAdapter
    extends DockableFrameAdapter {
        private TrackFrameAdapter() {
        }

        public void dockableFrameAdded(DockableFrameEvent evt) {
            if (evt.getDockableFrame() instanceof Frame) {
                Savant.getInstance().showBrowserControls();
            }
        }

        public void dockableFrameRemoved(DockableFrameEvent evt) {
            DockableFrame df = evt.getDockableFrame();
            if (df instanceof Frame) {
                Frame f = (Frame)df;
                FrameController.this.hideFrame(f);
                try {
                    TrackController vtc = TrackController.getInstance();
                    SelectionController sc = SelectionController.getInstance();
                    LOG.info((Object)("Closing " + f + " with " + f.getTracks().length + " tracks."));
                    for (Track t : f.getTracks()) {
                        vtc.removeTrack(t);
                        sc.removeAll(t.getName());
                    }
                    FrameController.this.frames.remove(f);
                }
                catch (Throwable x) {
                    LOG.error((Object)"Error closing frame.", x);
                }
            }
        }

        public void dockableFrameActivated(DockableFrameEvent evt) {
            DockableFrame df = evt.getDockableFrame();
            if (df instanceof Frame) {
                ((Frame)df).setActiveFrame(true);
            }
        }

        public void dockableFrameDeactivated(DockableFrameEvent evt) {
            DockableFrame df = evt.getDockableFrame();
            if (df instanceof Frame) {
                ((Frame)df).setActiveFrame(false);
            }
        }
    }
}

