/*
 * Decompiled with CFR 0.152.
 */
package savant.controller;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.api.event.BookmarksChangedEvent;
import savant.controller.LocationController;
import savant.util.Bookmark;
import savant.util.Controller;
import savant.util.Range;

public class BookmarkController
extends Controller<BookmarksChangedEvent> {
    private static final Log LOG = LogFactory.getLog(LocationController.class);
    private static BookmarkController instance;
    private List<Bookmark> bookmarks = new ArrayList<Bookmark>();

    public static synchronized BookmarkController getInstance() {
        if (instance == null) {
            instance = new BookmarkController();
        }
        return instance;
    }

    private BookmarkController() {
    }

    public List<Bookmark> getBookmarks() {
        return this.bookmarks;
    }

    public void addBookmark(Bookmark f) {
        this.addBookmark(f, true);
    }

    public void addBookmark(Bookmark f, boolean fireEvent) {
        if (this.bookmarks == null || this.bookmarks.isEmpty()) {
            this.bookmarks = new ArrayList<Bookmark>();
        }
        this.bookmarks.add(f);
        if (fireEvent) {
            this.fireEvent(new BookmarksChangedEvent(f, true));
        }
    }

    public void addBookmarks(List<Bookmark> bkmks) {
        for (Bookmark b : bkmks) {
            this.addBookmark(b, false);
        }
        this.fireEvent(new BookmarksChangedEvent(bkmks.get(bkmks.size() - 1), true));
    }

    private static Bookmark parseBookmark(String line, boolean addMargin) {
        StringTokenizer st = new StringTokenizer(line, "\t");
        String ref = st.nextToken();
        int from = Integer.parseInt(st.nextToken());
        int to = Integer.parseInt(st.nextToken());
        String annotation = "";
        if (st.hasMoreElements()) {
            annotation = st.nextToken();
            annotation.trim();
        }
        return new Bookmark(ref, new Range(from, to), annotation, addMargin);
    }

    public void addBookmarksFromFile(File f, boolean addMargin) throws FileNotFoundException, IOException {
        BufferedReader br = new BufferedReader(new FileReader(f));
        String line = "";
        ArrayList<Bookmark> newBookmarks = new ArrayList<Bookmark>();
        while ((line = br.readLine()) != null) {
            newBookmarks.add(BookmarkController.parseBookmark(line, addMargin));
        }
        this.addBookmarks(newBookmarks);
        br.close();
    }

    public void removeBookmark() {
        this.removeBookmark(this.bookmarks.size() - 1);
    }

    public void removeBookmark(int index) {
        try {
            LOG.info((Object)"Bookmark removed.");
            Bookmark b = this.bookmarks.get(index);
            this.bookmarks.remove(index);
            this.fireEvent(new BookmarksChangedEvent(b, false));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addCurrentRangeToBookmarks() {
        LocationController lc = LocationController.getInstance();
        if (lc.getRange() != null) {
            this.addBookmark(new Bookmark(lc.getReferenceName(), lc.getRange()));
        }
    }

    public Bookmark getBookmark(int index) {
        return this.bookmarks.get(index);
    }

    public void clearBookmarks() {
        this.bookmarks.clear();
    }
}

