/*
 * Decompiled with CFR 0.152.
 */
package savant.api.util;

import java.io.File;
import savant.api.adapter.GenomeAdapter;
import savant.api.adapter.TrackAdapter;
import savant.api.event.GenomeChangedEvent;
import savant.api.util.Listener;
import savant.api.util.TrackUtils;
import savant.controller.GenomeController;
import savant.data.types.Genome;
import savant.view.tracks.Track;

public class GenomeUtils {
    private static GenomeController genomeController = GenomeController.getInstance();

    public static boolean isGenomeLoaded() {
        return genomeController.isGenomeLoaded();
    }

    public static GenomeAdapter getGenome() {
        return genomeController.getGenome();
    }

    public static void setGenome(GenomeAdapter genome) {
        genomeController.setGenome((Genome)genome);
    }

    public static GenomeAdapter createGenome(String name, int length) {
        return new Genome(name, length);
    }

    public static GenomeAdapter createGenome(TrackAdapter seqTrack) {
        return Genome.createFromTrack((Track)seqTrack);
    }

    public static GenomeAdapter createGenome(File f) throws Throwable {
        return GenomeUtils.createGenome(TrackUtils.createTrack(f)[0]);
    }

    public static void addGenomeChangedListener(Listener<GenomeChangedEvent> l) {
        genomeController.addListener(l);
    }

    public static void removeGenomeChangedListener(Listener<GenomeChangedEvent> l) {
        genomeController.removeListener(l);
    }
}

