/*
 * Decompiled with CFR 0.152.
 */
package savant.api.util;

import com.jidesoft.dialog.JideOptionPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import savant.util.MiscUtils;
import savant.util.error.report.BugReportDialog;
import savant.util.swing.ProgressDialog;
import savant.view.swing.Savant;

public class DialogUtils {
    public static final int YES = 0;
    public static final int OK = 0;
    public static final int NO = 1;
    public static final int CANCEL = 2;

    public static int askYesNo(String title, String prompt) {
        return JOptionPane.showConfirmDialog(DialogUtils.getMainWindow(), prompt, title, 0, 3);
    }

    public static int askYesNo(String prompt) {
        return DialogUtils.askYesNo("Savant", prompt);
    }

    public static int askYesNoCancel(String prompt) {
        return JOptionPane.showConfirmDialog(DialogUtils.getMainWindow(), prompt, "Savant", 1, 3);
    }

    public static void displayError(String title, String message) {
        JOptionPane.showMessageDialog(DialogUtils.getMainWindow(), message, title, 0);
    }

    public static void displayError(String message) {
        DialogUtils.displayError("Savant Error", message);
    }

    public static String displayInputMessage(String title, String message, String defaultInput) {
        String result = JOptionPane.showInputDialog(DialogUtils.getMainWindow(), message, "Savant", 3);
        if (result != null && result.length() > 0) {
            return result;
        }
        return null;
    }

    public static void displayMessage(String title, String message) {
        JOptionPane.showMessageDialog(DialogUtils.getMainWindow(), message, title, -1);
    }

    public static void displayMessage(String message) {
        DialogUtils.displayMessage("Savant", message);
    }

    public static void displayException(final String title, final String message, final Throwable t) {
        MiscUtils.invokeLaterIfNecessary(new Runnable(){

            @Override
            public void run() {
                String msg = message;
                if (t.getCause() != null) {
                    msg = msg + "\r\nCause: " + MiscUtils.getMessage(t.getCause()) + ".";
                }
                JideOptionPane optionPane = new JideOptionPane((Object)msg, 0, 3);
                optionPane.setTitle((Object)title);
                optionPane.setOptions((Object[])new String[0]);
                JButton reportButton = new JButton("Report Issue");
                ((JComponent)optionPane.getComponent(optionPane.getComponentCount() - 1)).add(reportButton);
                final JDialog dialog = optionPane.createDialog((Component)DialogUtils.getMainWindow(), "Error encountered");
                dialog.setResizable(true);
                String details = t.getMessage() + "\r\n" + MiscUtils.getStackTrace(t);
                optionPane.setDetails((Object)details);
                dialog.pack();
                reportButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e2) {
                        String issue = "Hey Savant Developers,\n\n";
                        issue = issue + "I am encountering an error in Savant. I have provided additional diagnostic information below.\n\n";
                        issue = issue + "=== DESCRIBE THE ISSUE BELOW ===\n\n\n";
                        issue = issue + "=== ERROR DETAILS ===\n";
                        issue = issue + MiscUtils.getStackTrace(t);
                        dialog.dispose();
                        new BugReportDialog((Frame)Savant.getInstance(), issue).setVisible(true);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public static File chooseFileForOpen(String title, FileFilter filter, File initialDir) {
        if (MiscUtils.MAC) {
            FileDialog fd = DialogUtils.getFileDialog(title, 0);
            if (filter != null) {
                fd.setFilenameFilter(new FilenameFilterAdapter(filter));
            }
            if (initialDir != null) {
                fd.setDirectory(initialDir.getAbsolutePath());
            }
            fd.setVisible(true);
            fd.setAlwaysOnTop(true);
            String selectedFileName = fd.getFile();
            if (selectedFileName != null) {
                return new File(fd.getDirectory(), selectedFileName);
            }
        } else {
            int result;
            JFileChooser fd = new JFileChooser();
            fd.setDialogTitle(title);
            fd.setDialogType(0);
            if (filter != null) {
                fd.setFileFilter(filter);
            }
            if (initialDir != null) {
                fd.setCurrentDirectory(initialDir);
            }
            if ((result = fd.showOpenDialog(DialogUtils.getMainWindow())) == 0) {
                return fd.getSelectedFile();
            }
        }
        return null;
    }

    public static File[] chooseFilesForOpen(String title, FileFilter filter, File initialDir) {
        if (MiscUtils.MAC) {
            File f = DialogUtils.chooseFileForOpen(title, filter, initialDir);
            if (f != null) {
                return new File[]{f};
            }
        } else {
            JFileChooser fd = new JFileChooser();
            fd.setDialogTitle(title);
            fd.setSelectedFile(initialDir);
            fd.setDialogType(0);
            if (filter != null) {
                fd.setFileFilter(filter);
            }
            fd.setMultiSelectionEnabled(true);
            int result = fd.showOpenDialog(DialogUtils.getMainWindow());
            if (result == 0) {
                return fd.getSelectedFiles();
            }
        }
        return new File[0];
    }

    public static File chooseFileForSave(String title, String defaultName) {
        return DialogUtils.chooseFileForSave(title, defaultName, null, null);
    }

    public static File chooseFileForSave(String title, String defaultName, FileFilter filter, File initialDir) {
        FileDialog fd = DialogUtils.getFileDialog(title, 1);
        if (filter != null) {
            fd.setFilenameFilter(new FilenameFilterAdapter(filter));
        }
        if (initialDir != null) {
            fd.setDirectory(initialDir.getAbsolutePath());
        }
        fd.setFile(defaultName);
        fd.setAlwaysOnTop(true);
        fd.setVisible(true);
        String selectedFile = fd.getFile();
        if (selectedFile != null) {
            return new File(fd.getDirectory(), selectedFile);
        }
        return null;
    }

    public static Window getMainWindow() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
    }

    private static FileDialog getFileDialog(String title, int type) {
        Window w = DialogUtils.getMainWindow();
        if (w instanceof Frame) {
            return new FileDialog((Frame)w, title, type);
        }
        return new FileDialog((Dialog)w, title, type);
    }

    public static void showProgress(String message, double fraction) {
        ProgressDialog.showProgress(message, fraction);
    }

    static class FilenameFilterAdapter
    implements FilenameFilter {
        FileFilter filter;

        FilenameFilterAdapter(FileFilter f) {
            this.filter = f;
        }

        @Override
        public boolean accept(File dir, String name) {
            return this.filter.accept(new File(dir, name));
        }
    }
}

