/*
 * Decompiled with CFR 0.152.
 */
package savant.api.data;

import java.io.UnsupportedEncodingException;
import savant.api.data.Record;

public class SequenceRecord
implements Record {
    private final String reference;
    private final byte[] sequence;

    protected SequenceRecord(String reference, byte[] sequence) {
        if (reference == null) {
            throw new IllegalArgumentException("Invalid argument; reference may not be null.");
        }
        if (sequence == null) {
            throw new IllegalArgumentException("Invalud argument; sequence may not be null.");
        }
        this.reference = reference;
        this.sequence = sequence;
    }

    public static SequenceRecord valueOf(String reference, byte[] sequence) {
        return new SequenceRecord(reference, sequence);
    }

    public byte[] getSequence() {
        return this.sequence;
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    public int compareTo(Object o) {
        if (this == o) {
            return 0;
        }
        SequenceRecord that = (SequenceRecord)o;
        int result = this.reference.compareTo(that.reference);
        if (result == 0) {
            int thisLen = this.sequence.length;
            int thatLen = that.sequence.length;
            int i = 0;
            while (true) {
                int a = 0;
                int b = 0;
                if (i < thisLen) {
                    a = this.sequence[i] & 0xFF;
                } else if (i >= thatLen) {
                    return 0;
                }
                if (i < thisLen) {
                    b = that.sequence[i] & 0xFF;
                }
                if (a > b) {
                    return 1;
                }
                if (b > a) {
                    return -1;
                }
                ++i;
            }
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SequenceRecord that = (SequenceRecord)o;
        return this.compareTo(that) == 0;
    }

    public int hashCode() {
        int result = this.reference.hashCode();
        result = 31 * result + this.sequence.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SequenceRecord");
        sb.append("{reference='").append(this.reference).append("', sequence='");
        try {
            sb.append(new String(this.sequence, "ISO-8859-1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        sb.append("'}");
        return sb.toString();
    }
}

