/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.log4j.Logger;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.StringUtils;
import org.broad.tribble.readers.AsciiLineReader;

public class ParsingUtils {
    private static Logger log = Logger.getLogger(ParsingUtils.class);

    public static BufferedReader openBufferedReader(String pathOrUrl) throws IOException {
        BufferedReader reader;
        if (HttpUtils.isURL(pathOrUrl)) {
            URL url = new URL(pathOrUrl);
            reader = new BufferedReader(new InputStreamReader(HttpUtils.getInstance().openConnectionStream(url)));
        } else {
            File file = new File(pathOrUrl);
            FileInputStream fileInput = new FileInputStream(file);
            if (file.getName().endsWith("gz")) {
                GZIPInputStream in = new GZIPInputStream(fileInput);
                reader = new BufferedReader(new InputStreamReader(in));
            } else {
                reader = new BufferedReader(new InputStreamReader(fileInput));
            }
        }
        return reader;
    }

    public static int estimateLineCount(File file) {
        if (file.isDirectory()) {
            int lineCount = 0;
            for (File f : file.listFiles()) {
                if (f.isDirectory()) continue;
                lineCount += ParsingUtils.estimateLineCount(f.getAbsolutePath());
            }
            return lineCount;
        }
        return ParsingUtils.estimateLineCount(file.getAbsolutePath());
    }

    public static long getContentLength(String path) {
        try {
            long contentLength = -1L;
            if (path.startsWith("http:") || path.startsWith("https:")) {
                URL url = new URL(path);
                contentLength = HttpUtils.getInstance().getContentLength(url);
            } else if (path.startsWith("ftp:")) {
                URL url = new URL(path);
                contentLength = url.openConnection().getContentLength();
            } else {
                contentLength = new File(path).length();
            }
            return contentLength;
        }
        catch (IOException e) {
            log.error((Object)("Error getting content length for: " + path), (Throwable)e);
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int estimateLineCount(String path) {
        AsciiLineReader reader = null;
        try {
            int nLines;
            String nextLine;
            int defaultLength = 100000;
            long fileLength = ParsingUtils.getContentLength(path);
            if (fileLength <= 0L) {
                int n = 100000;
                return n;
            }
            reader = ParsingUtils.openAsciiReader(new ResourceLocator(path));
            int lines = 0;
            int nSkip = 10;
            while (nSkip-- > 0 && reader.readLine() != null) {
            }
            long startPos = reader.getPosition();
            while ((nextLine = reader.readLine()) != null & lines < 100) {
                ++lines;
            }
            if (lines == 0) {
                int n = 100000;
                return n;
            }
            double bytesPerLine = (reader.getPosition() - startPos) / (long)lines;
            int n = nLines = (int)((double)fileLength / bytesPerLine);
            return n;
        }
        catch (Exception e) {
            log.error((Object)"Error estimating line count", (Throwable)e);
            int n = 1000;
            return n;
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception e) {}
        }
    }

    public static AsciiLineReader openAsciiReader(ResourceLocator locator) throws IOException {
        InputStream stream = ParsingUtils.openInputStream(locator);
        return new AsciiLineReader(stream);
    }

    public static InputStream openInputStream(ResourceLocator locator) throws IOException {
        InputStream inputStream = null;
        HttpUtils.getInstance();
        if (HttpUtils.isURL(locator.getPath())) {
            URL url = new URL(locator.getPath());
            inputStream = HttpUtils.getInstance().openConnectionStream(url);
        } else {
            String path = locator.getPath();
            if (path.startsWith("file://")) {
                path = path.substring(7);
            }
            File file = new File(path);
            inputStream = new FileInputStream(file);
        }
        if (locator.getPath().endsWith("gz")) {
            return new GZIPInputStream(inputStream);
        }
        return inputStream;
    }

    public static int split(String aString, String[] tokens, char delim) {
        int maxTokens = tokens.length;
        int nTokens = 0;
        int start = 0;
        int end = aString.indexOf(delim);
        if (end == 0) {
            if (aString.length() > 1) {
                start = 1;
                end = aString.indexOf(delim, start);
            } else {
                return 0;
            }
        }
        if (end < 0) {
            tokens[nTokens++] = aString;
            return nTokens;
        }
        while (end > 0 && nTokens < maxTokens) {
            tokens[nTokens++] = aString.substring(start, end);
            start = end + 1;
            end = aString.indexOf(delim, start);
        }
        if (nTokens < maxTokens) {
            String trailingString = aString.substring(start);
            tokens[nTokens++] = trailingString;
        }
        return nTokens;
    }

    public static int splitSpaces(String aString, String[] tokens) {
        String trailingString;
        aString = aString.trim();
        int maxTokens = tokens.length;
        int nTokens = 0;
        int start = 0;
        int end = aString.indexOf(32);
        if (end < 0) {
            tokens[nTokens++] = aString;
            return nTokens;
        }
        while (end > 0 && nTokens < maxTokens) {
            String t = aString.substring(start, end);
            if (t.length() > 0) {
                tokens[nTokens++] = t;
            }
            start = end + 1;
            end = aString.indexOf(32, start);
        }
        if (nTokens < maxTokens && (trailingString = aString.substring(start)).length() > 0) {
            tokens[nTokens++] = trailingString;
        }
        return nTokens;
    }

    public static int splitWhitespace(String aString, String[] tokens) {
        int end;
        int maxTokens = tokens.length;
        int nTokens = 0;
        int start = 0;
        int tabEnd = aString.indexOf(9);
        int spaceEnd = aString.indexOf(32);
        int n = tabEnd < 0 ? spaceEnd : (end = spaceEnd < 0 ? tabEnd : Math.min(spaceEnd, tabEnd));
        while (end > 0 && nTokens < maxTokens) {
            tokens[nTokens++] = aString.substring(start, end);
            for (start = end + 1; start < aString.length() && aString.charAt(start) == ' '; ++start) {
            }
            tabEnd = aString.indexOf(9, start);
            spaceEnd = aString.indexOf(32, start);
            end = tabEnd < 0 ? spaceEnd : (spaceEnd < 0 ? tabEnd : Math.min(spaceEnd, tabEnd));
        }
        if (nTokens < maxTokens) {
            String trailingString = aString.substring(start).trim();
            tokens[nTokens++] = trailingString;
        }
        return nTokens;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replaceString(String str, String rplString, File ifile, File ofile) throws IOException {
        PrintWriter pw = null;
        BufferedReader br = null;
        try {
            pw = new PrintWriter(new BufferedWriter(new FileWriter(ofile)));
            br = new BufferedReader(new FileReader(ifile));
            String nextLine = null;
            while ((nextLine = br.readLine()) != null) {
                if (nextLine.startsWith("##")) continue;
                pw.println(nextLine.replace(str, rplString));
            }
        }
        finally {
            pw.close();
            br.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropLinesContaining(String str, File ifile, File ofile) throws IOException {
        PrintWriter pw = null;
        BufferedReader br = null;
        try {
            pw = new PrintWriter(new BufferedWriter(new FileWriter(ofile)));
            br = new BufferedReader(new FileReader(ifile));
            String nextLine = null;
            while ((nextLine = br.readLine()) != null) {
                if (nextLine.contains(str)) continue;
                pw.println(nextLine);
            }
        }
        finally {
            pw.close();
            br.close();
        }
    }

    public static List<String> loadRegions(File file) {
        try {
            String nextLine;
            FileInputStream fileInput = new FileInputStream(file);
            BufferedReader reader = new BufferedReader(new InputStreamReader(fileInput));
            ArrayList<String> features = new ArrayList<String>();
            while ((nextLine = reader.readLine()) != null && nextLine.trim().length() > 0) {
                try {
                    if (!nextLine.startsWith("chr")) continue;
                    String[] tokens = nextLine.split("\t");
                    String region = tokens[0] + ":" + tokens[1] + "-" + tokens[2];
                    features.add(region);
                }
                catch (NumberFormatException e) {
                    log.error((Object)("Error parsing numer in line: " + nextLine));
                }
            }
            reader.close();
            return features;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean parseTrackLine(String nextLine, TrackProperties trackProperties) throws NumberFormatException {
        boolean foundProperties = false;
        List<String> tokens = StringUtils.breakQuotedString(nextLine, ' ');
        for (String pair : tokens) {
            List<String> kv = StringUtils.breakQuotedString(pair, '=');
            if (kv.size() != 2) continue;
            foundProperties = true;
            String key = kv.get(0).toLowerCase().trim();
            String value = kv.get(1).replaceAll("\"", "");
            if (key.equals("coords")) {
                if (value.equals("0")) {
                    trackProperties.setBaseCoord(TrackProperties.BaseCoord.ZERO);
                } else if (value.equals("1")) {
                    trackProperties.setBaseCoord(TrackProperties.BaseCoord.ONE);
                }
            }
            if (key.equals("name")) {
                trackProperties.setName(value);
                continue;
            }
            if (key.equals("description")) {
                trackProperties.setDescription(value);
                continue;
            }
            if (key.equals("itemrgb")) {
                trackProperties.setItemRGB(value.toLowerCase().equals("on") || value.equals("1"));
                continue;
            }
            if (key.equals("usescore")) {
                trackProperties.setUseScore(value.equals("1"));
                continue;
            }
            if (key.equals("autoscale")) {
                boolean autoscale = value.equals("on");
                trackProperties.setAutoScale(autoscale);
                continue;
            }
            if (key.equals("maxheightpixels")) {
                String[] maxDefMin = value.split(":");
                if (maxDefMin.length < 2) continue;
                int defIDX = maxDefMin.length == 2 ? 0 : 1;
                trackProperties.setHeight(Integer.parseInt(maxDefMin[defIDX].trim()));
                trackProperties.setMinHeight(Integer.parseInt(maxDefMin[defIDX + 1].trim()));
                continue;
            }
            if (key.equals("url")) {
                trackProperties.setUrl(value);
                continue;
            }
            if (key.toLowerCase().equals("viewlimits")) {
                String[] limits = value.split(":");
                if (limits.length != 2) continue;
                try {
                    float min = Float.parseFloat(limits[0].trim());
                    float max = Float.parseFloat(limits[1].trim());
                    trackProperties.setMinValue(min);
                    trackProperties.setMaxValue(max);
                }
                catch (NumberFormatException e) {
                    log.error((Object)("viewLimits values must be numeric: " + value));
                }
                continue;
            }
            if (key.equals("midrange")) {
                String[] limits = value.split(":");
                if (limits.length != 2) continue;
                try {
                    float from = Float.parseFloat(limits[0].trim());
                    float to = Float.parseFloat(limits[1].trim());
                    trackProperties.setNeutralFromValue(from);
                    trackProperties.setNeutralToValue(to);
                }
                catch (NumberFormatException e) {
                    log.error((Object)("midrange values must be numeric: " + value));
                }
                continue;
            }
            if (key.equals("ylinemark")) {
                try {
                    float yLine = Float.parseFloat(value);
                    trackProperties.setyLine(yLine);
                }
                catch (NumberFormatException e) {
                    log.error((Object)("Number format exception in track line (ylinemark): " + nextLine));
                }
                continue;
            }
            if (key.equals("ylineonoff")) {
                trackProperties.setDrawYLine(value.equals("on"));
                continue;
            }
            if (key.equals("windowingfunction")) {
                if (value.equals("maximum")) {
                    trackProperties.setWindowingFunction(WindowFunction.max);
                    continue;
                }
                if (value.equals("minimum")) {
                    trackProperties.setWindowingFunction(WindowFunction.min);
                    continue;
                }
                if (value.equals("mean")) {
                    trackProperties.setWindowingFunction(WindowFunction.mean);
                    continue;
                }
                if (value.equals("median")) {
                    trackProperties.setWindowingFunction(WindowFunction.median);
                    continue;
                }
                if (value.equals("percentile10")) {
                    trackProperties.setWindowingFunction(WindowFunction.percentile10);
                    continue;
                }
                if (value.equals("percentile90")) {
                    trackProperties.setWindowingFunction(WindowFunction.percentile90);
                    continue;
                }
                if (!value.equals("none")) continue;
                trackProperties.setWindowingFunction(WindowFunction.none);
                continue;
            }
            if (key.equals("maxfeaturewindow") || key.equals("featurevisibilitywindow") || key.equals("visibilitywindow")) {
                try {
                    int windowSize = Integer.parseInt(value);
                    trackProperties.setFeatureVisibilityWindow(windowSize);
                }
                catch (NumberFormatException e) {
                    log.error((Object)(key + " must be numeric: " + nextLine));
                }
                continue;
            }
            if (key.equals("scaletype")) {
                if (!value.equals("log")) continue;
                trackProperties.setLogScale(true);
                continue;
            }
            if (key.equals("gfftags")) {
                boolean gffTags = !value.equals("0") && !value.toLowerCase().equals("off");
                trackProperties.setGffTags(gffTags);
                continue;
            }
            if (key.equals("sortable")) {
                boolean sortable = value.equals("1") || value.toLowerCase().equals("true");
                trackProperties.setSortable(sortable);
                continue;
            }
            if (!key.equals("alternateexoncolor")) continue;
            trackProperties.setAlternateExonColor(value.toLowerCase().equals("on") || value.equals("1"));
        }
        return foundProperties;
    }
}

