/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.log4j.Logger;

public class HttpUtils {
    private static Logger log = Logger.getLogger(HttpUtils.class);
    public static boolean byteRangeTested = false;
    public static boolean byteRangeTestSuccess = false;
    private static HttpUtils instance;
    private final int MAX_REDIRECTS = 5;

    public static HttpUtils getInstance() {
        return instance;
    }

    private HttpUtils() {
    }

    public static boolean isURL(String string) {
        String lcString = string.toLowerCase();
        return lcString.startsWith("http://") || lcString.startsWith("https://") || lcString.startsWith("ftp://") || lcString.startsWith("file://");
    }

    public void shutdown() {
    }

    public InputStream openConnectionStream(URL url) throws IOException {
        if (url.getProtocol().toLowerCase().equals("ftp")) {
            return HttpUtils.openFtpStream(url);
        }
        return this.openConnection(url, null).getInputStream();
    }

    public InputStream openConnectionStream(URL url, Map<String, String> requestProperties) throws IOException {
        HttpURLConnection conn = this.openConnection(url, requestProperties);
        return conn.getInputStream();
    }

    private static InputStream openFtpStream(URL url) throws IOException {
        String host = url.getHost();
        FTPClient ftp = new FTPClient();
        ftp.connect(host);
        System.out.println(ftp.getReplyString());
        int reply = ftp.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)reply)) {
            ftp.disconnect();
            System.err.println("FTP server refused connection.");
            throw new RuntimeException("FTP server refused connection.");
        }
        boolean success = ftp.login("anonymous", "igv-team@broadinstitute.org");
        if (!success) {
            System.err.println("FTP login failed " + ftp.getReplyString());
            throw new RuntimeException("FTP login failed " + ftp.getReplyString());
        }
        ftp.enterLocalPassiveMode();
        String file = url.getPath();
        System.out.println("Open file: " + file);
        return ftp.retrieveFileStream(file);
    }

    public String getHeaderField(URL url, String key) throws IOException {
        HttpURLConnection conn = this.openConnection(url, null, "HEAD");
        int code = conn.getResponseCode();
        return conn.getHeaderField(key);
    }

    public long getContentLength(URL url) throws IOException {
        String contentLengthString = "";
        contentLengthString = this.getHeaderField(url, "Content-Length");
        if (contentLengthString == null) {
            return -1L;
        }
        return Long.parseLong(contentLengthString);
    }

    private String readContents(InputStream is) throws IOException {
        int b;
        BufferedInputStream bis = new BufferedInputStream(is);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((b = bis.read()) >= 0) {
            bos.write(b);
        }
        return new String(bos.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readErrorStream(HttpURLConnection connection) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = connection.getErrorStream();
            String string = this.readContents(inputStream);
            return string;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private HttpURLConnection openConnection(URL url, Map<String, String> requestProperties) throws IOException {
        return this.openConnection(url, requestProperties, "GET");
    }

    private HttpURLConnection openConnection(URL url, Map<String, String> requestProperties, String method) throws IOException {
        return this.openConnection(url, requestProperties, method, 0);
    }

    private synchronized HttpURLConnection openConnection(URL url, Map<String, String> requestProperties, String method, int redirectCount) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(300000);
        conn.setRequestMethod(method);
        conn.setRequestProperty("Connection", "close");
        if (requestProperties != null) {
            for (Map.Entry<String, String> prop : requestProperties.entrySet()) {
                conn.setRequestProperty(prop.getKey(), prop.getValue());
            }
        }
        if (method.equals("PUT")) {
            return conn;
        }
        int code = conn.getResponseCode();
        if (code >= 300 && code < 400) {
            if (redirectCount > 5) {
                throw new IOException("Too many redirects");
            }
            String newLocation = conn.getHeaderField("Location");
            log.debug((Object)("Redirecting to " + newLocation));
            return this.openConnection(new URL(newLocation), requestProperties, method, redirectCount++);
        }
        if (code >= 400) {
            String message;
            if (code == 404) {
                message = "File not found: " + url.toString();
                throw new FileNotFoundException(message);
            }
            message = conn.getResponseMessage();
            String details = this.readErrorStream(conn);
            throw new IOException("Server returned error code: " + code + " (" + message + ")");
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<HttpUtils> clazz = HttpUtils.class;
        synchronized (HttpUtils.class) {
            instance = new HttpUtils();
            CookieHandler.setDefault(new CookieManager());
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

