/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tdf;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.tdf.TDFGroup;
import org.broad.igv.tdf.TDFReader;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.util.LRUCache;

public class TDFDataSource {
    private static Logger log = Logger.getLogger(TDFDataSource.class);
    int maxPrecomputedZoom = 6;
    TDFReader reader;
    private int trackNumber = 0;
    String trackName;
    LRUCache<String, List<LocusScore>> summaryScoreCache = new LRUCache(this, 20);
    Genome genome;
    Interval currentInterval;
    WindowFunction windowFunction = WindowFunction.mean;
    List<WindowFunction> availableFunctions;
    private boolean aggregateLikeBins = true;
    boolean normalizeCounts = false;
    int totalCount = 0;
    float normalizationFactor = 1.0f;
    private Map<String, String> chrNameMap = new HashMap<String, String>();

    public TDFDataSource(TDFReader reader, int trackNumber, String trackName, Genome genome) {
        this.genome = genome;
        this.trackNumber = trackNumber;
        this.trackName = trackName;
        this.reader = reader;
        this.availableFunctions = reader.getWindowFunctions();
        TDFGroup rootGroup = reader.getGroup("/");
        try {
            this.maxPrecomputedZoom = Integer.parseInt(rootGroup.getAttribute("maxZoom"));
        }
        catch (Exception e) {
            log.error((Object)"Error reading attribute 'maxZoom'", (Throwable)e);
        }
        try {
            String dataGenome = rootGroup.getAttribute("genome");
        }
        catch (Exception e) {
            log.error((Object)("Unknown genome " + rootGroup.getAttribute("genome")));
            throw new RuntimeException("Unknown genome " + rootGroup.getAttribute("genome"));
        }
        try {
            String totalCountString = rootGroup.getAttribute("totalCount");
            if (totalCountString != null) {
                this.totalCount = Integer.parseInt(totalCountString);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error reading attribute 'totalCount'", (Throwable)e);
        }
        if (genome != null) {
            Set<String> chrNames = reader.getChromosomeNames();
            for (String chr : chrNames) {
                String igvChr = genome.getChromosomeAlias(chr);
                if (igvChr == null || igvChr.equals(chr)) continue;
                this.chrNameMap.put(igvChr, chr);
            }
        }
    }

    public void setNormalize(boolean normalizeCounts) {
        this.setNormalizeCounts(normalizeCounts, 1000000.0f);
    }

    public void setNormalizeCounts(boolean normalizeCounts, float scalingFactor) {
        this.normalizeCounts = normalizeCounts;
        this.normalizationFactor = normalizeCounts && this.totalCount > 0 ? scalingFactor / (float)this.totalCount : 1.0f;
    }

    public String getPath() {
        return this.reader == null ? null : this.reader.getPath();
    }

    public String getTrackName() {
        return this.trackName;
    }

    public double getDataMax() {
        return this.reader.getUpperLimit() * (double)this.normalizationFactor;
    }

    public double getDataMin() {
        return this.reader.getLowerLimit() * (double)this.normalizationFactor;
    }

    public void setAggregateLikeBins(boolean aggregateLikeBins) {
        this.aggregateLikeBins = aggregateLikeBins;
    }

    public TrackType getTrackType() {
        return this.reader.getTrackType();
    }

    public void setWindowFunction(WindowFunction wf) {
        this.windowFunction = wf;
    }

    public boolean isLogNormalized() {
        return this.getDataMin() < 0.0;
    }

    public void refreshData(long timestamp) {
    }

    public WindowFunction getWindowFunction() {
        return this.windowFunction;
    }

    public Collection<WindowFunction> getAvailableWindowFunctions() {
        return this.availableFunctions;
    }

    class Interval {
        String chr;
        private int start;
        private int end;
        private int zoom;
        private List<LocusScore> scores;

        public Interval(String chr, int start, int end, int zoom, List<LocusScore> scores) {
            this.chr = chr;
            this.start = start;
            this.end = end;
            this.zoom = zoom;
            this.scores = scores;
        }

        public boolean contains(String chr, int s, int e, int zoom) {
            return chr.equals(this.chr) && zoom == this.zoom && s >= this.getStart() && e <= this.getEnd();
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public List<LocusScore> getScores() {
            return this.scores;
        }
    }
}

