/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import java.io.File;
import java.io.IOException;
import net.sf.samtools.SAMFileReader;
import org.apache.log4j.Logger;
import org.broad.igv.sam.reader.AlignmentQueryReader;
import org.broad.igv.sam.reader.BAMQueryReader;
import org.broad.igv.util.ResourceLocator;

public class AlignmentReaderFactory {
    private static Logger log = Logger.getLogger(AlignmentReaderFactory.class);

    public static AlignmentQueryReader getReader(String path, boolean requireIndex) throws IOException {
        return AlignmentReaderFactory.getReader(new ResourceLocator(path), requireIndex);
    }

    public static AlignmentQueryReader getReader(ResourceLocator locator) throws IOException {
        return AlignmentReaderFactory.getReader(locator, true);
    }

    public static AlignmentQueryReader getReader(ResourceLocator locator, boolean requireIndex) throws IOException {
        String pathLowerCase = locator.getPath().toLowerCase();
        BAMQueryReader reader = null;
        String samFile = locator.getPath();
        if (!pathLowerCase.endsWith(".bam") || !locator.isLocal()) {
            throw new RuntimeException("Cannot find reader for aligment file: " + locator.getPath());
        }
        reader = new BAMQueryReader(new File(samFile));
        return reader;
    }

    static {
        SAMFileReader.setDefaultValidationStringency((SAMFileReader.ValidationStringency)SAMFileReader.ValidationStringency.SILENT);
    }
}

