/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broad.igv.feature.Chromosome;

public class Genome {
    private Map<String, String> chrAliasTable;
    private String id;
    private String formatVersion;
    private LinkedHashMap<String, Chromosome> chromosomeMap;
    private List<String> chromosomeNames;
    private long length = -1L;
    private Map<String, Long> cumulativeOffsets = new HashMap<String, Long>();
    public static final int MAX_WHOLE_GENOME = 10000;
    static Set<String> ucscGenomes = new HashSet<String>(Arrays.asList("hg16", "hg17", "hg18", "hg19", "mm7", "mm8", "mm9", "sacCer1", "sacCer2", "ce6", "canFam2", "monDom5"));

    public Genome(String id) {
        this.id = id;
        this.createAliasTable();
    }

    private void createAliasTable() {
        this.chrAliasTable = new HashMap<String, String>(100);
        if (this.id.startsWith("hg") || this.id.equalsIgnoreCase("1kg_ref")) {
            this.chrAliasTable.put("23", "chrX");
            this.chrAliasTable.put("24", "chrY");
            this.chrAliasTable.put("chr23", "chrX");
            this.chrAliasTable.put("chr24", "chrY");
            this.chrAliasTable.put("MT", "chrM");
        } else if (this.id.startsWith("mm")) {
            this.chrAliasTable.put("21", "chrX");
            this.chrAliasTable.put("22", "chrY");
            this.chrAliasTable.put("chr21", "chrX");
            this.chrAliasTable.put("chr22", "chrY");
            this.chrAliasTable.put("MT", "chrM");
        } else if (this.id.equals("b37")) {
            this.chrAliasTable.put("chrM", "MT");
            this.chrAliasTable.put("chrX", "23");
            this.chrAliasTable.put("chrY", "24");
        }
    }

    public String getChromosomeAlias(String str) {
        if (this.chrAliasTable == null) {
            return str;
        }
        if (this.chrAliasTable.containsKey(str)) {
            return this.chrAliasTable.get(str);
        }
        return str;
    }

    public void setChromosomeMap(LinkedHashMap<String, Chromosome> chromosomeMap, boolean chromosomesAreOrdered) {
        this.chromosomeMap = chromosomeMap;
        this.chromosomeNames = new LinkedList<String>(chromosomeMap.keySet());
        if (!chromosomesAreOrdered) {
            Collections.sort(this.chromosomeNames, new ChromosomeComparator());
        }
        if (this.chromosomeNames.size() < 1000) {
            if (this.chrAliasTable == null) {
                this.chrAliasTable = new HashMap<String, String>();
            }
            for (String name : this.chromosomeNames) {
                if (name.startsWith("chr") || name.startsWith("Chr")) {
                    this.chrAliasTable.put(name.substring(3), name);
                    continue;
                }
                this.chrAliasTable.put("chr" + name, name);
                this.chrAliasTable.put("Chr" + name, name);
            }
        }
    }

    public String getHomeChromosome() {
        if (this.getChromosomeNames().size() == 1 || this.chromosomeNames.size() > 10000) {
            return this.getChromosomeNames().get(0);
        }
        return "All";
    }

    public Chromosome getChromosome(String chrName) {
        Chromosome result = this.chromosomeMap.get(chrName);
        if (result == null) {
            result = this.chromosomeMap.get(this.chrAliasTable.get(chrName));
        }
        return result;
    }

    public List<String> getChromosomeNames() {
        return this.chromosomeNames;
    }

    public Collection<Chromosome> getChromosomes() {
        return this.chromosomeMap.values();
    }

    public long getLength() {
        if (this.length < 0L) {
            this.length = 0L;
            for (Chromosome chr : this.chromosomeMap.values()) {
                this.length += (long)chr.getLength();
            }
        }
        return this.length;
    }

    public long getCumulativeOffset(String chr) {
        Long cumOffset = this.cumulativeOffsets.get(chr);
        if (cumOffset == null) {
            long offset = 0L;
            for (String c : this.getChromosomeNames()) {
                if (chr.equals(c)) break;
                offset += (long)this.getChromosome(c).getLength();
            }
            cumOffset = new Long(offset);
            this.cumulativeOffsets.put(chr, cumOffset);
        }
        return cumOffset;
    }

    public int getGenomeCoordinate(String chr, int locationBP) {
        return (int)((this.getCumulativeOffset(chr) + (long)locationBP) / 1000L);
    }

    public ChromosomeCoordinate getChromosomeCoordinate(int genomeKBP) {
        long cumOffset = 0L;
        for (String c : this.chromosomeNames) {
            int chrLen = this.getChromosome(c).getLength();
            if ((cumOffset + (long)chrLen) / 1000L > (long)genomeKBP) {
                int bp = (int)((long)(genomeKBP * 1000) - cumOffset);
                return new ChromosomeCoordinate(c, bp);
            }
            cumOffset += (long)chrLen;
        }
        String c = this.chromosomeNames.get(this.chromosomeNames.size() - 1);
        int bp = (int)((long)genomeKBP - cumOffset) * 1000;
        return new ChromosomeCoordinate(c, bp);
    }

    public String getId() {
        return this.id;
    }

    public static class ChromosomeComparator
    implements Comparator<String> {
        @Override
        public int compare(String chr1, String chr2) {
            try {
                int idx2;
                if (chr1.equals("chrM") || chr1.equals("MT")) {
                    return 1;
                }
                if (chr2.equals("chrM") || chr2.equals("MT")) {
                    return -1;
                }
                int idx1 = this.findDigitIndex(chr1);
                if (idx1 == (idx2 = this.findDigitIndex(chr2))) {
                    String alpha2;
                    String alpha1 = idx1 == -1 ? chr1 : chr1.substring(0, idx1);
                    int alphaCmp = alpha1.compareTo(alpha2 = idx2 == -1 ? chr2 : chr2.substring(0, idx2));
                    if (alphaCmp != 0) {
                        return alphaCmp;
                    }
                    int dig1 = Integer.parseInt(chr1.substring(idx1));
                    int dig2 = Integer.parseInt(chr2.substring(idx2));
                    return dig1 - dig2;
                }
                if (idx1 == -1) {
                    return 1;
                }
                if (idx2 == -1) {
                    return -1;
                }
                return idx1 - idx2;
            }
            catch (Exception numberFormatException) {
                return 0;
            }
        }

        int findDigitIndex(String chr) {
            int n = chr.length() - 1;
            if (!Character.isDigit(chr.charAt(n))) {
                return -1;
            }
            for (int i = n - 1; i > 0; --i) {
                if (Character.isDigit(chr.charAt(i))) continue;
                return i + 1;
            }
            return 0;
        }
    }

    public static class ChromosomeCoordinate {
        private String chr;
        private int coordinate;

        public ChromosomeCoordinate(String chr, int coordinate) {
            this.chr = chr;
            this.coordinate = coordinate;
        }

        public String getChr() {
            return this.chr;
        }

        public int getCoordinate() {
            return this.coordinate;
        }
    }
}

