/*
 * Decompiled with CFR 0.152.
 */
package jannovar.reference;

import jannovar.annotation.AnnotatedVariantFactory;
import jannovar.annotation.Annotation;
import jannovar.annotation.AnnotationList;
import jannovar.annotation.BlockSubstitution;
import jannovar.annotation.DeletionAnnotation;
import jannovar.annotation.InsertionAnnotation;
import jannovar.annotation.IntergenicAnnotation;
import jannovar.annotation.IntronicAnnotation;
import jannovar.annotation.NoncodingAnnotation;
import jannovar.annotation.SingleNucleotideSubstitution;
import jannovar.annotation.SpliceAnnotation;
import jannovar.annotation.UTRAnnotation;
import jannovar.common.VariantType;
import jannovar.exception.AnnotationException;
import jannovar.interval.Interval;
import jannovar.interval.IntervalTree;
import jannovar.reference.TranscriptModel;
import jannovar.reference.Translator;
import java.util.ArrayList;
import java.util.HashMap;

public class Chromosome {
    private final byte chromosome;
    private final String chromosomeString;
    private final int n_genes;
    private static final int CAPACITY = 20;
    private static final int NEARGENE = 1000;
    private Translator translator = null;
    private AnnotatedVariantFactory annovarFactory = null;
    private IntervalTree<TranscriptModel> itree = null;

    public Chromosome(byte c, IntervalTree<TranscriptModel> intrvtree) {
        this.chromosomeString = null;
        this.chromosome = c;
        this.itree = intrvtree;
        this.translator = Translator.getTranslator();
        this.n_genes = 0;
        this.annovarFactory = new AnnotatedVariantFactory(20);
    }

    public String getChromosomeName() {
        if (this.chromosomeString != null) {
            return this.chromosomeString;
        }
        return String.format("chr%d", this.chromosome);
    }

    public int getNumberOfGenes() {
        return this.n_genes;
    }

    public AnnotationList getAnnotationList(int position, String ref, String alt) throws AnnotationException {
        if (ref.length() < alt.length() && alt.substring(0, ref.length()).equals(ref)) {
            alt = alt.substring(ref.length());
            position += ref.length();
            ref = "-";
        }
        TranscriptModel leftNeighbor = null;
        TranscriptModel rightNeighbor = null;
        this.annovarFactory.clearAnnotationLists();
        int start = position;
        int end = start + ref.length() - 1;
        ArrayList<TranscriptModel> candidateGenes = this.itree.search(start, end);
        if (candidateGenes.isEmpty()) {
            leftNeighbor = this.itree.getLeftNeighbor();
            rightNeighbor = this.itree.getRightNeighbor();
            this.createIntergenicAnnotations(start, end, leftNeighbor, rightNeighbor);
            return this.annovarFactory.getAnnotationList();
        }
        for (TranscriptModel kgl : candidateGenes) {
            if (kgl.isPlusStrand()) {
                this.getPlusStrandAnnotation(position, ref, alt, kgl);
                continue;
            }
            if (!kgl.isMinusStrand()) continue;
            this.getMinusStrandAnnotation(position, ref, alt, kgl);
        }
        AnnotationList al = this.annovarFactory.getAnnotationList();
        if (al.getAnnotationList().isEmpty()) {
            String e = String.format("[Jannovar:Chromosome] Error: No annotations produced for %s:g.%d%s>%s", this.chromosomeString, position, ref, alt);
            throw new AnnotationException(e);
        }
        return this.annovarFactory.getAnnotationList();
    }

    public void createIntergenicAnnotations(int start, int end, TranscriptModel leftNeighbor, TranscriptModel rightNeighbor) {
        Annotation ann;
        if (leftNeighbor != null && leftNeighbor.isNearThreePrimeEnd(start, 1000)) {
            ann = IntergenicAnnotation.createUpDownstreamAnnotation(leftNeighbor, start);
            this.annovarFactory.addUpDownstreamAnnotation(ann);
        }
        if (rightNeighbor != null && rightNeighbor.isNearFivePrimeEnd(end, 1000)) {
            ann = IntergenicAnnotation.createUpDownstreamAnnotation(rightNeighbor, end);
            this.annovarFactory.addUpDownstreamAnnotation(ann);
        }
        if (this.annovarFactory.isEmpty()) {
            if (leftNeighbor == null && rightNeighbor == null) {
                System.out.println("Both neighbors are null");
            }
            ann = IntergenicAnnotation.createIntergenicAnnotation(leftNeighbor, rightNeighbor, start, end);
            this.annovarFactory.addIntergenicAnnotation(ann);
        }
    }

    public void getPlusStrandAnnotation(int position, String ref, String alt, TranscriptModel kgl) throws AnnotationException {
        int cdsstart = kgl.getCDSStart();
        int cdsend = kgl.getCDSEnd();
        int exoncount = kgl.getExonCount();
        int start = position;
        int end = start + ref.length() - 1;
        int cumlenintron = 0;
        int cumlenexon = 0;
        int rvarstart = -1;
        int rvarend = -1;
        for (int k = 0; k < exoncount; ++k) {
            if (k > 0) {
                cumlenintron += kgl.getLengthOfIntron(k);
            }
            cumlenexon += kgl.getLengthOfExon(k);
            if (cdsstart >= kgl.getExonStart(k) && cdsstart <= kgl.getExonEnd(k)) {
                cumlenexon = kgl.getExonEnd(k) - cdsstart + 1;
            }
            if (SpliceAnnotation.isSpliceVariant(kgl, start, end, ref, alt, k)) {
                Annotation ann = SpliceAnnotation.getSpliceAnnotationPlusStrand(kgl, start, end, ref, alt, k, cumlenexon);
                if (kgl.isCodingGene()) {
                    this.annovarFactory.addExonicAnnotation(ann);
                } else {
                    ann.setVarType(VariantType.ncRNA_SPLICING);
                    this.annovarFactory.addNcRNASplicing(ann);
                }
                return;
            }
            if (start < kgl.getExonStart(k)) {
                if (end >= kgl.getExonStart(k)) {
                    rvarstart = kgl.getExonStart(k) - kgl.getTXStart() - cumlenintron + 1;
                    rvarend = kgl.getRVarEnd(end, k, cumlenintron);
                    if (end < cdsstart && kgl.isCodingGene()) {
                        Annotation ann = UTRAnnotation.createUTR5Annotation(kgl, rvarstart, ref, alt);
                        this.annovarFactory.addUTR5Annotation(ann);
                        break;
                    }
                    if (start > cdsend && kgl.isCodingGene()) {
                        Annotation ann = UTRAnnotation.createUTR3Annotation(kgl, rvarstart, ref, alt);
                        this.annovarFactory.addUTR3Annotation(ann);
                        break;
                    }
                    this.annotateExonicVariants(rvarstart, rvarend, start, end, ref, alt, k, kgl);
                    break;
                }
                if (k <= 0 || start <= kgl.getExonEnd(k - 1)) continue;
                Annotation ann = null;
                ann = kgl.isCodingGene() ? IntronicAnnotation.createIntronicAnnotation(kgl, k, start, end, ref, alt) : IntronicAnnotation.createNcRNAIntronicAnnotation(kgl, k, start, end, ref, alt);
                this.annovarFactory.addIntronicAnnotation(ann);
                return;
            }
            if (start > kgl.getExonEnd(k)) continue;
            rvarstart = start - kgl.getTXStart() - cumlenintron + 1;
            rvarend = kgl.getRVarEnd(end, k, cumlenintron);
            for (int m = k; m < kgl.getExonCount(); ++m) {
                if (m > k) {
                    cumlenintron += kgl.getLengthOfIntron(m);
                }
                if (end < kgl.getExonStart(m)) {
                    rvarend = kgl.getExonEnd(m - 1) - kgl.getTXStart() - cumlenintron + 1 + kgl.getLengthOfIntron(m - 1);
                    break;
                }
                if (end >= kgl.getExonEnd(m)) continue;
                rvarend = end - kgl.getTXStart() - cumlenintron + 1;
                break;
            }
            if (rvarend < 0) {
                rvarend = end - kgl.getTXStart() - cumlenintron + 1;
            }
            if (kgl.isNonCodingGene()) {
                ref = this.revcom(ref);
                alt = this.revcom(alt);
                Annotation ann = NoncodingAnnotation.createNoncodingExonicAnnotation(kgl, rvarstart, ref, alt, k);
                this.annovarFactory.addNonCodingRNAExonicAnnotation(ann);
                continue;
            }
            if (end < cdsstart) {
                Annotation ann = UTRAnnotation.createUTR5Annotation(kgl, rvarstart, ref, alt);
                this.annovarFactory.addUTR5Annotation(ann);
                continue;
            }
            if (start > cdsend) {
                Annotation ann = UTRAnnotation.createUTR3Annotation(kgl, rvarstart, ref, alt);
                this.annovarFactory.addUTR3Annotation(ann);
                continue;
            }
            this.annotateExonicVariants(rvarstart, rvarend, start, end, ref, alt, k + 1, kgl);
        }
    }

    public void getMinusStrandAnnotation(int position, String ref, String alt, TranscriptModel kgl) throws AnnotationException {
        int txstart = kgl.getTXStart();
        int txend = kgl.getTXEnd();
        int cdsstart = kgl.getCDSStart();
        int cdsend = kgl.getCDSEnd();
        int exoncount = kgl.getExonCount();
        int start = position;
        int end = start + ref.length() - 1;
        int cumlenintron = 0;
        int cumlenexon = 0;
        int rvarstart = -1;
        int rvarend = -1;
        for (int k = exoncount - 1; k >= 0; --k) {
            if (k < exoncount - 1) {
                cumlenintron += kgl.getExonStart(k + 1) - kgl.getExonEnd(k) - 1;
            }
            cumlenexon += kgl.getExonEnd(k) - kgl.getExonStart(k) + 1;
            if (cdsend <= kgl.getExonEnd(k) && cdsend >= kgl.getExonStart(k)) {
                cumlenexon = cdsend - kgl.getExonStart(k) + 1;
            }
            if (SpliceAnnotation.isSpliceVariant(kgl, start, end, ref, alt, k)) {
                Annotation ann = SpliceAnnotation.getSpliceAnnotationMinusStrand(kgl, start, end, ref, alt, k, cumlenexon);
                if (kgl.isCodingGene()) {
                    this.annovarFactory.addExonicAnnotation(ann);
                } else {
                    ann.setVarType(VariantType.ncRNA_SPLICING);
                    this.annovarFactory.addNcRNASplicing(ann);
                }
                return;
            }
            if (end > kgl.getExonEnd(k)) {
                if (start <= kgl.getExonEnd(k)) {
                    rvarstart = kgl.getTXEnd() - kgl.getExonEnd(k) - cumlenintron + 1;
                    for (int m = k; m >= 0; --m) {
                        if (m < k) {
                            cumlenintron += kgl.getExonStart(m + 1) - kgl.getExonEnd(m) - 1;
                        }
                        if (start > kgl.getExonEnd(m)) {
                            rvarend = kgl.getTXEnd() - kgl.getExonStart(m + 1) + 1 - cumlenintron + (kgl.getExonStart(m + 1) - kgl.getExonEnd(m) - 1);
                            break;
                        }
                        if (start < kgl.getExonStart(m)) continue;
                        rvarend = kgl.getTXEnd() - start - cumlenintron + 1;
                        break;
                    }
                    if (rvarend < 0) {
                        rvarend = kgl.getTXEnd() - kgl.getTXStart() - cumlenintron + 1;
                    }
                    if (kgl.isNonCodingGene()) {
                        String annot = kgl.getAccessionNumber();
                        Annotation ann = new Annotation(kgl, annot, VariantType.ncRNA_EXONIC);
                        this.annovarFactory.addNonCodingRNAExonicAnnotation(ann);
                        return;
                    }
                    if (end < cdsstart) {
                        alt = this.revcom(alt);
                        ref = this.revcom(ref);
                        Annotation ann = UTRAnnotation.createUTR3Annotation(kgl, rvarstart, ref, alt);
                        this.annovarFactory.addUTR3Annotation(ann);
                        return;
                    }
                    if (start > cdsend) {
                        alt = this.revcom(alt);
                        ref = this.revcom(ref);
                        Annotation ann = UTRAnnotation.createUTR5Annotation(kgl, rvarstart, ref, alt);
                        this.annovarFactory.addUTR5Annotation(ann);
                        return;
                    }
                    this.annotateExonicVariants(rvarstart, rvarend, start, end, ref, alt, k, kgl);
                    return;
                }
                if (k >= kgl.getExonCount() - 1 || end >= kgl.getExonStart(k + 1)) continue;
                alt = this.revcom(alt);
                ref = this.revcom(ref);
                Annotation ann = kgl.isCodingGene() ? IntronicAnnotation.createIntronicAnnotation(kgl, k, start, end, ref, alt) : IntronicAnnotation.createNcRNAIntronicAnnotation(kgl, k, start, end, ref, alt);
                this.annovarFactory.addIntronicAnnotation(ann);
                return;
            }
            if (end < kgl.getExonStart(k)) continue;
            rvarstart = txend - end - cumlenintron + 1;
            for (int m = k; m >= 0; --m) {
                if (m < k) {
                    cumlenintron += kgl.getExonStart(m + 1) - kgl.getExonEnd(m) - 1;
                }
                if (start > kgl.getExonEnd(m)) {
                    rvarend = txend - kgl.getExonStart(m + 1) + 1 - cumlenintron + (kgl.getExonStart(m + 1) - kgl.getExonEnd(m) - 1);
                    break;
                }
                if (start < kgl.getExonStart(m)) continue;
                rvarend = txend - start - cumlenintron + 1;
                break;
            }
            if (rvarend < 0) {
                rvarend = txend - txstart - cumlenintron + 1;
            }
            if (kgl.isNonCodingGene()) {
                ref = this.revcom(ref);
                alt = this.revcom(alt);
                Annotation ann = NoncodingAnnotation.createNoncodingExonicAnnotation(kgl, rvarstart, ref, alt, k);
                this.annovarFactory.addNonCodingRNAExonicAnnotation(ann);
                return;
            }
            if (end < cdsstart) {
                ref = this.revcom(ref);
                alt = this.revcom(alt);
                Annotation ann = UTRAnnotation.createUTR3Annotation(kgl, rvarstart, ref, alt);
                this.annovarFactory.addUTR3Annotation(ann);
                return;
            }
            if (start > cdsend) {
                ref = this.revcom(ref);
                alt = this.revcom(alt);
                Annotation ann = UTRAnnotation.createUTR5Annotation(kgl, rvarstart, ref, alt);
                this.annovarFactory.addUTR5Annotation(ann);
                continue;
            }
            this.annotateExonicVariants(rvarstart, rvarend, start, end, ref, alt, exoncount - k, kgl);
        }
    }

    private void annotateExonicVariants(int refvarstart, int refvarend, int start, int end, String ref, String var, int exonNumber, TranscriptModel kgl) throws AnnotationException {
        String wtnt3;
        int frame_s = (refvarstart - kgl.getRefCDSStart()) % 3;
        int frame_end_s = (refvarend - kgl.getRefCDSStart()) % 3;
        int refcdsstart = kgl.getRefCDSStart();
        if (refvarstart - frame_s - 1 > kgl.getActualSequenceLength()) {
            String s = String.format("%s, refvarstart=%d, frame_s=%d, seq len=%d", kgl.getAccessionNumber(), refvarstart, frame_s, kgl.getActualSequenceLength());
            Annotation ann = new Annotation(kgl, s, VariantType.ERROR);
            this.annovarFactory.addErrorAnnotation(ann);
        }
        if ((wtnt3 = kgl.getWTCodonNucleotides(refvarstart, frame_s)) == null) {
            String s = String.format("Discrepancy between mRNA length and genome annotation ", "(variant at pos. %d of transcript with mRNA length %d):%s[%s]", refvarstart, kgl.getMRNALength(), kgl.getAccessionNumber(), kgl.getName());
            Annotation ann = new Annotation(kgl, s, VariantType.ERROR);
            this.annovarFactory.addErrorAnnotation(ann);
            return;
        }
        String wtnt3_after = kgl.getWTCodonNucleotidesAfterVariant(refvarstart, frame_s);
        if (wtnt3.length() != 3 && refvarstart - frame_s - 1 >= 0) {
            String s = String.format("%s, wtnt3-length: %d", kgl.getAccessionNumber(), wtnt3.length());
            Annotation ann = new Annotation(kgl, s, VariantType.ERROR);
            this.annovarFactory.addErrorAnnotation(ann);
            return;
        }
        if (kgl.isMinusStrand()) {
            var = this.revcom(var);
            ref = this.revcom(ref);
        }
        if (start == end) {
            if (ref.equals("-")) {
                Annotation insrt = InsertionAnnotation.getAnnotation(kgl, frame_s, wtnt3, wtnt3_after, ref, var, refvarstart, exonNumber);
                this.annovarFactory.addExonicAnnotation(insrt);
            } else if (var.equals("-")) {
                Annotation dlt = DeletionAnnotation.getAnnotationSingleNucleotide(kgl, frame_s, wtnt3, wtnt3_after, ref, var, refvarstart, exonNumber);
                this.annovarFactory.addExonicAnnotation(dlt);
            } else if (var.length() > 1) {
                Annotation blck = BlockSubstitution.getAnnotationPlusStrand(kgl, frame_s, wtnt3, wtnt3_after, ref, var, refvarstart, refvarend, exonNumber);
                this.annovarFactory.addExonicAnnotation(blck);
            } else {
                Annotation mssns = SingleNucleotideSubstitution.getAnnotation(kgl, frame_s, frame_end_s, wtnt3, ref, var, refvarstart, exonNumber);
                this.annovarFactory.addExonicAnnotation(mssns);
            }
        } else if (var.equals("-")) {
            try {
                Annotation dltmnt = DeletionAnnotation.getMultinucleotideDeletionAnnotation(kgl, frame_s, wtnt3, wtnt3_after, ref, var, refvarstart, refvarend, exonNumber);
                this.annovarFactory.addExonicAnnotation(dltmnt);
            }
            catch (Exception ex) {
                System.err.println("Got error at position " + start + " end=" + end);
                throw new AnnotationException("Got exception: " + ex);
            }
        } else {
            String canno = String.format("%s:exon%d:c.%d_%ddelins%s", kgl.getName(), exonNumber, refvarstart - refcdsstart + 1, refvarend - refcdsstart + 1, var);
            if ((refvarend - refvarstart + 1 - var.length()) % 3 == 0) {
                Annotation ann = new Annotation(kgl, canno, VariantType.NON_FS_SUBSTITUTION, refvarstart);
                this.annovarFactory.addExonicAnnotation(ann);
            } else {
                Annotation ann = new Annotation(kgl, canno, VariantType.FS_SUBSTITUTION, refvarstart);
                this.annovarFactory.addExonicAnnotation(ann);
            }
        }
    }

    private String revcom(String sq) {
        if (sq.equals("-")) {
            return sq;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = sq.length() - 1; i >= 0; --i) {
            char c = sq.charAt(i);
            char match = '\u0000';
            switch (c) {
                case 'A': {
                    match = 'T';
                    break;
                }
                case 'C': {
                    match = 'G';
                    break;
                }
                case 'G': {
                    match = 'C';
                    break;
                }
                case 'T': {
                    match = 'A';
                    break;
                }
                case 'N': {
                    match = 'N';
                }
            }
            if (match <= '\u0000') continue;
            sb.append(match);
        }
        return sb.toString();
    }

    public static HashMap<Byte, Chromosome> constructChromosomeMapWithIntervalTree(ArrayList<TranscriptModel> kgList) {
        HashMap<Byte, Chromosome> chromosomeMap = new HashMap<Byte, Chromosome>();
        HashMap chrMap = new HashMap();
        for (TranscriptModel kgl : kgList) {
            byte chrom = kgl.getChromosome();
            if (!chrMap.containsKey(chrom)) {
                chrMap.put(chrom, new ArrayList());
            }
            ArrayList lst = (ArrayList)chrMap.get(chrom);
            Interval<TranscriptModel> in = new Interval<TranscriptModel>(kgl.getTXStart(), kgl.getTXEnd(), kgl);
            lst.add(in);
        }
        for (Byte chrom : chrMap.keySet()) {
            ArrayList transModelList = (ArrayList)chrMap.get(chrom);
            IntervalTree<TranscriptModel> itree = new IntervalTree<TranscriptModel>(transModelList);
            Chromosome chr = new Chromosome(chrom, itree);
            chromosomeMap.put(chrom, chr);
        }
        return chromosomeMap;
    }
}

