/*
 * Decompiled with CFR 0.152.
 */
package jannovar.io;

import jannovar.exception.ChromosomeScaffoldException;
import jannovar.exception.JannovarException;
import jannovar.exception.VCFParseException;
import jannovar.exome.Variant;
import jannovar.genotype.GenotypeFactoryA;
import jannovar.genotype.MultipleGenotypeFactory;
import jannovar.genotype.SingleGenotypeFactory;
import jannovar.io.VCFLine;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;

public class VCFReader {
    private String file_path = null;
    private String base_filename = null;
    private String firstVCFLine = null;
    private ArrayList<String> vcf_header = null;
    private ArrayList<String> formatLines = null;
    private ArrayList<String> infoLines = null;
    private ArrayList<String> contigLines = null;
    private ArrayList<Variant> variantList = null;
    private ArrayList<String> errorList = null;
    private HashSet<String> unparsableChromosomes = null;
    private int n_unparsable_chromosome_scaffold_variants;
    private int total_number_of_variants;
    private GenotypeFactoryA genofactory = null;
    public static final int FORMAT_GENOTYPE = 1;
    public static final int FORMAT_GENOTYPE_QUALITY = 2;
    public static final int FORMAT_LIKELIHOODS = 3;
    public static final int FORMAT_HIGH_QUALITY_BASES = 4;
    public static final int FORMAT_PHRED_STRAND_BIAS = 5;
    public static final int FORMAT_PHRED_GENOTYPE_LIKELIHOODS = 6;
    private ArrayList<String> sample_name_list = null;
    private ArrayList<String> unparsable_line_list = null;
    private boolean vcfHeaderIsInitialized;
    private BufferedReader in;
    private final boolean useExternalBufferedReader;
    private static final String infoEFFECT = "##INFO=<ID=EFFECT,Number=1,Type=String,Description=\"variant effect (UTR5,UTR3,intronic,splicing,missense,stoploss,stopgain,startloss,duplication,frameshift-insertion,frameshift-deletion,non-frameshift-deletion,non-frameshift-insertion,synonymous)\">";
    private static final String infoHGVS = "##INFO=<ID=HGVS,Number=1,Type=String,Description=\"HGVS Nomenclature\">";

    public int get_total_number_of_variants() {
        return this.total_number_of_variants;
    }

    public int getNumberOfSamples() {
        return this.sample_name_list.size();
    }

    public String getVCFFileName() {
        return this.base_filename;
    }

    public VCFReader(String vcfPath) throws VCFParseException {
        this.file_path = vcfPath;
        File file = new File(this.file_path);
        this.base_filename = file.getName();
        try {
            this.in = file.getName().endsWith(".gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(file)))) : new BufferedReader(new FileReader(this.file_path));
        }
        catch (IOException e) {
            String err = String.format("[VCFReader]: %s", e.toString());
            throw new VCFParseException(err);
        }
        this.useExternalBufferedReader = false;
        this.init();
    }

    public VCFReader(BufferedReader br) {
        this.in = br;
        this.useExternalBufferedReader = true;
        this.init();
    }

    private void init() {
        this.variantList = new ArrayList();
        this.vcf_header = new ArrayList();
        this.formatLines = new ArrayList();
        this.infoLines = new ArrayList();
        this.contigLines = new ArrayList();
        this.unparsable_line_list = new ArrayList<String>(){
            private boolean truncated = false;

            @Override
            public boolean add(String e) {
                if (this.size() < 1000) {
                    return super.add(e);
                }
                if (!this.truncated) {
                    this.truncated = true;
                    super.add("List truncated...");
                }
                return true;
            }
        };
        this.sample_name_list = new ArrayList();
        this.total_number_of_variants = 0;
        this.unparsableChromosomes = new HashSet();
        this.errorList = new ArrayList();
        this.n_unparsable_chromosome_scaffold_variants = 0;
        this.vcfHeaderIsInitialized = false;
    }

    public Iterator<Variant> getVariantIterator() throws JannovarException {
        if (this.in == null) {
            String s = "[VCFReader.java] Could not initialize the Variant Iterator";
            throw new JannovarException(s);
        }
        if (!this.vcfHeaderIsInitialized) {
            this.inputVCFheader();
        }
        return new VariantIterator(this.in);
    }

    public Iterator<VCFLine> getVCFLineIterator() throws JannovarException {
        if (this.in == null) {
            String s = "[VCFReader.java] Could not initialize the VCFLine Iterator";
            throw new JannovarException(s);
        }
        if (!this.vcfHeaderIsInitialized) {
            this.inputVCFheader();
        }
        return new VCFLineIterator(this.in);
    }

    public ArrayList<Variant> getVariantList() {
        return this.variantList;
    }

    public Variant VCFline2Variant(VCFLine line) {
        Variant v = line.toVariant();
        return v;
    }

    public ArrayList<String> getSampleNames() {
        return this.sample_name_list;
    }

    public ArrayList<String> getListOfUnparsableLines() {
        return this.unparsable_line_list;
    }

    public ArrayList<String> get_vcf_header() {
        ArrayList<String> lst = new ArrayList<String>();
        lst.add(this.firstVCFLine);
        lst.addAll(this.formatLines);
        lst.addAll(this.infoLines);
        lst.addAll(this.contigLines);
        lst.addAll(this.vcf_header);
        return lst;
    }

    public ArrayList<String> getAnnotatedVCFHeader() {
        ArrayList<String> lst = new ArrayList<String>();
        lst.add(this.firstVCFLine);
        lst.addAll(this.formatLines);
        lst.addAll(this.infoLines);
        lst.add(infoEFFECT);
        lst.add(infoHGVS);
        lst.addAll(this.contigLines);
        lst.addAll(this.vcf_header);
        return lst;
    }

    public ArrayList<String> get_html_message() {
        ArrayList<String> msg = new ArrayList<String>();
        if (this.base_filename != null) {
            msg.add(String.format("VCF file: %s (number of variants: %d)", this.base_filename, this.total_number_of_variants));
        } else {
            msg.add(String.format("Number of variants in VCF file: %d", this.total_number_of_variants));
        }
        if (!this.errorList.isEmpty()) {
            msg.add("Errors encountered while parsing VCF file:");
            msg.addAll(this.errorList);
        }
        if (!this.unparsable_line_list.isEmpty()) {
            msg.add("Could not parse the following lines:");
            msg.addAll(this.unparsable_line_list);
        }
        return msg;
    }

    public void parseFile() throws VCFParseException {
        try {
            if (!this.useExternalBufferedReader) {
                this.in = new BufferedReader(new FileReader(this.file_path));
            }
            if (!this.vcfHeaderIsInitialized) {
                this.inputVCFheader();
            }
            this.inputVCFStream();
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (IOException e) {
            String err = String.format("[VCFReader:parseFile]: %s", e.toString());
            throw new VCFParseException(err);
        }
    }

    private void inputVCFStream() throws IOException, VCFParseException {
        String line;
        while ((line = this.in.readLine()) != null) {
            VCFLine vcfline;
            try {
                vcfline = new VCFLine(line);
            }
            catch (ChromosomeScaffoldException cse) {
                this.unparsableChromosomes.add(cse.getMessage());
                ++this.n_unparsable_chromosome_scaffold_variants;
                continue;
            }
            catch (VCFParseException e) {
                this.unparsable_line_list.add(e + ": " + line);
                System.err.println("Warning: Skipping unparsable line: \n\t" + line);
                System.err.println("Exception: " + e.toString());
                continue;
            }
            Variant v = vcfline.toVariant();
            this.variantList.add(v);
            ++this.total_number_of_variants;
        }
    }

    private void recordBadChromosomeParses() {
        if (this.n_unparsable_chromosome_scaffold_variants == 0) {
            return;
        }
        Iterator<String> it = this.unparsableChromosomes.iterator();
        boolean first = true;
        StringBuffer sb = new StringBuffer();
        sb.append(this.n_unparsable_chromosome_scaffold_variants).append(" variants were identified from the following chromosome scaffolds: ");
        while (it.hasNext()) {
            String s = it.next();
            if (first) {
                sb.append(s);
                first = false;
                continue;
            }
            sb.append(", ").append(s);
        }
        this.errorList.add(sb.toString());
    }

    public void parse_chrom_line(String line) throws VCFParseException {
        String[] A = line.split("\t");
        if (!A[0].equals("#CHROM")) {
            throw new VCFParseException("[parse_chrom_line]: Malformed #CHROM field in #CHROM line: " + line);
        }
        if (!A[1].equals("POS")) {
            throw new VCFParseException("[parse_chrom_line]: Malformed POS field in #CHROM line:" + line);
        }
        if (!A[2].equals("ID")) {
            throw new VCFParseException("[parse_chrom_line]: Malformed ID field in #CHROM line:" + line);
        }
        if (!A[3].equals("REF")) {
            throw new VCFParseException("[parse_chrom_line]: Malformed REF field in #CHROM line:" + line);
        }
        if (!A[4].equals("ALT")) {
            throw new VCFParseException("[parse_chrom_line]: Malformed ALT field in #CHROM line:" + line);
        }
        if (!A[5].equals("QUAL")) {
            throw new VCFParseException("[parse_chrom_line]: Malformed QUAL field in #CHROM line:" + line);
        }
        if (!A[6].equals("FILTER")) {
            throw new VCFParseException("[parse_chrom_line]: Malformed FILTER field in #CHROM line:" + line);
        }
        if (!A[7].equals("INFO")) {
            throw new VCFParseException("[parse_chrom_line]: Malformed INFO field in #CHROM line:" + line);
        }
        if (!A[8].equals("FORMAT")) {
            String s = String.format("[parse_chrom_line]: Malformed FORMAT field in #CHROM line: %s", line);
            throw new VCFParseException(s);
        }
        if (A.length < 10) {
            String s = String.format("Error: Did not find sufficient number fields in the #CHROM line (need to be at least 10, but found %d): %s", A.length, line);
            throw new VCFParseException(s);
        }
        for (int i = 9; i < A.length; ++i) {
            this.sample_name_list.add(A[i]);
        }
    }

    public void inputVCFheader() throws VCFParseException {
        try {
            String line = this.in.readLine();
            if (line == null) {
                String err = String.format("Error: First line of VCF file (%s) was null", this.file_path);
                throw new VCFParseException(err);
            }
            if (!line.startsWith("##fileformat=VCF")) {
                String err = "Error: First line of VCF file did not start with format:" + line;
                throw new VCFParseException(err);
            }
            this.firstVCFLine = line;
            while ((line = this.in.readLine()) != null) {
                if (line.isEmpty()) continue;
                if (line.startsWith("##")) {
                    if (line.startsWith("##FORMAT")) {
                        this.formatLines.add(line);
                        continue;
                    }
                    if (line.startsWith("##INFO")) {
                        this.infoLines.add(line);
                        continue;
                    }
                    if (line.startsWith("##contig") || line.startsWith("##CONTIG")) {
                        this.contigLines.add(line);
                        continue;
                    }
                    this.vcf_header.add(line);
                    continue;
                }
                if (!line.startsWith("#CHROM")) continue;
                this.parse_chrom_line(line);
                this.vcf_header.add(line);
                int n = this.sample_name_list.size();
                this.genofactory = n == 1 ? new SingleGenotypeFactory() : new MultipleGenotypeFactory();
                break;
            }
        }
        catch (IOException e) {
            String s = String.format("[VCFReader.java] Error while reading VCF header: %s", e.getMessage());
            throw new VCFParseException(s);
        }
        VCFLine.setGenotypeFactory(this.genofactory);
        this.vcfHeaderIsInitialized = true;
    }

    public void printWarnings() {
        if (this.n_unparsable_chromosome_scaffold_variants > 0) {
            StringBuilder sb = new StringBuilder();
            boolean notfirst = false;
            for (String s : this.unparsableChromosomes) {
                if (notfirst) {
                    sb.append("; ");
                } else {
                    notfirst = true;
                }
                sb.append(s);
            }
            System.err.println(String.format("[WARN] %d variants found (and skipped) on chromosome scaffolds: %s", this.n_unparsable_chromosome_scaffold_variants, sb.toString()));
        }
        for (String s : this.errorList) {
            System.err.println("[WARN] " + s);
        }
    }

    class VCFLineIterator
    implements Iterator<VCFLine> {
        String nextline = null;
        VCFLine vcfline = null;
        private final BufferedReader in;

        VCFLineIterator(BufferedReader handle) {
            this.in = handle;
            try {
                this.moveToNextVCFLine();
            }
            catch (IOException e) {
                String s = String.format("[VCFLineIterator] IOException while initializing iterator: %s", e.getMessage());
                throw new RuntimeException(s);
            }
        }

        @Override
        public boolean hasNext() {
            return this.vcfline != null;
        }

        @Override
        public VCFLine next() {
            VCFLine previous = this.vcfline;
            try {
                this.moveToNextVCFLine();
            }
            catch (IOException e) {
                String s = String.format("[VCFIterator] IOException: %s", e.getMessage());
                throw new RuntimeException(s);
            }
            return previous;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void moveToNextVCFLine() throws IOException {
            while ((this.nextline = this.in.readLine()) != null) {
                try {
                    this.vcfline = new VCFLine(this.nextline);
                    if (this.vcfline == null) continue;
                    return;
                }
                catch (ChromosomeScaffoldException e) {
                    VCFReader.this.unparsableChromosomes.add(e.getMessage());
                    VCFReader.this.n_unparsable_chromosome_scaffold_variants++;
                }
                catch (VCFParseException e) {
                    VCFReader.this.unparsable_line_list.add(e + ": " + this.nextline);
                    System.err.println("Warning: Skipping unparsable line: \n\t" + this.nextline);
                    System.err.println("Exception: " + e.toString());
                }
            }
            this.vcfline = null;
            this.in.close();
        }
    }

    class VariantIterator
    implements Iterator<Variant> {
        String nextline = null;
        VCFLine vcfline = null;
        private final BufferedReader in;

        VariantIterator(BufferedReader handle) {
            this.in = handle;
            try {
                this.moveToNextVCFLine();
            }
            catch (IOException e) {
                String s = String.format("[VCFIterator] IOException while initializing iterator: %s", e.getMessage());
                throw new RuntimeException(s);
            }
        }

        @Override
        public boolean hasNext() {
            return this.vcfline != null;
        }

        @Override
        public Variant next() {
            Variant v = this.vcfline.toVariant();
            try {
                this.moveToNextVCFLine();
            }
            catch (IOException e) {
                String s = String.format("[VCFIterator] IOException: %s", e.getMessage());
                throw new RuntimeException(s);
            }
            return v;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void moveToNextVCFLine() throws IOException {
            while ((this.nextline = this.in.readLine()) != null) {
                try {
                    this.vcfline = new VCFLine(this.nextline);
                }
                catch (VCFParseException e) {
                    VCFReader.this.unparsable_line_list.add(e + ": " + this.nextline);
                }
                if (this.vcfline == null) continue;
                return;
            }
            this.vcfline = null;
            this.in.close();
        }
    }
}

