/*
 * Decompiled with CFR 0.152.
 */
package jannovar.io;

import jannovar.common.Constants;
import jannovar.exception.KGParseException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class UCSCDownloader
implements Constants {
    private String directory_path;
    private String hg19base = "http://hgdownload.soe.ucsc.edu/goldenPath/hg19/database/";

    public UCSCDownloader(String dirpath) {
        if (!dirpath.endsWith("/")) {
            dirpath = dirpath + "/";
        }
        this.directory_path = dirpath;
    }

    public String getDownloadDirectory() {
        return this.directory_path;
    }

    public UCSCDownloader(String dirpath, String proxyHost, String port) {
        this(dirpath);
        if (proxyHost == null) {
            return;
        }
        System.setProperty("proxySet", "true");
        if (proxyHost.startsWith("http://")) {
            proxyHost = proxyHost.substring(7);
        }
        System.setProperty("http.proxyHost", proxyHost);
        System.setProperty("http.proxyPort", port);
    }

    public void downloadUCSCfiles() throws KGParseException {
        this.makeDirectoryIfNotExist();
        String knownGene = String.format("%s.gz", "knownGene.txt");
        String knownGeneMrna = String.format("%s.gz", "knownGeneMrna.txt");
        String kgXref = String.format("%s.gz", "kgXref.txt");
        String known2locus = String.format("%s.gz", "knownToLocusLink.txt");
        this.download_file(this.hg19base, knownGene);
        this.download_file(this.hg19base, knownGeneMrna);
        this.download_file(this.hg19base, kgXref);
        this.download_file(this.hg19base, known2locus);
    }

    private void makeDirectoryIfNotExist() {
        File directory = new File(this.directory_path);
        if (directory.exists()) {
            System.err.println(String.format("Cowardly refusing to create directory \"%s\" since it already exists", this.directory_path));
        } else {
            directory.mkdir();
        }
    }

    public boolean download_file(String baseURL, String fname) throws KGParseException {
        String urlstring = baseURL + fname;
        String local_file_path = this.directory_path + fname;
        File f = new File(local_file_path);
        if (f.exists()) {
            System.out.println(String.format("[INFO] Timorously refusing to download file \"%s\" since it already exists", local_file_path));
            return false;
        }
        System.out.println("[INFO] Downloading: \"" + urlstring + "\"");
        int threshold = 0;
        int block = 250000;
        try {
            URL url = new URL(urlstring);
            URLConnection urlc = url.openConnection();
            InputStream reader = urlc.getInputStream();
            FileOutputStream writer = new FileOutputStream(local_file_path);
            byte[] buffer = new byte[153600];
            int totalBytesRead = 0;
            int bytesRead = 0;
            int size = urlc.getContentLength();
            if (size >= 0) {
                block = size / 20;
            }
            System.out.println("0%       50%      100%");
            while ((bytesRead = reader.read(buffer)) > 0) {
                writer.write(buffer, 0, bytesRead);
                buffer = new byte[153600];
                if ((totalBytesRead += bytesRead) <= threshold) continue;
                System.out.print("=");
                threshold += block;
            }
            System.out.println();
            System.out.println("[INFO] Done. " + new Integer(totalBytesRead).toString() + "(" + size + ") bytes read.");
            writer.close();
            reader.close();
        }
        catch (MalformedURLException e) {
            String err = String.format("Could not interpret url: \"%s\"\n%s", urlstring, e.toString());
            throw new KGParseException(err);
        }
        catch (IOException e) {
            String err = String.format("IO Exception reading from URL: \"%s\"\n%s", urlstring, e.toString());
            throw new KGParseException(err);
        }
        return true;
    }
}

