/*
 * Decompiled with CFR 0.152.
 */
package jannovar.io;

import jannovar.common.FeatureType;
import jannovar.exception.FeatureFormatException;
import jannovar.gff.Feature;
import jannovar.gff.TranscriptModelBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

public class GFFparser {
    private static final Logger logger = Logger.getLogger(GFFparser.class.getSimpleName());
    private static final int SEQID = 0;
    private static final int SOURCE = 1;
    private static final int TYPE = 2;
    private static final int START = 3;
    private static final int END = 4;
    private static final int SCORE = 5;
    private static final int STRAND = 6;
    private static final int PHASE = 7;
    private static final int ATTRIBUTES = 8;
    private File file;
    private String[] fields;
    private BufferedReader in;
    private TranscriptModelBuilder transcriptBuilder;
    private int gff_version = 2;
    private int start;
    private int index;
    private int subIndex;
    private String rawfeature;
    private String valueSeparator = " ";

    public void setValueSeparator(String sep) {
        this.valueSeparator = sep;
    }

    public boolean checkFile() {
        return this.file.canRead();
    }

    public int getGFFversion() {
        return this.gff_version;
    }

    public void setGFFversion(int i) {
        this.gff_version = i;
        this.valueSeparator = i == 3 ? "=" : " ";
    }

    private void determineGFFversion() throws IOException {
        String str;
        this.in = this.file.getName().endsWith(".gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(this.file)))) : new BufferedReader(new FileReader(this.file));
        while ((str = this.in.readLine()) != null && str.startsWith("#")) {
            if (!str.startsWith("##gff-version")) continue;
            this.fields = str.split(" ");
            try {
                int version;
                this.gff_version = version = Integer.parseInt(this.fields[1]);
            }
            catch (NumberFormatException e) {
                System.err.println("Failed to parse gff-version: " + str);
            }
        }
        logger.log(Level.INFO, "gff version: {0}", this.gff_version);
    }

    public void parse(String filename) {
        this.parse(new File(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(File file) {
        this.file = file;
        this.transcriptBuilder = new TranscriptModelBuilder();
        try {
            String str;
            logger.info("Get GFF version");
            this.determineGFFversion();
            this.valueSeparator = this.gff_version == 3 ? "=" : " ";
            this.transcriptBuilder.setGffversion(this.gff_version);
            logger.info("Read features");
            this.in = file.getName().endsWith(".gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(file)))) : new BufferedReader(new FileReader(file));
            while ((str = this.in.readLine()) != null) {
                if (str.startsWith("#")) continue;
                this.transcriptBuilder.addFeature(this.processFeature(str));
            }
        }
        catch (FeatureFormatException e) {
            System.err.println("[WARNING] GFF with wrong Feature format:\n" + e.toString());
        }
        catch (IOException e) {
            System.err.println("[WARNING] failed to read the GFF file:\n" + e.toString());
        }
        finally {
            try {
                if (this.in != null) {
                    this.in.close();
                }
            }
            catch (IOException e) {
                System.err.println("[WARNING] failed to close the GFF file reader:\n" + e.toString());
            }
        }
    }

    public TranscriptModelBuilder getTranscriptModelBuilder() {
        return this.transcriptBuilder;
    }

    public Feature processFeature(String featureLine) throws FeatureFormatException {
        ArrayList<String> myfields = new ArrayList<String>();
        this.start = 0;
        while ((this.index = featureLine.indexOf(9, this.start)) >= 0) {
            myfields.add(featureLine.substring(this.start, this.index));
            this.start = this.index + 1;
        }
        if (this.start != featureLine.length()) {
            myfields.add(featureLine.substring(this.start));
        }
        if (myfields.size() < 9) {
            logger.warning(String.format("skipping malformed feature line (missing columns (%d)): ", myfields.size(), featureLine));
            return null;
        }
        Feature feature = new Feature();
        feature.setSequence_id((String)myfields.get(0));
        feature.setType(this.codeType((String)myfields.get(2)));
        feature.setStart(Integer.parseInt((String)myfields.get(3)));
        feature.setEnd(Integer.parseInt((String)myfields.get(4)));
        feature.setStrand(this.codeStrand((String)myfields.get(6)));
        feature.setPhase(this.codePhase((String)myfields.get(7)));
        feature.setAttributes(this.processAttributes((String)myfields.get(8)));
        return feature;
    }

    private byte codePhase(String phase) {
        if (phase.equals("0")) {
            return 0;
        }
        if (phase.equals("1")) {
            return 1;
        }
        if (phase.equals("2")) {
            return 2;
        }
        return -1;
    }

    private HashMap<String, String> processAttributes(String attributeString) throws FeatureFormatException {
        HashMap<String, String> attributes = new HashMap<String, String>();
        this.start = 0;
        if (attributeString.startsWith(" ")) {
            attributeString = attributeString.substring(1);
        }
        while ((this.index = attributeString.indexOf(";", this.start)) > 0) {
            this.rawfeature = attributeString.substring(this.start, this.index);
            this.splitNaddAttribute(this.rawfeature, attributes);
            if (this.gff_version == 3) {
                this.start = this.index + 1;
                continue;
            }
            this.start = this.index + 2;
        }
        if (this.start < attributeString.length()) {
            this.rawfeature = attributeString.substring(this.start);
            this.splitNaddAttribute(this.rawfeature, attributes);
        }
        return attributes;
    }

    private void splitNaddAttribute(String attribute, HashMap<String, String> attributes) throws FeatureFormatException {
        this.subIndex = this.rawfeature.indexOf(this.valueSeparator);
        if (this.subIndex > 0) {
            if (this.gff_version == 3) {
                attributes.put(this.rawfeature.substring(0, this.subIndex), this.rawfeature.substring(this.subIndex + 1));
            } else {
                attributes.put(this.rawfeature.substring(0, this.subIndex), this.rawfeature.substring(this.subIndex + 2, this.rawfeature.length() - 1));
            }
        } else {
            throw new FeatureFormatException("attribut String without valid value separator ('" + this.valueSeparator + "'): '" + attribute + "'");
        }
    }

    private boolean codeStrand(String strand) throws FeatureFormatException {
        if (strand.equals("+")) {
            return true;
        }
        if (strand.equals("-")) {
            return false;
        }
        throw new FeatureFormatException("unknown strand: " + strand);
    }

    private FeatureType codeType(String type) throws FeatureFormatException {
        if (type.equals("exon")) {
            return FeatureType.EXON;
        }
        if (type.equals("CDS")) {
            return FeatureType.CDS;
        }
        if (type.equals("start_codon")) {
            return FeatureType.START_CODON;
        }
        if (type.equals("stop_codon")) {
            return FeatureType.STOP_CODON;
        }
        if (type.equals("gene")) {
            return FeatureType.GENE;
        }
        if (type.equals("mRNA")) {
            return FeatureType.MRNA;
        }
        if (type.equals("transcript")) {
            return FeatureType.TRANSCRIPT;
        }
        if (type.equals("region")) {
            return FeatureType.REGION;
        }
        if (type.equals("ncRNA")) {
            return FeatureType.NCRNA;
        }
        if (type.equals("tRNA")) {
            return FeatureType.TRNA;
        }
        return FeatureType.UNKNOWN;
    }
}

