/*
 * Decompiled with CFR 0.152.
 */
package jannovar.interval;

import jannovar.interval.Interval;
import jannovar.interval.LeftComparator;
import jannovar.interval.RightComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class Node<T> {
    private int median;
    private Node<T> leftNode;
    private Node<T> rightNode;
    public List<Interval<T>> leftorder;
    public List<Interval<T>> rightorder;
    private Comparator<? extends Interval> leftcomp = null;
    private Comparator<? extends Interval> rightcomp = null;

    private Node() {
    }

    public Node(List<Interval<T>> intervals, LeftComparator leftcomp2, RightComparator rightcomp2) {
        ArrayList<Integer> endpointslist = new ArrayList<Integer>();
        for (Interval<T> interval : intervals) {
            endpointslist.add(interval.getLow());
            endpointslist.add(interval.getHigh());
        }
        this.median = this.calculateMedian(endpointslist);
        ArrayList<Interval<T>> lefts = new ArrayList<Interval<T>>();
        ArrayList<Interval<T>> rights = new ArrayList<Interval<T>>();
        ArrayList<Interval<T>> medianIntervals = new ArrayList<Interval<T>>();
        for (Interval<T> interval : intervals) {
            if (interval.getHigh() < this.median) {
                lefts.add(interval);
                continue;
            }
            if (interval.getLow() > this.median) {
                rights.add(interval);
                continue;
            }
            medianIntervals.add(interval);
        }
        this.leftcomp = leftcomp2;
        this.rightcomp = rightcomp2;
        this.leftorder = new ArrayList<Interval<T>>();
        this.rightorder = new ArrayList<Interval<T>>();
        Collections.sort(medianIntervals, leftcomp2);
        this.leftorder.addAll(medianIntervals);
        Collections.sort(medianIntervals, rightcomp2);
        this.rightorder.addAll(medianIntervals);
        if (lefts.size() > 0) {
            this.leftNode = new Node<T>(lefts, leftcomp2, rightcomp2);
        }
        if (rights.size() > 0) {
            this.rightNode = new Node<T>(rights, leftcomp2, rightcomp2);
        }
    }

    private Integer calculateMedian(List<Integer> list) {
        Collections.sort(list);
        int mid = list.size() / 2;
        int mymedian = list.get(mid);
        if (list.size() % 2 == 0) {
            mymedian = (mymedian + list.get(mid - 1)) / 2;
        }
        return mymedian;
    }

    public int getMedian() {
        return this.median;
    }

    public Interval<T> getLeftmostItem() {
        return this.leftorder.isEmpty() ? null : this.leftorder.get(0);
    }

    public Interval<T> getRightmostItem() {
        return this.rightorder.isEmpty() ? null : this.rightorder.get(0);
    }

    public boolean isEmpty() {
        return this.rightorder.isEmpty();
    }

    public boolean hasInterval() {
        return this.rightorder.size() > 0;
    }

    public Node<T> getRightmostDescendentOfLeftChild() {
        Node<T> n = this.getLeft();
        if (n == null) {
            return null;
        }
        while (n.getRight() != null) {
            n = n.getRight();
        }
        return n;
    }

    public Node<T> getLeftmostDescendentOfRightChild() {
        Node<T> n = this.getRight();
        if (n == null) {
            return null;
        }
        while (n.getLeft() != null) {
            n = n.getLeft();
        }
        return n;
    }

    public Node<T> getLeft() {
        return this.leftNode;
    }

    public Node<T> getRight() {
        return this.rightNode;
    }

    public void debugPrint(String type, int level) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            sb.append("-");
        }
        sb.append("(").append(level).append(")");
        String indent = new String(sb);
        System.out.print(indent);
        if (type != null) {
            System.out.println(String.format("%s,Node:  %d intervals crossing median [%d]:", type, this.leftorder.size(), this.median));
        } else {
            System.out.println(String.format("Node:  %d intervals crossing median [%d]:", this.leftorder.size(), this.median));
        }
        for (Interval<T> i : this.leftorder) {
            System.out.println(indent + "##(leftorder):" + i);
        }
        for (Interval<T> i : this.rightorder) {
            System.out.println(indent + "##(rightorder):" + i);
        }
        System.out.println();
        Node<T> l = this.getLeft();
        if (l == null) {
            System.out.print(indent);
            System.out.println("-:Left=null");
        } else {
            l.debugPrint("L", level + 1);
        }
        Node<T> r = this.getRight();
        if (r == null) {
            System.out.print(indent);
            System.out.println("-:Right=null");
        } else {
            r.debugPrint("R", level + 1);
        }
    }

    public String toString() {
        return String.format("[Node]: median: %d, number of items: %d", this.median, this.leftorder.size());
    }
}

