/*
 * Decompiled with CFR 0.152.
 */
package jannovar.exome;

import jannovar.common.Constants;
import jannovar.common.VariantType;
import jannovar.exception.JannovarException;
import jannovar.exome.Variant;
import jannovar.genotype.GenotypeCall;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class VariantTypeCounter
implements Constants {
    private HashMap<VariantType, Integer> variantTypeInd = null;
    private int[][] countMatrix = null;
    private int n_persons;
    private int n_var_types;

    private VariantTypeCounter() {
    }

    public VariantTypeCounter(int n) {
        this.n_var_types = VariantType.size();
        this.n_persons = n;
        this.countMatrix = new int[this.n_persons][this.n_var_types];
        this.initializeVarTypeIndices();
    }

    public VariantTypeCounter(ArrayList<Variant> variantList) throws JannovarException {
        this.n_var_types = VariantType.size();
        this.n_persons = variantList.get(0).getGenotype().getNumberOfIndividuals();
        this.countMatrix = new int[this.n_persons][this.n_var_types];
        this.initializeVarTypeIndices();
        this.countVariants(variantList);
    }

    public void incrementCount(Variant v) {
        VariantType vtype = v.getVariantTypeConstant();
        GenotypeCall gtc = v.getGenotype();
        int vtypeIndex = this.variantTypeInd.get((Object)vtype);
        for (int i = 0; i < this.n_persons; ++i) {
            if (!gtc.isALTInIndividualN(i)) continue;
            int[] nArray = this.countMatrix[i];
            int n = vtypeIndex;
            nArray[n] = nArray[n] + 1;
        }
    }

    private void countVariants(ArrayList<Variant> variantList) throws JannovarException {
        int N = variantList.size();
        for (int j = 0; j < N; ++j) {
            Variant v = variantList.get(j);
            VariantType vt = v.getVariantTypeConstant();
            int vtypeIndex = this.variantTypeInd.get((Object)vt);
            GenotypeCall gtc = v.getGenotype();
            for (int i = 0; i < this.n_persons; ++i) {
                if (!gtc.isALTInIndividualN(i)) continue;
                int[] nArray = this.countMatrix[i];
                int n = vtypeIndex;
                nArray[n] = nArray[n] + 1;
            }
        }
    }

    private void initializeVarTypeIndices() {
        this.variantTypeInd = new HashMap();
        VariantType[] vtypes = VariantType.getPrioritySortedList();
        for (int i = 0; i < vtypes.length; ++i) {
            this.variantTypeInd.put(vtypes[i], i);
        }
    }

    public Iterator<VariantType> getVariantTypeIterator() {
        return new VariantTypeIterator();
    }

    public ArrayList<Integer> getTypeSpecificCounts(VariantType vt) {
        int idx = this.variantTypeInd.get((Object)vt);
        ArrayList<Integer> cts = new ArrayList<Integer>();
        for (int k = 0; k < this.n_persons; ++k) {
            cts.add(this.countMatrix[k][idx]);
        }
        return cts;
    }

    class VariantTypeIterator
    implements Iterator<VariantType> {
        private final int max;
        private int i = 0;
        VariantType[] vta = VariantType.getPrioritySortedList();

        VariantTypeIterator() {
            this.max = this.vta.length;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.max;
        }

        @Override
        public VariantType next() {
            VariantType vt = this.vta[this.i];
            ++this.i;
            return vt;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

